/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.io.PMGameData;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMTimer;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.rflib.util.PMTrigonometry;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.SaveGameHelper;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.game.StateGame;

public class Main {
    public static int loadBarWidth = 0;
    public static int counter = 0;
    public static String loadingStr = null;

    public static void init() {
        PMLocale.set(PMLocale.getDefault());
        PMTimer.setTick(0L);
        Main.preMenuInit();
        SaveGameHelper.init();
        PMAudio.initAudio(31);
        PMAudio.loadRegOnly(15, "sfxPlayerJump", 6, 2434);
        PMAudio.loadRegOnly(10, "sfxPlayerJumpTotem1", 6, 2874);
        PMAudio.loadRegOnly(8, "sfxPlayerJumpTotem3", 6, 2840);
        PMAudio.loadRegOnly(9, "sfxLandOnMonster", 6, 1984);
        PMAudio.loadRegOnly(0, "sfxPlayerLoseHealthMonster", 6, 2518);
        PMAudio.loadRegOnly(13, "sfxPlayerLoseLife", 6, 5606);
        PMAudio.loadRegOnly(14, "sfxPlayerGainLife", 6, 6920);
        PMAudio.loadRegOnly(11, "sfxPlayerGainSilverCoin", 6, 3290);
        PMAudio.loadRegOnly(12, "sfxPlayerGainGoldCoin", 6, 9832);
        PMAudio.loadRegOnly(24, "sfxPlayerGainKey", 6, 6106);
        PMAudio.loadRegOnly(25, "sfxPlayerOpenChest", 6, 10566);
        PMAudio.loadRegOnly(22, "sfxPlayerGainHealth", 6, 3494);
        PMAudio.loadRegOnly(23, "sfxPlayerCheckpoint", 6, 7150);
        PMAudio.loadRegOnly(26, "sfxPlayerExit1", 6, 15162);
        PMAudio.loadRegOnly(29, "sfxPlayerTotemTransition", 6, 5728);
        PMAudio.loadRegOnly(30, "sfxEnemyJump", 6, 2542);
        PMAudio.loadRegOnly(27, "sfxEnemyShoot", 6, 3150);
        PMAudio.loadRegOnly(28, "sfxEnemySpikes", 6, 9942);
        PMAudio.loadRegOnly(18, "sfxPauseMenuSelectItem", 6, 1358);
        PMAudio.loadRegOnly(16, "sfxLevelSelectFootsteps", 6, 3806);
        PMAudio.loadRegOnly(17, "sfxLevelSelectStartLevel", 6, 11590);
        PMAudio.loadRegOnly(20, "sfxLevelSelectCannotWalk", 6, 3798);
        PMAudio.loadRegOnly(21, "sfxCutsceneSkip", 6, 2962);
        PMAudio.loadRegOnly(19, "sfxSceneSkip", 6, 1426);
        PMAudio.loadRegOnly(3, "sfxWorldChange1", 6, 3658);
        PMAudio.loadRegOnly(4, "sfxMainMenuDelete", 6, 2666);
        PMAudio.loadRegOnly(1, "sfxMainMenuNew", 6, 538);
        PMAudio.loadRegOnly(2, "sfxMainMenuLoad", 6, 5954);
        PMAudio.loadRegOnly(5, "sfxDanger2", 6, 5030);
        PMAudio.loadRegOnly(6, "sfxDanger3Rumble", 6, 14912);
        PMAudio.loadRegOnly(7, "sfxDanger3Hit", 6, 12102);
        MusicBuffer.init();
        PMStateManager.set(8, 0);
    }

    public static void preExit() {
        Dialog.deinit();
    }

    public static void preFlush() {
        SoundBuffer.update();
        MusicBuffer.update();
        Touch.clearReleased();
        InputProxy.checkForKeyInput();
    }

    public static void toggleAnalogControls() {
        if (GameState.mIsSingleTouch) {
            GameState.mAnalogTouch = GameState.mAnalogTouch == 0 ? (byte)1 : 0;
            Touch.setControlOverlay();
        }
    }

    public static void preMenuInit() {
        PMRandom.init(0);
        PMFile.initBFC();
        GameState.mAnalogTouch = 0;
        GameState.mIsSingleTouch = true;
        PMGameData.load();
        PMImageManager.init();
        PMTrigonometry.init();
        PMFont.init(3);
        PMFont.load(0, (short)-17682, (short)30525, (short)-13740, (byte)7, (short)-31608, -1, -2, 0);
        PMFont.load(1, (short)11295, (short)-7732, (short)23717, (byte)4, (short)4729, 1, -2, 0);
        PMFont.load(2, (short)-32074, (short)20325, (short)-3572, (byte)4, (short)-17200, 1, -2, 0);
        InputProxy.init();
    }

    public static void externalEvent() {
    }

    public static void drawExternal() {
    }

    public static void drawIncorrectRotation() {
    }

    public static void drawLoading() {
        PMCanvas.PMGraphics_setColor(0, 0, 0);
        ++loadBarWidth;
        if (counter % 10 == 0) {
            PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
            if (loadBarWidth > 320) {
                loadBarWidth = 0;
            }
            PMCanvas.PMGraphics_setColor(255, 255, 255);
            PMCanvas.PMGraphics_fillRect(0, 228, loadBarWidth, 6);
            PMCanvas.PMGraphics_setColor(208, 139, 25);
            PMCanvas.PMGraphics_fillRect(0, 60, 320, 120);
            PMCanvas.PMGraphics_setColor(116, 79, 19);
            PMCanvas.PMGraphics_drawLine(0, 60, 320, 60);
            PMCanvas.PMGraphics_drawLine(0, 180, 320, 180);
            int n = PMMath.DIV(0x1400000, 0x110000);
            n = (n >> 16) + 1;
            boolean bl = PMFile.loadScreen;
            PMFile.loadScreen = false;
            for (int i = 0; i < n; ++i) {
                int n2 = 0 + i * 17;
                PMImageManager.draw(502, n2, 67);
                PMImageManager.draw(506, n2, 173);
            }
            if (loadingStr == null) {
                loadingStr = PMText.getText(131072);
            }
            PMCanvas.PMGraphics_drawStringBox(0, 113, 320, 240, loadingStr, 0, 0, 99, true);
            PMFile.loadScreen = bl;
        }
        ++counter;
        PMCanvas.PMInput_reset();
        PMCanvas.PMGraphics_flush();
    }

    public static void touchDown(int n, int n2, int n3, int n4) {
    }

    public static void touchMove(int n, int n2, int n3, int n4) {
    }

    public static void touchUp(int n, int n2, int n3, int n4) {
    }

    public static void Complete_Level() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.runEndLevelCode();
        }
    }

    public static void Gain_Goldcoin() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.debugGainGoldcoin();
        }
    }

    public static void Gain_Chest() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.debugGainChest();
        }
    }

    public static void nextScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.nextScriptEvent();
        }
    }

    public static void prevScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.prevScriptEvent();
        }
    }

    public static void runScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.runScriptEvent();
        }
    }
}

