/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.script.Script;

public class ScriptHelper {
    private static final int SCRIPT_QUEUE_SIZE = 3;
    public static final byte EVENT_LEVEL_STARTED = 0;
    public static final byte EVENT_SIGN_JUMP = 1;
    public static final byte EVENT_SIGN_SILVER_COIN = 2;
    public static final byte EVENT_SIGN_HEALTH_FULL = 3;
    public static final byte EVENT_SIGN_HEALTH_NOT_FULL = 4;
    public static final byte EVENT_SIGN_MONSTER = 5;
    public static final byte EVENT_SIGN_GOLD_COIN = 6;
    public static final byte EVENT_SIGN_CHEST = 7;
    public static final byte EVENT_SIGN_SMALLER = 8;
    public static final byte EVENT_SIGN_TOTEM1 = 9;
    public static final byte EVENT_SIGN_TOTEM2 = 10;
    public static final byte EVENT_SIGN_STRONGER = 11;
    public static final byte EVENT_SIGN_TOTEM3 = 12;
    public static final byte EVENT_CHEST_OPENED = 13;
    public static final byte EVENT_CHECKPOINT = 14;
    public static final byte EVENT_LEVEL_COMPLETED = 15;
    public static final byte EVENT_SLIPPERY_SURFACE = 16;
    public static final byte EVENT_SILVER_COIN_LIFE = 17;
    public static final byte EVENT_TOTEM1_TRANSITION = 18;
    public static final byte EVENT_TOTEM2_TRANSITION = 19;
    public static final byte EVENT_TOTEM3_TRANSITION = 20;
    public static final byte EVENT_LOSE_LIFE = 21;
    public static final byte EVENT_ALL_COLLECTED = 22;
    public static final byte EVENT_LOCKED_TOTEM_PRESSED = 23;
    private static short[] mScriptIDs = new short[]{-16818, -12631, -26273, -30338, -18147, -22212, -9765, -13830, -1639, -5704, -12242, -8115, -3988, -32629, -28502, -24375, 16647, 20774, -9937, -5812, -1683, -30326, -26197, -22072, -17943, 18438, 22567, -450, -4577};
    private Script[] mScripts = new Script[mScriptIDs.length];
    private int mScriptQueueProgress;
    private int mScriptQueueAddIndex;
    private Script[] mScriptQueue;
    private boolean mActivated;

    public ScriptHelper() {
        int n;
        for (n = 0; n < mScriptIDs.length; ++n) {
            this.mScripts[n] = Script.load(mScriptIDs[n]);
        }
        this.mScriptQueue = new Script[3];
        for (n = 0; n < this.mScriptQueue.length; ++n) {
            this.mScriptQueue[n] = null;
        }
        this.mScriptQueueProgress = 0;
        this.mScriptQueueAddIndex = 0;
        this.mActivated = false;
    }

    public void update() {
        if (this.mScriptQueue[this.mScriptQueueProgress] != null) {
            this.mScriptQueue[this.mScriptQueueProgress].update(Timer.mDt);
            if (this.mScriptQueue[this.mScriptQueueProgress].isDone() && !Dialog.isActive()) {
                ++this.mScriptQueueProgress;
                if (this.mScriptQueue[this.mScriptQueueProgress] == null) {
                    for (int i = 0; i < this.mScriptQueue.length; ++i) {
                        this.mScriptQueue[i] = null;
                    }
                    this.mScriptQueueProgress = 0;
                    this.mScriptQueueAddIndex = 0;
                }
            }
        }
    }

    public void handleEvent(byte by) {
        int n;
        if (this.mScriptQueue[this.mScriptQueueProgress] != null || !this.mActivated) {
            return;
        }
        switch (by) {
            case 0: {
                n = Defines.mWorldLookup[GameState.mLevel];
                boolean bl = Defines.mWorldStartLookup[GameState.mLevel];
                if (n == 0 && bl) {
                    if ((GameState.mScriptStateGlobal & 1L) == 0L) {
                        this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[0];
                        GameState.mScriptStateGlobal |= 1L;
                    }
                } else if (n == 1 && bl) {
                    if ((GameState.mScriptStateGlobal & 2L) == 0L) {
                        this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[6];
                        GameState.mScriptStateGlobal |= 2L;
                    }
                } else if (n == 2 && bl) {
                    if ((GameState.mScriptStateGlobal & 4L) == 0L) {
                        this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[7];
                        GameState.mScriptStateGlobal |= 4L;
                    }
                } else if (n == 3 && bl) {
                    if ((GameState.mScriptStateGlobal & 8L) == 0L) {
                        this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[8];
                        GameState.mScriptStateGlobal |= 8L;
                    }
                } else if (n == 4 && bl && (GameState.mScriptStateGlobal & 0x10L) == 0L) {
                    this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[9];
                    GameState.mScriptStateGlobal |= 0x10L;
                }
                if (n <= 0 || (GameState.mScriptStateGlobal & 0x200L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[2];
                GameState.mScriptStateGlobal |= 0x200L;
                break;
            }
            case 13: {
                if ((GameState.mScriptStateGlobal & 0x20L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[1];
                GameState.mScriptStateGlobal |= 0x20L;
                break;
            }
            case 14: {
                if ((GameState.mScriptStateGlobal & 0x40L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[3];
                GameState.mScriptStateGlobal |= 0x40L;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                if ((GameState.mScriptStateGlobal & 0x100L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[5];
                GameState.mScriptStateGlobal |= 0x100L;
                break;
            }
            case 17: {
                if ((GameState.mScriptStateGlobal & 0x1AL) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[12];
                GameState.mScriptStateGlobal |= 0x1AL;
                break;
            }
            case 18: {
                if ((GameState.mScriptStateGlobal & 0x1BL) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[13];
                GameState.mScriptStateGlobal |= 0x1BL;
                break;
            }
            case 19: {
                if ((GameState.mScriptStateGlobal & 0x1CL) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[14];
                GameState.mScriptStateGlobal |= 0x1CL;
                break;
            }
            case 20: {
                if ((GameState.mScriptStateGlobal & 0x1DL) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[15];
                GameState.mScriptStateGlobal |= 0x1DL;
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                if ((GameState.mScriptStateGlobal & 0x1FL) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[11];
                GameState.mScriptStateGlobal |= 0x1FL;
                break;
            }
            case 23: {
                if ((GameState.mScriptStateGlobal & 0x20L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[17];
                GameState.mScriptStateGlobal |= 0x20L;
                break;
            }
            case 1: {
                if ((GameState.mScriptStateGlobal & 0x800L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[18];
                GameState.mScriptStateGlobal |= 0x800L;
                break;
            }
            case 2: {
                if ((GameState.mScriptStateGlobal & 0x4000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[19];
                GameState.mScriptStateGlobal |= 0x4000L;
                break;
            }
            case 3: 
            case 4: {
                if ((GameState.mScriptStateGlobal & 0x2000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[20];
                GameState.mScriptStateGlobal |= 0x2000L;
                if (by == 3) {
                    this.mScriptQueue[this.mScriptQueueAddIndex - 1].setVariable(0, 0);
                    break;
                }
                this.mScriptQueue[this.mScriptQueueAddIndex - 1].setVariable(0, 1);
                break;
            }
            case 5: {
                if ((GameState.mScriptStateGlobal & 0x1000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[21];
                GameState.mScriptStateGlobal |= 0x1000L;
                break;
            }
            case 6: {
                if ((GameState.mScriptStateGlobal & 0x8000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[22];
                GameState.mScriptStateGlobal |= 0x8000L;
                break;
            }
            case 7: {
                if ((GameState.mScriptStateGlobal & 0x10000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[23];
                GameState.mScriptStateGlobal |= 0x10000L;
                break;
            }
            case 8: {
                if ((GameState.mScriptStateGlobal & 0x20000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[24];
                GameState.mScriptStateGlobal |= 0x20000L;
                break;
            }
            case 9: {
                if ((GameState.mScriptStateGlobal & 0x40000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[25];
                GameState.mScriptStateGlobal |= 0x40000L;
                break;
            }
            case 10: {
                if ((GameState.mScriptStateGlobal & 0x80000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[26];
                GameState.mScriptStateGlobal |= 0x80000L;
                break;
            }
            case 11: {
                if ((GameState.mScriptStateGlobal & 0x200000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[27];
                GameState.mScriptStateGlobal |= 0x200000L;
                break;
            }
            case 12: {
                if ((GameState.mScriptStateGlobal & 0x100000L) != 0L) break;
                this.mScriptQueue[this.mScriptQueueAddIndex++] = this.mScripts[28];
                GameState.mScriptStateGlobal |= 0x100000L;
            }
        }
        if (this.mScriptQueueAddIndex > 0) {
            for (n = 0; n < this.mScriptQueueAddIndex; ++n) {
                this.mScriptQueue[n].rewind();
            }
        }
        this.mScriptQueueProgress = 0;
    }

    public void activate() {
        this.mActivated = true;
    }

    public boolean isScriptPlaying() {
        return this.mScriptQueueAddIndex > 0;
    }

    public void stopAll() {
        if (this.mScriptQueue[this.mScriptQueueProgress] != null) {
            this.mScriptQueue[this.mScriptQueueProgress].stop();
            for (int i = 0; i < this.mScriptQueue.length; ++i) {
                this.mScriptQueue[i] = null;
            }
            this.mScriptQueueProgress = 0;
            this.mScriptQueueAddIndex = 0;
        }
    }
}

