/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceCtrl;

public class SurfaceSolidityCtrlDisappearing
extends SurfaceCtrl {
    private static final int STATE_SOLID = 0;
    private static final int STATE_FADING_OUT = 1;
    private static final int STATE_AWAY = 2;
    private static final int STATE_FADING_IN = 3;
    private int mState;
    private int mSolidTime;
    private int mFadeTime;
    private int mAwayTime;
    private int mTimer;

    public SurfaceSolidityCtrlDisappearing(PlatformData platformData, int n, int n2, int n3) {
        this.mData = platformData;
        this.mSolidTime = n;
        this.mFadeTime = n2;
        this.mAwayTime = n3;
        this.mState = 0;
        this.mTimer = this.mSolidTime;
    }

    public void update() {
        Surface surface = this.mData.getSurface();
        int n = this.mData.getAlphaValue();
        switch (this.mState) {
            case 0: {
                this.mTimer -= Timer.mDt;
                n = 65536;
                if (this.mTimer > 0) break;
                this.mState = 1;
                this.mTimer = this.mFadeTime;
                break;
            }
            case 1: {
                this.mTimer -= Timer.mDt;
                n = PMMath.DIV(this.mTimer, this.mFadeTime);
                if (this.mTimer > 0) break;
                this.mState = 2;
                this.mTimer = this.mAwayTime;
                n = 0;
                surface.setSolidity(false);
                break;
            }
            case 2: {
                this.mTimer -= Timer.mDt;
                n = 0;
                if (this.mTimer > 0) break;
                this.mState = 3;
                this.mTimer = this.mFadeTime;
                surface.setSolidity(true);
                break;
            }
            case 3: {
                this.mTimer -= Timer.mDt;
                n = 65536 - PMMath.DIV(this.mTimer, this.mFadeTime);
                if (this.mTimer > 0) break;
                this.mState = 0;
                this.mTimer = this.mSolidTime;
                n = 65536;
            }
        }
        this.mData.setAlphaValue(n);
    }
}

