/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.dangers;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Danger1s {
    private Vector2[] mPositions;
    private int[] mWidths;
    private int[] mHeights;
    private Movie[] mTileMovies;
    private int mTileSolid;

    public Danger1s(Vector2[] vector2Array, int[] nArray, int[] nArray2) {
        this.mPositions = vector2Array;
        this.mWidths = nArray;
        this.mHeights = nArray2;
        switch (Defines.mWorldLookup[GameState.mLevel]) {
            case 0: {
                this.mTileMovies = new Movie[7];
                this.mTileMovies[0] = Movie.load((short)-30040);
                this.mTileMovies[1] = Movie.load((short)17677);
                this.mTileMovies[2] = Movie.load((short)110);
                this.mTileMovies[3] = Movie.load((short)-13722);
                this.mTileMovies[4] = Movie.load((short)-28923);
                this.mTileMovies[5] = Movie.load((short)16544);
                this.mTileMovies[6] = Movie.load((short)1475);
                this.mTileSolid = 708;
                break;
            }
            case 1: {
                this.mTileMovies = new Movie[7];
                this.mTileMovies[0] = Movie.load((short)-17717);
                this.mTileMovies[1] = Movie.load((short)30062);
                this.mTileMovies[2] = Movie.load((short)12301);
                this.mTileMovies[3] = Movie.load((short)-1531);
                this.mTileMovies[4] = Movie.load((short)-16538);
                this.mTileMovies[5] = Movie.load((short)28867);
                this.mTileMovies[6] = Movie.load((short)13728);
                this.mTileSolid = 716;
                break;
            }
            case 2: {
                this.mTileMovies = new Movie[7];
                this.mTileMovies[0] = Movie.load((short)-21782);
                this.mTileMovies[1] = Movie.load((short)25935);
                this.mTileMovies[2] = Movie.load((short)8236);
                this.mTileMovies[3] = Movie.load((short)-5596);
                this.mTileMovies[4] = Movie.load((short)-20665);
                this.mTileMovies[5] = Movie.load((short)24802);
                this.mTileMovies[6] = Movie.load((short)9601);
                this.mTileSolid = 724;
                break;
            }
            case 3: {
                this.mTileMovies = new Movie[7];
                this.mTileMovies[0] = Movie.load((short)-9715);
                this.mTileMovies[1] = Movie.load((short)5544);
                this.mTileMovies[2] = Movie.load((short)20683);
                this.mTileMovies[3] = Movie.load((short)-25917);
                this.mTileMovies[4] = Movie.load((short)-8288);
                this.mTileMovies[5] = Movie.load((short)4101);
                this.mTileMovies[6] = Movie.load((short)21862);
                this.mTileSolid = 732;
                break;
            }
            case 4: {
                this.mTileMovies = new Movie[7];
                this.mTileMovies[0] = Movie.load((short)-13780);
                this.mTileMovies[1] = Movie.load((short)1417);
                this.mTileMovies[2] = Movie.load((short)16618);
                this.mTileMovies[3] = Movie.load((short)-29982);
                this.mTileMovies[4] = Movie.load((short)-12415);
                this.mTileMovies[5] = Movie.load((short)36);
                this.mTileMovies[6] = Movie.load((short)17735);
                this.mTileSolid = 740;
            }
        }
        for (int i = 0; i < this.mTileMovies.length; ++i) {
            this.mTileMovies[i].loadGfx();
            this.mTileMovies[i].gotoTick(0);
        }
    }

    public void update() {
        int n = PMMath.MUL(32768, Timer.mDt);
        for (int i = 0; i < this.mTileMovies.length; ++i) {
            this.mTileMovies[i].update(n);
        }
    }

    public void draw(Vector2 vector2) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 2;
            long l2 = (long)vector22.mY * 5L >> 2;
            long l3 = (long)vector2.mX * 5L >> 2;
            long l4 = (long)vector2.mY * 5L >> 2;
            int n = (int)((l >> 16) - (l3 >> 16));
            int n2 = (int)((l2 >> 16) - (l4 >> 16));
            if (n > 320 || n2 > 240) continue;
            int n3 = 20;
            int n4 = 0;
            if (n < 0) {
                n4 = -n / n3;
            }
            int n5 = 0;
            if (n2 < 0) {
                n5 = -n2 / n3;
            }
            int n6 = (320 - n) / n3 + 1;
            int n7 = (240 - n2) / n3 + 1;
            if (n6 > this.mWidths[i]) {
                n6 = this.mWidths[i];
            }
            if (n7 > this.mHeights[i]) {
                n7 = this.mHeights[i];
            }
            for (int j = n5; j < n7; ++j) {
                for (int k = n4; k < n6; ++k) {
                    int n8 = n + k * n3;
                    int n9 = n2 + j * n3;
                    if (j == 0) {
                        int n10 = k % this.mTileMovies.length;
                        this.mTileMovies[n10].draw(n8, n9);
                        continue;
                    }
                    PMImageManager.draw(this.mTileSolid, n8, n9);
                }
            }
        }
    }

    public boolean collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX;
            int n6 = vector2.mX + this.mWidths[i] * 0x100000;
            int n7 = vector2.mY + 0x100000;
            int n8 = vector2.mY + this.mHeights[i] * 0x100000;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            return true;
        }
        return false;
    }
}

