/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy2Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy2State;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy2View;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy2StateJumping
extends Enemy2State {
    private AABB mTileAABB;
    private int mStartHeight;

    public Enemy2StateJumping(Enemy2Data enemy2Data, Enemy2View enemy2View, Enemy2StateController enemy2StateController) {
        this.mData = enemy2Data;
        this.mView = enemy2View;
        this.mController = enemy2StateController;
        this.mTileAABB = new AABB();
    }

    public void enter() {
        this.mView.setAnimState(2);
        Vector2 vector2 = this.mData.getPositionRef();
        SoundBufferPositional.play(30, 200, vector2.mX, vector2.mY);
        this.mStartHeight = vector2.mY;
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        vector2.mY += Timer.mFeatureWorldGravity;
        vector22.add(vector2);
        if (vector22.mY >= this.mStartHeight) {
            this.mController.requestStateChange(1);
        } else if (vector2.mY < 0) {
            int n;
            int n2;
            World world = this.mData.getWorldRef();
            if (world.collisionTest(n2 = vector22.mX - (vector23.mX >> 1), n = vector22.mY - vector23.mY, this.mTileAABB)) {
                vector22.mY = this.mTileAABB.mMaxY + vector23.mY;
                vector2.mY = 0;
            }
            if (world.collisionTest(n2 = vector22.mX + (vector23.mX >> 1), n = vector22.mY - vector23.mY, this.mTileAABB)) {
                vector22.mY = this.mTileAABB.mMaxY + vector23.mY;
                vector2.mY = 0;
            }
        }
    }
}

