/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.enemies.Enemy4Data;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Enemy4View {
    protected Enemy4Data mData;
    public static final int STATE_ANIM_IDLE = 0;
    public static final int STATE_ANIM_ANTICIPATE = 1;
    public static final int STATE_ANIM_SPEW = 2;
    public static final int STATE_ANIM_DIE = 3;
    public static final int STATE_ANIM_RESPAWN = 4;
    private int mAnimState;
    private Movie mAnimDie;
    private Movie mAnimRespawn;
    private boolean mRespawning;

    public Enemy4View(Enemy4Data enemy4Data) {
        this.mData = enemy4Data;
        this.mAnimDie = Movie.load((short)-18826);
        this.mAnimDie.loadGfx();
        this.mAnimRespawn = Movie.load((short)-25938);
        this.mAnimRespawn.loadGfx();
    }

    public void update() {
        switch (this.mAnimState) {
            case 3: {
                this.mAnimDie.update(Timer.mDt);
                break;
            }
            case 4: {
                this.mAnimRespawn.update(Timer.mDt);
                if (!this.mAnimRespawn.isDone()) break;
                this.mRespawning = false;
            }
        }
    }

    public void draw(Vector2 vector2) {
        boolean bl;
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        long l = (long)vector22.mX * 5L >> 2;
        long l2 = (long)vector22.mY * 5L >> 2;
        long l3 = (long)vector2.mX * 5L >> 2;
        long l4 = (long)vector2.mY * 5L >> 2;
        int n = (int)((l >> 16) - (l3 >> 16));
        int n2 = (int)((l2 >> 16) - (l4 >> 16));
        int n3 = 20;
        int n4 = 40;
        boolean bl2 = this.mData.getDirection() == 0;
        boolean bl3 = bl = !bl2;
        if (Camera.isInside(n - (n3 >> 1), n2 - n4, n3, n4)) {
            switch (this.mAnimState) {
                case 0: {
                    PMImageManager.draw(38, n, n2, bl, 0);
                    break;
                }
                case 1: {
                    PMImageManager.draw(39, n, n2, bl, 0);
                    break;
                }
                case 2: {
                    PMImageManager.draw(40, n, n2, bl, 0);
                    break;
                }
                case 3: {
                    this.mAnimDie.draw(n, n2, bl2);
                    break;
                }
                case 4: {
                    this.mAnimRespawn.draw(n, n2, bl2);
                }
            }
        }
    }

    public void setAnimState(int n) {
        this.mAnimState = n;
        this.mAnimDie.gotoTick(0);
        this.mAnimRespawn.gotoTick(0);
        switch (n) {
            case 4: {
                this.mRespawning = true;
            }
        }
    }

    public boolean isRespawnDone() {
        return !this.mRespawning;
    }
}

