/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy6Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy6State;
import dk.progressivemedia.skeleton.game.enemies.Enemy6StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy6View;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy6StateDieing
extends Enemy6State {
    private int mYVelocity;
    private int mWorldHeight;

    public Enemy6StateDieing(Enemy6Data enemy6Data, Enemy6View enemy6View, Enemy6StateController enemy6StateController) {
        this.mData = enemy6Data;
        this.mView = enemy6View;
        this.mController = enemy6StateController;
        World world = this.mData.getWorldRef();
        this.mWorldHeight = world.getWorldMaxY();
    }

    public void enter() {
        this.mYVelocity = -250000;
        this.mView.setAnimState(1);
        this.mData.setState(1);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getDimensionRef();
        this.mYVelocity += Timer.mFeatureWorldGravity;
        if (this.mYVelocity > Timer.mFeatureWorldGravityMax) {
            this.mYVelocity = Timer.mFeatureWorldGravityMax;
        }
        vector2.mY += this.mYVelocity;
        if (vector2.mY - vector22.mY > this.mWorldHeight) {
            this.mData.setState(2);
        }
    }
}

