/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineData {
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    private int mDirection = 1;
    private World mWorld;
    private Vector2 mPosition;
    private Vector2 mPositionPrev;
    private Vector2 mDimension;
    private Vector2 mVelocity;
    private Surface mSurface;
    private int mSurfaceIndex;
    private int mSurfaceOffset;
    private int mHealth;
    private boolean mInvulnerability;
    private Vector2 mSpawnpoint;
    private boolean mOnGround;
    private boolean mJumpButtonPressed;
    private boolean mJumpButtonDown;
    public static final int STATE_TOTEM_PIXELINE = 0;
    public static final int STATE_TOTEM_1 = 1;
    public static final int STATE_TOTEM_2 = 2;
    public static final int STATE_TOTEM_3 = 3;
    public static final int STATE_TOTEM_COUNT = 4;
    private int mTotemState;
    private int mRunSpeedAcceleration;
    private int mRunSpeedMax;
    private int mBrakeSpeedThreshold;
    private int mBrakeDeceleration;
    private int mSlipperyRunSpeedAcceleration;
    private int mSlipperyBrakeDamping;
    private int mJumpVelocity;
    private int mJumpEnergy;
    private int mGravityModifier;

    public PixelineData(World world) {
        this.mWorld = world;
        this.mPosition = new Vector2();
        this.mPositionPrev = new Vector2();
        this.mDimension = new Vector2(PMMath.FP(10), PMMath.FP(31));
        this.mVelocity = new Vector2();
        this.mSurface = null;
        this.mSurfaceIndex = 0;
        this.mSurfaceOffset = 0;
        this.mHealth = 3;
        this.mInvulnerability = false;
        this.mSpawnpoint = null;
        this.mOnGround = false;
        this.mJumpButtonPressed = false;
        this.mJumpButtonDown = false;
        this.mTotemState = 0;
        this.mRunSpeedAcceleration = 23000;
        this.mRunSpeedMax = 220840;
        this.mBrakeSpeedThreshold = 163000;
        this.mBrakeDeceleration = 40000;
        this.mSlipperyRunSpeedAcceleration = 13000;
        this.mSlipperyBrakeDamping = 64000;
        this.mJumpVelocity = -360000;
        this.mJumpEnergy = 266;
        this.mGravityModifier = 65536;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int n) {
        this.mDirection = n;
    }

    public World getWorldRef() {
        return this.mWorld;
    }

    public Vector2 getPositionRef() {
        return this.mPosition;
    }

    public Vector2 getPositionPrevRef() {
        return this.mPositionPrev;
    }

    public void setPosition(Vector2 vector2) {
        this.mPosition.set(vector2);
    }

    public void setPosition(int n, int n2) {
        this.mPosition.set(n, n2);
    }

    public void setPositionPrev(Vector2 vector2) {
        this.mPositionPrev.set(vector2);
    }

    public void setPositionPrev(int n, int n2) {
        this.mPositionPrev.set(n, n2);
    }

    public Vector2 getDimensionRef() {
        return this.mDimension;
    }

    public void setDimension(Vector2 vector2) {
        this.mDimension.set(vector2);
    }

    public Vector2 getVelocityRef() {
        this.mVelocity.mX = MathUtil.clamp(this.mVelocity.mX, -this.mRunSpeedMax, this.mRunSpeedMax);
        return this.mVelocity;
    }

    public void setVelocity(Vector2 vector2) {
        this.mVelocity.set(vector2);
    }

    public void setSurface(Surface surface, int n, int n2) {
        this.mSurface = surface;
        this.mSurfaceIndex = n;
        this.mSurfaceOffset = n2;
        this.mSurface.setPlayerTouching(true);
    }

    public void setSurfacePosition(int n, int n2) {
        this.mSurfaceIndex = n;
        this.mSurfaceOffset = n2;
    }

    public Surface getSurfaceRef() {
        return this.mSurface;
    }

    public int getSurfaceIndex() {
        return this.mSurfaceIndex;
    }

    public int getSurfaceOffset() {
        return this.mSurfaceOffset;
    }

    public boolean isAlive() {
        return this.mHealth > 0;
    }

    public void setHealth(int n) {
        this.mHealth = n;
    }

    public int getHealth() {
        return this.mHealth;
    }

    public Vector2 getSpawnpointRef() {
        return this.mSpawnpoint;
    }

    public void setSpawnpoint(Vector2 vector2) {
        this.mSpawnpoint = vector2;
    }

    public boolean isOnGround() {
        return this.mOnGround;
    }

    public void setOnGround(boolean bl) {
        this.mOnGround = bl;
    }

    public boolean getJumpButtonPressed() {
        return this.mJumpButtonPressed;
    }

    public void setJumpButtonPressed(boolean bl) {
        this.mJumpButtonPressed = bl;
    }

    public boolean getJumpButtonDown() {
        return this.mJumpButtonDown;
    }

    public void setJumpButtonDown(boolean bl) {
        this.mJumpButtonDown = bl;
    }

    public int getTotemState() {
        return this.mTotemState;
    }

    public void totemTransition(int n) {
        this.mTotemState = n;
        switch (this.mTotemState) {
            case 0: {
                this.mRunSpeedAcceleration = 23000;
                this.mRunSpeedMax = 220840;
                this.mBrakeSpeedThreshold = 163000;
                this.mBrakeDeceleration = 40000;
                this.mSlipperyRunSpeedAcceleration = 13000;
                this.mSlipperyBrakeDamping = 64000;
                this.mJumpVelocity = -360000;
                this.mJumpEnergy = 266;
                this.mGravityModifier = 65536;
                this.mDimension.set(PMMath.FP(10), PMMath.FP(31));
                break;
            }
            case 1: {
                this.mRunSpeedAcceleration = 23000;
                this.mRunSpeedMax = 380144;
                this.mBrakeSpeedThreshold = 200000;
                this.mBrakeDeceleration = 35000;
                this.mSlipperyRunSpeedAcceleration = 13000;
                this.mSlipperyBrakeDamping = 64000;
                this.mJumpVelocity = -232144;
                this.mJumpEnergy = 133;
                this.mGravityModifier = 65536;
                this.mDimension.set(PMMath.FP(12), PMMath.FP(15));
                this.mWorld.handleEvent((byte)18);
                break;
            }
            case 2: {
                this.mRunSpeedAcceleration = 23000;
                this.mRunSpeedMax = 133840;
                this.mBrakeSpeedThreshold = 100000;
                this.mBrakeDeceleration = 15000;
                this.mSlipperyRunSpeedAcceleration = 13000;
                this.mSlipperyBrakeDamping = 64000;
                this.mJumpVelocity = -524288;
                this.mJumpEnergy = 266;
                this.mGravityModifier = 65536;
                this.mDimension.set(PMMath.FP(6), PMMath.FP(31));
                this.mWorld.handleEvent((byte)19);
                break;
            }
            case 3: {
                this.mRunSpeedAcceleration = 5000;
                this.mRunSpeedMax = 130304;
                this.mBrakeSpeedThreshold = 95000;
                this.mBrakeDeceleration = 10000;
                this.mSlipperyRunSpeedAcceleration = 3000;
                this.mSlipperyBrakeDamping = 64500;
                this.mJumpVelocity = -200000;
                this.mJumpEnergy = 100;
                this.mGravityModifier = 65536;
                this.mDimension.set(PMMath.FP(16), PMMath.FP(31));
                this.mWorld.handleEvent((byte)20);
            }
        }
        this.mVelocity.mX = MathUtil.clamp(this.mVelocity.mX, -this.mRunSpeedMax, this.mRunSpeedMax);
    }

    public int getRunSpeedAcceleration() {
        return (this.mRunSpeedAcceleration << 6) / 33 * Timer.mDt >> 6;
    }

    public int getRunSpeedMax() {
        return (this.mRunSpeedMax << 6) / 33 * Timer.mDt >> 6;
    }

    public int getBrakeSpeedThreshold() {
        return (this.mBrakeSpeedThreshold << 6) / 33 * Timer.mDt >> 6;
    }

    public int getBrakeDeceleration() {
        return (this.mBrakeDeceleration << 6) / 33 * Timer.mDt >> 6;
    }

    public int getSlipperyRunSpeedAcceleration() {
        return (this.mSlipperyRunSpeedAcceleration << 6) / 33 * Timer.mDt >> 6;
    }

    public int getSlipperyBrakeDamping() {
        return this.mSlipperyBrakeDamping;
    }

    public int getJumpVelocity() {
        if (Timer.mDt > 50) {
            return (this.mJumpVelocity << 6) / 33 * 50 >> 6;
        }
        return (this.mJumpVelocity << 6) / 33 * Timer.mDt >> 6;
    }

    public int getJumpEnergy() {
        return this.mJumpEnergy;
    }

    public void setJumpEnergy(int n) {
        this.mJumpEnergy = n;
    }

    public void resetJumpEnergy() {
        switch (this.mTotemState) {
            case 0: {
                this.mJumpEnergy = 266;
                break;
            }
            case 1: {
                this.mJumpEnergy = 133;
                break;
            }
            case 2: {
                this.mJumpEnergy = 266;
                break;
            }
            case 3: {
                this.mJumpEnergy = 100;
            }
        }
    }

    public int getGravityModifier() {
        return this.mGravityModifier;
    }

    public void setInvulnerability(boolean bl) {
        this.mInvulnerability = bl;
    }

    public boolean isInvulnerable() {
        return this.mInvulnerability;
    }
}

