/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.movieplayer;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class MovieItem {
    private static final int OUTER_BORDER = 400;
    public static final int MODEL = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int SCALE = 3;
    public static final int ROT = 4;
    public static final int MIRROR = 5;
    public static final int DRAW = 6;
    public static final int ORDER = 7;
    public static final int ALPHA = 8;
    public static final int SCALE_H = 9;
    public static final int SCALE_V = 10;
    private short model;
    private short x;
    private short y;
    private int scale;
    private short rot;
    private boolean mirror;
    private boolean visible;
    private short alpha;
    private int scaleH;
    private int scaleV;

    public void draw(int n, int n2, int n3) {
        if (this.visible) {
            int n4 = n + (PMMath.MUL(this.x, n3) >> 15);
            int n5 = n2 + (PMMath.MUL(this.y, n3) >> 15);
            int n6 = PMMath.MUL(this.scaleH << 4, n3 / 400);
            int n7 = PMMath.MUL(this.scaleV << 4, n3 / 400);
            PMImageManager.draw(this.model, n4, n5, this.mirror, this.rot, this.alpha, n6, n7);
        }
    }

    public void draw(int n, int n2, int n3, boolean bl) {
        if (this.visible) {
            int n4 = n + (PMMath.MUL(this.x, n3) >> 15);
            int n5 = n2 + (PMMath.MUL(this.y, n3) >> 15);
            int n6 = PMMath.MUL(this.scaleH << 4, n3 / 400);
            int n7 = PMMath.MUL(this.scaleV << 4, n3 / 400);
            PMImageManager.draw(this.model, n4, n5, bl ? !this.mirror : this.mirror, this.rot, this.alpha, n6, n7);
        }
    }

    public void draw(int n, int n2, int n3, int n4) {
        if (this.visible) {
            int n5 = PMMath.MUL(this.x, n3) >> 15;
            int n6 = PMMath.MUL(this.y, n3) >> 15;
            int n7 = PMMath.MUL(this.scaleH << 4, n3 / 400);
            int n8 = PMMath.MUL(this.scaleV << 4, n3 / 400);
            int n9 = (this.rot + n4) % 360;
            PMImageManager.draw(this.model, n += n5 * PMTrigonometry.cos(n4 %= 360) - n6 * PMTrigonometry.sin(n4) >> 16, n2 += n5 * PMTrigonometry.sin(n4) + n6 * PMTrigonometry.cos(n4) >> 16, this.mirror, n9, this.alpha, n7, n8);
        }
    }

    public void drawAlpha(int n, int n2, int n3, int n4) {
        if (this.visible) {
            int n5 = n + (PMMath.MUL(this.x, n3) >> 15);
            int n6 = n2 + (PMMath.MUL(this.y, n3) >> 15);
            int n7 = PMMath.MUL(this.scaleH << 4, n3 / 400);
            int n8 = PMMath.MUL(this.scaleV << 4, n3 / 400);
            PMImageManager.draw(this.model, n5, n6, this.mirror, this.rot, n4, n7, n8);
        }
    }

    public void setValue(int n, short s) {
        switch (n) {
            case 0: {
                this.model = s;
                break;
            }
            case 1: {
                this.x = s;
                break;
            }
            case 2: {
                this.y = s;
                break;
            }
            case 3: {
                this.scale = s & 0xFFFF;
                this.scaleH = this.scale = this.scale * 4 / 5;
                this.scaleV = this.scale;
                break;
            }
            case 4: {
                if (s >= 360 || s < 0) {
                    s = (short)((s + 36000) % 360);
                }
                this.rot = s;
                break;
            }
            case 5: {
                this.mirror = s == 1;
                break;
            }
            case 6: {
                this.visible = s == 1;
                break;
            }
            case 8: {
                this.alpha = s;
                break;
            }
            case 9: {
                this.scaleH = s & 0xFFFF;
                this.scaleH = this.scale * 4 / 5;
                break;
            }
            case 10: {
                this.scaleV = s & 0xFFFF;
                this.scaleV = this.scale * 4 / 5;
            }
        }
    }

    public MovieItem() {
        this.reset();
    }

    public void reset() {
        this.model = 0;
        this.x = 0;
        this.y = 0;
        this.scaleH = this.scale = 4096;
        this.scaleV = this.scale;
        this.rot = 0;
        this.mirror = false;
        this.visible = true;
        this.alpha = (short)255;
    }
}

