/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class Clouds {
    private static final int PARALLAX_RATIO = 16384;
    private int[] mPositionX;
    private int[] mPositionY;
    private int[] mVelocity;
    private int[] mImg;
    private int[] mWidth;
    private int mDirection;
    private int mMaxWidth;

    public Clouds(int n, int n2) {
        int n3;
        int n4 = PMMath.MUL(n2 - 0x1000000, 16384);
        this.mMaxWidth = n3 = PMMath.MUL(n, 16384);
        int n5 = 0x300000;
        int n6 = n4 / 0xF00000 + 1;
        int n7 = 3 * n6;
        this.mPositionX = new int[n7];
        this.mPositionY = new int[n7];
        this.mVelocity = new int[n7];
        this.mImg = new int[n7];
        this.mWidth = new int[n7];
        this.mDirection = MathUtil.randomBounded(1) == 0 ? -1 : 1;
        for (int i = 0; i < n6; ++i) {
            int n8 = i * 0xF00000;
            int n9 = (i + 1) * 0xF00000;
            if (n9 > n4) {
                n9 = n4;
            }
            block5: for (int j = 0; j < 3; ++j) {
                int n10 = i * 3 + j;
                this.mPositionX[n10] = MathUtil.randomBounded(n3);
                this.mPositionY[n10] = MathUtil.randomBounded(n8, n9);
                this.mVelocity[n10] = MathUtil.randomBounded(10360, 20000) * this.mDirection;
                switch (Defines.mWorldLookup[GameState.mLevel]) {
                    case 2: {
                        if (MathUtil.randomBounded(1) == 0) {
                            this.mImg[n10] = 30;
                            this.mWidth[n10] = 0x990000;
                            continue block5;
                        }
                        this.mImg[n10] = 31;
                        this.mWidth[n10] = 0x6E0000;
                        continue block5;
                    }
                    case 3: {
                        if (MathUtil.randomBounded(1) == 0) {
                            this.mImg[n10] = 32;
                            this.mWidth[n10] = 0x8C0000;
                            continue block5;
                        }
                        this.mImg[n10] = 33;
                        this.mWidth[n10] = 0x390000;
                    }
                }
            }
        }
    }

    public void update() {
        for (int i = 0; i < this.mPositionX.length; ++i) {
            int n = i;
            this.mPositionX[n] = this.mPositionX[n] + this.mVelocity[i];
            if (this.mPositionX[i] > this.mMaxWidth) {
                this.mPositionX[i] = -this.mWidth[i];
                this.mVelocity[i] = MathUtil.randomBounded(10360, 20000) * this.mDirection;
                continue;
            }
            if (this.mPositionX[i] >= -this.mWidth[i]) continue;
            this.mPositionX[i] = this.mMaxWidth;
            this.mVelocity[i] = MathUtil.randomBounded(10360, 20000) * this.mDirection;
        }
    }

    public void draw(Vector2 vector2) {
        int n = Defines.mWorldLookup[GameState.mLevel];
        if (n == 2 || n == 3) {
            int n2 = PMMath.MUL(vector2.mX, 16384);
            int n3 = PMMath.MUL(vector2.mY, 16384);
            for (int i = 0; i < this.mPositionX.length; ++i) {
                long l = (long)this.mPositionX[i] * 5L >> 2;
                long l2 = (long)this.mPositionY[i] * 5L >> 2;
                long l3 = (long)n2 * 5L >> 2;
                long l4 = (long)n3 * 5L >> 2;
                int n4 = (int)((l >> 16) - (l3 >> 16));
                int n5 = (int)((l2 >> 16) - (l4 >> 16));
                PMImageManager.draw(this.mImg[i], n4, n5);
            }
        }
    }
}

