/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.Promotion;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.Clouds;
import dk.progressivemedia.skeleton.game.ExitArea;
import dk.progressivemedia.skeleton.game.GameTileMapping;
import dk.progressivemedia.skeleton.game.HUD;
import dk.progressivemedia.skeleton.game.LevelFileLoader;
import dk.progressivemedia.skeleton.game.Platform;
import dk.progressivemedia.skeleton.game.PlatformAnimationCache;
import dk.progressivemedia.skeleton.game.ScreenEvents;
import dk.progressivemedia.skeleton.game.ScriptHelper;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.TileManager;
import dk.progressivemedia.skeleton.game.VisualEffect;
import dk.progressivemedia.skeleton.game.dangers.Danger1s;
import dk.progressivemedia.skeleton.game.dangers.Danger2s;
import dk.progressivemedia.skeleton.game.dangers.Danger3s;
import dk.progressivemedia.skeleton.game.dangers.Danger4s;
import dk.progressivemedia.skeleton.game.enemies.Enemy1;
import dk.progressivemedia.skeleton.game.enemies.Enemy1Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy2;
import dk.progressivemedia.skeleton.game.enemies.Enemy2Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy3;
import dk.progressivemedia.skeleton.game.enemies.Enemy3Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy4;
import dk.progressivemedia.skeleton.game.enemies.Enemy4Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy5;
import dk.progressivemedia.skeleton.game.enemies.Enemy5Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy6;
import dk.progressivemedia.skeleton.game.enemies.Enemy6Data;
import dk.progressivemedia.skeleton.game.enemies.FruitBomb;
import dk.progressivemedia.skeleton.game.items.Checkpoints;
import dk.progressivemedia.skeleton.game.items.Chests;
import dk.progressivemedia.skeleton.game.items.GoldCoins;
import dk.progressivemedia.skeleton.game.items.Health;
import dk.progressivemedia.skeleton.game.items.Keys;
import dk.progressivemedia.skeleton.game.items.SilverCoins;
import dk.progressivemedia.skeleton.game.items.TutorialStones;
import dk.progressivemedia.skeleton.game.particles.ParticleSystem;
import dk.progressivemedia.skeleton.game.pixeline.Pixeline;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.SweepTest;
import dk.progressivemedia.skeleton.math.SweepTestResult;
import dk.progressivemedia.skeleton.math.Vector2;

public class World {
    private static final int STATE_VOID = -1;
    private static final int STATE_STARTING = 0;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_WON = 3;
    private int mState;
    private LevelFileLoader mLevelLoader;
    private TileManager mTileManager;
    private Surface[] mSurfaces;
    private Platform[] mPlatforms;
    private boolean[] mPlatformGroupActive;
    private Vector2 mSpawnpoint;
    private Checkpoints mCheckpoints;
    private ExitArea mExitArea;
    private Pixeline mPixeline;
    private SweepTestResult mResult;
    private Enemy1[] mEnemy1List;
    private Enemy2[] mEnemy2List;
    private Enemy3[] mEnemy3List;
    private Enemy4[] mEnemy4List;
    private Enemy5[] mEnemy5List;
    private Enemy6[] mEnemy6List;
    private Danger1s mDanger1s;
    private Danger2s mDanger2s;
    private Danger3s mDanger3s;
    private Danger4s mDanger4s;
    private GoldCoins mGoldCoins;
    private SilverCoins mSilverCoins;
    private Chests mChests;
    private Keys mKeys;
    private Health mHealth;
    private TutorialStones mTutorialStones;
    private Clouds mClouds;
    private boolean mPixelineTakeDamageMonster;
    private boolean mPixelineTakeDamageDanger;
    private boolean mPixelineInstantDeath;
    private boolean mPixelineJump;
    private int mPixelineYProjection;
    private Camera mCamera;
    private AABB mUpdateZone;
    private AABB mCollisionCheckZone;
    private HUD mHUD;
    private ScreenEvents mScreenEvents;
    private ParticleSystem mParticleSystem;
    private ScriptHelper mScriptHelper;
    private int mScriptID;

    public World(String string) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Vector2[] vector2Array;
        Object object4;
        PMFile.loadScreen = true;
        VisualEffect.init();
        this.mResult = new SweepTestResult();
        this.mScriptHelper = new ScriptHelper();
        this.mParticleSystem = new ParticleSystem(30);
        this.mPixelineTakeDamageMonster = false;
        this.mPixelineTakeDamageDanger = false;
        this.mPixelineInstantDeath = false;
        this.mPixelineJump = false;
        this.mPixelineYProjection = 0;
        this.mLevelLoader = new LevelFileLoader(string);
        this.mTileManager = new TileManager(this.mLevelLoader.getTilemapWidth(), this.mLevelLoader.getTilemapHeight(), this.mLevelLoader.getCollisionTilemap(), this.mLevelLoader.getPrimaryTilemap(), this.mLevelLoader.getOverlayTilemap());
        this.mSurfaces = this.mLevelLoader.getSurfaces();
        this.mPlatforms = this.mLevelLoader.getPlatforms();
        this.mPlatformGroupActive = new boolean[this.mPlatforms.length];
        for (int i = 0; i < this.mPlatforms.length; ++i) {
            this.mPlatforms[i].generateView();
        }
        this.mSpawnpoint = this.mLevelLoader.getSpawnpoint();
        this.mCheckpoints = new Checkpoints(this.mLevelLoader.getCheckpoints());
        this.mExitArea = new ExitArea(this.mLevelLoader.getExitArea());
        this.mGoldCoins = new GoldCoins(this.mLevelLoader.getGoldCoinPositions(), this);
        this.mSilverCoins = new SilverCoins(this.mLevelLoader.getSilverCoinPositions(), this);
        this.mChests = new Chests(this.mLevelLoader.getChestPositions());
        this.mKeys = new Keys(this.mLevelLoader.getKeyPositions(), this);
        this.mHealth = new Health(this.mLevelLoader.getHealthPositions(), this);
        this.mTutorialStones = new TutorialStones(this.mLevelLoader.getTutorialPositions(), this.mLevelLoader.getTutorialTypes());
        this.mClouds = new Clouds(this.mTileManager.getMaxX(), this.mTileManager.getMaxY());
        Vector2[] vector2Array2 = this.mLevelLoader.getEnemy1Positions();
        this.mEnemy1List = new Enemy1[vector2Array2.length];
        for (int i = 0; i < this.mEnemy1List.length; ++i) {
            Enemy1 enemy1;
            this.mEnemy1List[i] = enemy1 = new Enemy1(this, vector2Array2[i]);
        }
        Vector2[] vector2Array3 = this.mLevelLoader.getEnemy2Positions();
        this.mEnemy2List = new Enemy2[vector2Array3.length];
        for (int i = 0; i < this.mEnemy2List.length; ++i) {
            Enemy2 enemy2;
            this.mEnemy2List[i] = enemy2 = new Enemy2(this, vector2Array3[i]);
        }
        Vector2[] vector2Array4 = this.mLevelLoader.getEnemy3Positions();
        this.mEnemy3List = new Enemy3[vector2Array4.length];
        for (int i = 0; i < this.mEnemy3List.length; ++i) {
            this.mEnemy3List[i] = object4 = new Enemy3(this, vector2Array4[i]);
        }
        Vector2[] vector2Array5 = this.mLevelLoader.getEnemy4Positions();
        object4 = this.mLevelLoader.getEnemy4FiringRanges();
        boolean[] blArray = this.mLevelLoader.getEnemy4Directions();
        this.mEnemy4List = new Enemy4[vector2Array5.length];
        for (int i = 0; i < this.mEnemy4List.length; ++i) {
            this.mEnemy4List[i] = vector2Array = new Enemy4(this, vector2Array5[i]);
            object3 = vector2Array.getDataRef();
            object2 = ((Enemy4Data)object3).getBombRef();
            ((FruitBomb)object2).setFireRange((int)object4[i]);
            if (!blArray[i]) continue;
            ((Enemy4Data)object3).setDirection(1);
        }
        Vector2[] vector2Array6 = this.mLevelLoader.getEnemy5Positions();
        vector2Array = this.mLevelLoader.getEnemy5MovementDirections();
        object3 = this.mLevelLoader.getEnemy5MovementLengths();
        object2 = this.mLevelLoader.getEnemy5MovementSpeeds();
        this.mEnemy5List = new Enemy5[vector2Array6.length];
        for (int i = 0; i < this.mEnemy5List.length; ++i) {
            Enemy5 enemy5 = new Enemy5(this, vector2Array6[i]);
            enemy5.setMovementDirection(vector2Array[i]);
            enemy5.setMovementLength((int)object3[i]);
            enemy5.setMovementSpeed((int)object2[i]);
            this.mEnemy5List[i] = enemy5;
        }
        Vector2[] vector2Array7 = this.mLevelLoader.getEnemy6Positions();
        this.mEnemy6List = new Enemy6[vector2Array7.length];
        for (int i = 0; i < this.mEnemy6List.length; ++i) {
            object = new Enemy6(this, vector2Array7[i]);
            this.mEnemy6List[i] = object;
        }
        this.mDanger1s = new Danger1s(this.mLevelLoader.getDanger1Positions(), this.mLevelLoader.getDanger1Widths(), this.mLevelLoader.getDanger1Heights());
        this.mDanger2s = new Danger2s(this.mLevelLoader.getDanger2Positions(), this.mLevelLoader.getDanger2InitialDelays(), this.mLevelLoader.getDanger2Delays(), this.mLevelLoader.getDanger2JumpForces());
        this.mDanger3s = new Danger3s(this.mLevelLoader.getDanger3Positions(), this.mLevelLoader.getDanger3Heights());
        this.mDanger4s = new Danger4s(this.mLevelLoader.getDanger4Positions(), this.mLevelLoader.getDanger4TileWidths(), this.mLevelLoader.getDanger4Orientations());
        PMCanvas.PMInput_isHeld(64);
        this.mPixeline = GameState.mActiveCheckpoint > -1 ? new Pixeline(this, this.mCheckpoints.getCheckpointPosition(GameState.mActiveCheckpoint)) : new Pixeline(this, this.mSpawnpoint);
        this.mCamera = new Camera(this.mPixeline.getDataRef(), this.mTileManager.getMinX(), this.mTileManager.getMaxX(), this.mTileManager.getMaxY());
        Vector2 vector2 = this.mCamera.getTranslationFPRef();
        this.mUpdateZone = new AABB();
        this.mUpdateZone.mMinX = (vector2.mX >> 16) - 0x640000;
        this.mUpdateZone.mMaxX = (vector2.mX >> 16) + 6553856;
        this.mUpdateZone.mMinY = (vector2.mY >> 16) - 4096000;
        this.mUpdateZone.mMaxY = (vector2.mY >> 16) + 4096192;
        this.updateCollectionState();
        this.mHUD = new HUD(this.mPixeline);
        this.mScreenEvents = new ScreenEvents();
        object = this.mPixeline.getDataRef();
        Vector2 vector22 = ((PixelineData)object).getPositionRef();
        Vector2 vector23 = ((PixelineData)object).getDimensionRef();
        this.mCollisionCheckZone = new AABB();
        this.mCollisionCheckZone.mMinX = vector22.mX - (vector23.mX >> 1) - 0x1E0000;
        this.mCollisionCheckZone.mMaxX = vector22.mX + (vector23.mX >> 1) + 0x1E0000;
        this.mCollisionCheckZone.mMinY = vector22.mY - vector23.mY - 0x1E0000;
        this.mCollisionCheckZone.mMaxY = vector22.mY + 0x1E0000;
        this.mState = -1;
        this.mCamera.update();
        PlatformAnimationCache.postInit();
        this.mScriptID = 0;
        short[] sArray = GameTileMapping.TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (n = 0; n < sArray.length; ++n) {
            PMImageManager.load(sArray[n]);
        }
        sArray = GameTileMapping.BG1_TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (n = 0; n < sArray.length; ++n) {
            PMImageManager.load(sArray[n]);
        }
        sArray = GameTileMapping.BG2_TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (n = 0; n < sArray.length; ++n) {
            PMImageManager.load(sArray[n]);
        }
        PMAudio.load(15, "sfxPlayerJump", 6, 2434);
        PMAudio.load(9, "sfxLandOnMonster", 6, 1984);
        PMAudio.load(0, "sfxPlayerLoseHealthMonster", 6, 2518);
        PMAudio.load(14, "sfxPlayerGainLife", 6, 6920);
        PMAudio.load(11, "sfxPlayerGainSilverCoin", 6, 3290);
        PMAudio.load(12, "sfxPlayerGainGoldCoin", 6, 9832);
        PMAudio.load(24, "sfxPlayerGainKey", 6, 6106);
        PMAudio.load(25, "sfxPlayerOpenChest", 6, 10566);
        PMAudio.load(22, "sfxPlayerGainHealth", 6, 3494);
        PMAudio.load(23, "sfxPlayerCheckpoint", 6, 7150);
        PMAudio.load(29, "sfxPlayerTotemTransition", 6, 5728);
        PMAudio.load(30, "sfxEnemyJump", 6, 2542);
        PMAudio.load(27, "sfxEnemyShoot", 6, 3150);
        PMAudio.load(28, "sfxEnemySpikes", 6, 9942);
        PMFile.loadScreen = false;
    }

    public void eventStarted() {
        this.mScriptHelper.activate();
        this.mScriptHelper.handleEvent((byte)0);
        this.mScriptHelper.update();
        this.mState = 0;
    }

    public boolean canPause() {
        return this.mState == 1 && this.mPixeline.getDataRef().isAlive();
    }

    public void eventPaused() {
        this.mState = 2;
        this.mScriptHelper.stopAll();
    }

    public void eventUnpaused() {
        this.mState = 1;
        this.mHUD.activateTouch();
    }

    public void update() {
        switch (this.mState) {
            case 0: {
                if (!Dialog.isActive()) {
                    this.mHUD.update();
                    if (this.mHUD.isHUDReady()) {
                        this.mState = 1;
                    }
                }
                this.mScriptHelper.update();
                break;
            }
            case 1: 
            case 3: {
                if (!Dialog.isActive() && !this.mHUD.totemBarActive()) {
                    Vector2 vector2;
                    Object object;
                    int n;
                    int n2;
                    PlatformAnimationCache.update();
                    if (this.mState == 1) {
                        this.mCamera.update();
                    }
                    Vector2 vector22 = this.mCamera.getTranslationFPRef();
                    this.mUpdateZone.mMinX = vector22.mX - 0x640000;
                    this.mUpdateZone.mMaxX = vector22.mX + 0x1400000 + 0x640000;
                    this.mUpdateZone.mMinY = vector22.mY - 4096000;
                    this.mUpdateZone.mMaxY = vector22.mY + 0xF00000 + 4096000;
                    SoundBufferPositional.update(vector22.mX, vector22.mY);
                    int n3 = this.mPlatforms.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.mPlatformGroupActive[n2] = false;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = this.mPlatforms[n2].getGroupIndex();
                        if (!this.mPlatforms[n2].collideUpdateZone(this.mUpdateZone)) continue;
                        if (n == 0) {
                            this.mPlatforms[n2].update();
                            continue;
                        }
                        this.mPlatformGroupActive[n] = true;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!this.mPlatformGroupActive[n2]) continue;
                        for (n = 0; n < n3; ++n) {
                            if (n2 != this.mPlatforms[n].getGroupIndex()) continue;
                            this.mPlatforms[n].update();
                        }
                    }
                    this.mPixeline.update();
                    this.mDanger1s.update();
                    this.mDanger2s.update(this.mUpdateZone);
                    this.mDanger3s.update();
                    this.mCheckpoints.update();
                    this.mGoldCoins.update();
                    this.mSilverCoins.update();
                    this.mKeys.update();
                    this.mChests.update();
                    PixelineData pixelineData = this.mPixeline.getDataRef();
                    this.mHealth.update(pixelineData.getHealth() == 3);
                    this.mClouds.update();
                    int n4 = this.mEnemy1List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy1List[n].getDataRef();
                        if (!((Enemy1Data)object).isEnabled()) continue;
                        vector2 = ((Enemy1Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy1List[n].update();
                    }
                    n4 = this.mEnemy2List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy2List[n].getDataRef();
                        if (!((Enemy2Data)object).isEnabled()) continue;
                        vector2 = ((Enemy2Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy2List[n].update();
                    }
                    n4 = this.mEnemy3List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy3List[n].getDataRef();
                        if (!((Enemy3Data)object).isEnabled()) continue;
                        vector2 = ((Enemy3Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy3List[n].update();
                    }
                    n4 = this.mEnemy4List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy4List[n].getDataRef();
                        if (!((Enemy4Data)object).isEnabled()) continue;
                        vector2 = ((Enemy4Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy4List[n].update();
                    }
                    n4 = this.mEnemy5List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy5List[n].getDataRef();
                        if (!((Enemy5Data)object).isEnabled()) continue;
                        vector2 = ((Enemy5Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy5List[n].update();
                    }
                    n4 = this.mEnemy6List.length;
                    for (n = 0; n < n4; ++n) {
                        object = this.mEnemy6List[n].getDataRef();
                        if (!((Enemy6Data)object).isEnabled()) continue;
                        vector2 = ((Enemy6Data)object).getPositionRef();
                        if (vector2.mX < this.mUpdateZone.mMinX || vector2.mX > this.mUpdateZone.mMaxX || vector2.mY < this.mUpdateZone.mMinY || vector2.mY > this.mUpdateZone.mMaxY) continue;
                        this.mEnemy6List[n].update();
                    }
                    if (this.mState == 1) {
                        this.resolvePixelineCollisions();
                    }
                    this.mParticleSystem.update();
                }
                VisualEffect.update();
                this.mHUD.update();
                this.mScreenEvents.update();
                this.mScriptHelper.update();
            }
        }
    }

    public void draw(int n) {
        Object object;
        int n2;
        Vector2 vector2 = this.mCamera.getTranslationFPRef();
        this.mTileManager.drawBackground(vector2);
        this.mClouds.draw(vector2);
        this.mTileManager.draw(vector2);
        this.mCheckpoints.draw(vector2);
        for (n2 = 0; n2 < this.mPlatforms.length; ++n2) {
            this.mPlatforms[n2].draw(vector2);
        }
        this.mChests.draw(vector2);
        this.mExitArea.draw(vector2);
        this.mTutorialStones.draw(vector2);
        for (n2 = 0; n2 < this.mEnemy1List.length; ++n2) {
            object = this.mEnemy1List[n2].getDataRef();
            if (!((Enemy1Data)object).isEnabled()) continue;
            this.mEnemy1List[n2].draw(vector2);
        }
        for (n2 = 0; n2 < this.mEnemy2List.length; ++n2) {
            object = this.mEnemy2List[n2].getDataRef();
            if (!((Enemy2Data)object).isEnabled()) continue;
            this.mEnemy2List[n2].draw(vector2);
        }
        for (n2 = 0; n2 < this.mEnemy3List.length; ++n2) {
            object = this.mEnemy3List[n2].getDataRef();
            if (!((Enemy3Data)object).isEnabled()) continue;
            this.mEnemy3List[n2].draw(vector2);
        }
        for (n2 = 0; n2 < this.mEnemy4List.length; ++n2) {
            object = this.mEnemy4List[n2].getDataRef();
            if (!((Enemy4Data)object).isEnabled()) continue;
            this.mEnemy4List[n2].draw(vector2);
        }
        for (n2 = 0; n2 < this.mEnemy5List.length; ++n2) {
            object = this.mEnemy5List[n2].getDataRef();
            if (!((Enemy5Data)object).isEnabled()) continue;
            this.mEnemy5List[n2].draw(vector2);
        }
        for (n2 = 0; n2 < this.mEnemy6List.length; ++n2) {
            object = this.mEnemy6List[n2].getDataRef();
            if (!((Enemy6Data)object).isEnabled()) continue;
            this.mEnemy6List[n2].draw(vector2);
        }
        this.mPixeline.drawAlive(vector2);
        this.mDanger2s.draw(vector2);
        this.mDanger3s.draw(vector2);
        this.mDanger4s.draw(vector2);
        this.mGoldCoins.draw(vector2);
        this.mSilverCoins.draw(vector2);
        this.mKeys.draw(vector2);
        this.mHealth.draw(vector2);
        this.mDanger1s.draw(vector2);
        this.mPixeline.drawDead(vector2);
        this.mParticleSystem.draw(vector2);
        VisualEffect.draw(vector2);
        this.mHUD.draw(n);
        this.mScreenEvents.draw();
    }

    private boolean jumpedOn(SweepTestResult sweepTestResult) {
        if (sweepTestResult.mCollision) {
            return sweepTestResult.mNormalFirst.mY < 0;
        }
        return false;
    }

    private void resolvePixelineCollisions() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        Vector2 vector2;
        Vector2 vector22;
        Object object;
        Object object2;
        Object object3;
        int n14;
        PixelineData pixelineData = this.mPixeline.getDataRef();
        if (!pixelineData.isAlive()) {
            return;
        }
        Vector2 vector23 = pixelineData.getPositionRef();
        Vector2 vector24 = pixelineData.getPositionPrevRef();
        Vector2 vector25 = pixelineData.getDimensionRef();
        int n15 = pixelineData.getTotemState();
        this.mCollisionCheckZone.mMinX = vector23.mX - (vector25.mX >> 1) - 0x1E0000;
        this.mCollisionCheckZone.mMaxX = vector23.mX + (vector25.mX >> 1) + 0x1E0000;
        this.mCollisionCheckZone.mMinY = vector23.mY - vector25.mY - 0x1E0000;
        this.mCollisionCheckZone.mMaxY = vector23.mY + 0x1E0000;
        int n16 = vector23.mX - (vector25.mX >> 1);
        int n17 = vector23.mY - vector25.mY;
        int n18 = vector23.mX + (vector25.mX >> 1);
        int n19 = vector23.mY;
        int n20 = vector24.mX - (vector25.mX >> 1);
        int n21 = vector24.mY - vector25.mY;
        int n22 = vector24.mX + (vector25.mX >> 1);
        int n23 = vector24.mY;
        if (this.mExitArea.collision(n16, n17, n18, n19) && this.runEndLevelCode()) {
            return;
        }
        int n24 = this.mEnemy1List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy1List[n14];
            object2 = ((Enemy1)object3).getDataRef();
            if (!((Enemy1Data)object2).isAlive()) continue;
            object = ((Enemy1Data)object2).getPositionRef();
            if (((Vector2)object).mX < this.mCollisionCheckZone.mMinX || ((Vector2)object).mX > this.mCollisionCheckZone.mMaxX || ((Vector2)object).mY < this.mCollisionCheckZone.mMinY || ((Vector2)object).mY > this.mCollisionCheckZone.mMaxY) continue;
            vector22 = ((Enemy1Data)object2).getPositionPrevRef();
            vector2 = ((Enemy1Data)object2).getDimensionRef();
            n13 = vector22.mX - (vector2.mX >> 1);
            n12 = vector22.mY - vector2.mY;
            n11 = vector22.mX + (vector2.mX >> 1);
            n10 = vector22.mY;
            n9 = vector23.mX - vector24.mX + (vector22.mX - ((Vector2)object).mX);
            n8 = vector23.mY - vector24.mY + (vector22.mY - ((Vector2)object).mY);
            if (!SweepTest.BoxBoxSweep(n13, n12, n11, n10, n20, n21, n22, n23, n9, n8, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy1)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                if (n15 == 0) {
                    ((Enemy1)object3).eventKill();
                    SoundBuffer.play(9, 100);
                } else {
                    n7 = ((Vector2)object).mY - vector2.mY - vector23.mY;
                    if (n7 < this.mPixelineYProjection) {
                        this.mPixelineYProjection = n7;
                    }
                }
                this.mPixelineJump = true;
                continue;
            }
            this.mPixelineTakeDamageMonster = true;
        }
        n24 = this.mEnemy2List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy2List[n14];
            object2 = ((Enemy2)object3).getDataRef();
            if (!((Enemy2Data)object2).isAlive()) continue;
            object = ((Enemy2Data)object2).getPositionRef();
            if (((Vector2)object).mX < this.mCollisionCheckZone.mMinX || ((Vector2)object).mX > this.mCollisionCheckZone.mMaxX || ((Vector2)object).mY < this.mCollisionCheckZone.mMinY || ((Vector2)object).mY > this.mCollisionCheckZone.mMaxY) continue;
            vector22 = ((Enemy2Data)object2).getPositionPrevRef();
            vector2 = ((Enemy2Data)object2).getDimensionRef();
            n13 = vector22.mX - (vector2.mX >> 1);
            n12 = vector22.mY - vector2.mY;
            n11 = vector22.mX + (vector2.mX >> 1);
            n10 = vector22.mY;
            n9 = vector23.mX - vector24.mX + (vector22.mX - ((Vector2)object).mX);
            n8 = vector23.mY - vector24.mY + (vector22.mY - ((Vector2)object).mY);
            if (!SweepTest.BoxBoxSweep(n13, n12, n11, n10, n20, n21, n22, n23, n9, n8, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy2)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                if (n15 == 0) {
                    ((Enemy2)object3).eventKill();
                    SoundBuffer.play(9, 100);
                } else {
                    n7 = ((Vector2)object).mY - vector2.mY - vector23.mY;
                    if (n7 < this.mPixelineYProjection) {
                        this.mPixelineYProjection = n7;
                    }
                }
                this.mPixelineJump = true;
                continue;
            }
            this.mPixelineTakeDamageMonster = true;
        }
        n24 = this.mEnemy3List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy3List[n14];
            object2 = ((Enemy3)object3).getDataRef();
            if (!((Enemy3Data)object2).isAlive()) continue;
            object = ((Enemy3Data)object2).getPositionRef();
            if (((Vector2)object).mX < this.mCollisionCheckZone.mMinX || ((Vector2)object).mX > this.mCollisionCheckZone.mMaxX || ((Vector2)object).mY < this.mCollisionCheckZone.mMinY || ((Vector2)object).mY > this.mCollisionCheckZone.mMaxY) continue;
            vector22 = ((Enemy3Data)object2).getPositionPrevRef();
            vector2 = ((Enemy3Data)object2).getDimensionRef();
            n13 = vector22.mX - (vector2.mX >> 1);
            n12 = vector22.mY - vector2.mY;
            n11 = vector22.mX + (vector2.mX >> 1);
            n10 = vector22.mY;
            n9 = vector23.mX - vector24.mX + (vector22.mX - ((Vector2)object).mX);
            n8 = vector23.mY - vector24.mY + (vector22.mY - ((Vector2)object).mY);
            if (!SweepTest.BoxBoxSweep(n13, n12, n11, n10, n20, n21, n22, n23, n9, n8, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy3)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                this.mPixelineJump = true;
                n7 = ((Vector2)object).mY - vector2.mY - vector23.mY;
                if (n7 < this.mPixelineYProjection) {
                    this.mPixelineYProjection = n7;
                }
            }
            this.mPixelineTakeDamageMonster = true;
        }
        n24 = this.mEnemy4List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy4List[n14];
            object2 = ((Enemy4)object3).getDataRef();
            object = ((Enemy4Data)object2).getBombRef();
            if (((FruitBomb)object).getActive()) {
                ((FruitBomb)object).update();
                vector22 = ((FruitBomb)object).getPositionRef();
                int n25 = vector22.mX - 131072;
                n9 = vector22.mY - 131072;
                n8 = vector22.mX + 131072;
                n13 = vector22.mY + 131072;
                n12 = 1;
                if (n18 < n25 || n16 > n8 || n19 < n9 || n17 > n13) {
                    n12 = 0;
                }
                if (n12 != 0) {
                    if (n15 != 3) {
                        this.mPixelineTakeDamageMonster = true;
                    }
                    ((FruitBomb)object).destroy();
                }
            }
            if (!((Enemy4Data)object2).isAlive()) continue;
            vector22 = ((Enemy4Data)object2).getPositionRef();
            if (vector22.mX < this.mCollisionCheckZone.mMinX || vector22.mX > this.mCollisionCheckZone.mMaxX || vector22.mY < this.mCollisionCheckZone.mMinY || vector22.mY > this.mCollisionCheckZone.mMaxY) continue;
            Vector2 vector26 = ((Enemy4Data)object2).getDimensionRef();
            n13 = vector22.mX - (vector26.mX >> 1);
            n12 = vector22.mY - vector26.mY;
            n11 = vector22.mX + (vector26.mX >> 1);
            n10 = vector22.mY;
            n9 = vector23.mX - vector24.mX;
            n8 = vector23.mY - vector24.mY;
            if (!SweepTest.BoxBoxSweep(n13, n12, n11, n10, n20, n21, n22, n23, n9, n8, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy4)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                if (n15 == 0) {
                    ((Enemy4)object3).eventKill();
                    SoundBuffer.play(9, 100);
                } else {
                    n7 = vector22.mY - vector26.mY - vector23.mY;
                    if (n7 < this.mPixelineYProjection) {
                        this.mPixelineYProjection = n7;
                    }
                }
                this.mPixelineJump = true;
                continue;
            }
            this.mPixelineTakeDamageMonster = true;
        }
        n24 = this.mEnemy5List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy5List[n14];
            object2 = ((Enemy5)object3).getDataRef();
            if (!((Enemy5Data)object2).isAlive()) continue;
            object = ((Enemy5Data)object2).getPositionRef();
            if (((Vector2)object).mX < this.mCollisionCheckZone.mMinX || ((Vector2)object).mX > this.mCollisionCheckZone.mMaxX || ((Vector2)object).mY < this.mCollisionCheckZone.mMinY || ((Vector2)object).mY > this.mCollisionCheckZone.mMaxY) continue;
            vector22 = ((Enemy5Data)object2).getPositionPrevRef();
            Vector2 vector27 = ((Enemy5Data)object2).getDimensionRef();
            n13 = vector22.mX - (vector27.mX >> 1);
            n12 = vector22.mY - (vector27.mY >> 1);
            n11 = vector22.mX + (vector27.mX >> 1);
            n10 = vector22.mY + (vector27.mY >> 1);
            n9 = vector23.mX - vector24.mX + (vector22.mX - ((Vector2)object).mX);
            n8 = vector23.mY - vector24.mY + (vector22.mY - ((Vector2)object).mY);
            if (!SweepTest.BoxBoxSweep(n13, n12, n11, n10, n20, n21, n22, n23, n9, n8, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy5)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                if (n15 == 0) {
                    ((Enemy5)object3).eventKill();
                    SoundBuffer.play(9, 100);
                } else {
                    n7 = ((Vector2)object).mY - vector27.mY - vector23.mY;
                    if (n7 < this.mPixelineYProjection) {
                        this.mPixelineYProjection = n7;
                    }
                }
                this.mPixelineJump = true;
                continue;
            }
            this.mPixelineTakeDamageMonster = true;
        }
        n24 = this.mEnemy6List.length;
        for (n14 = 0; n14 < n24; ++n14) {
            object3 = this.mEnemy6List[n14];
            object2 = ((Enemy6)object3).getDataRef();
            if (!((Enemy6Data)object2).isAlive()) continue;
            object = ((Enemy6Data)object2).getPositionRef();
            if (((Vector2)object).mX < this.mCollisionCheckZone.mMinX || ((Vector2)object).mX > this.mCollisionCheckZone.mMaxX || ((Vector2)object).mY < this.mCollisionCheckZone.mMinY || ((Vector2)object).mY > this.mCollisionCheckZone.mMaxY) continue;
            vector22 = ((Enemy6Data)object2).getDimensionRef();
            n8 = ((Vector2)object).mX - (vector22.mX >> 1);
            n13 = ((Vector2)object).mY - vector22.mY;
            n12 = ((Vector2)object).mX + (vector22.mX >> 1);
            n11 = ((Vector2)object).mY;
            int n26 = vector23.mX - vector24.mX;
            n9 = vector23.mY - vector24.mY;
            if (!SweepTest.BoxBoxSweep(n8, n13, n12, n11, n20, n21, n22, n23, n26, n9, this.mResult)) continue;
            if (n15 == 3) {
                ((Enemy6)object3).eventKill();
                SoundBuffer.play(9, 100);
                continue;
            }
            if (this.jumpedOn(this.mResult)) {
                if (((Enemy6Data)object2).getDeadly()) {
                    this.mPixelineTakeDamageMonster = true;
                } else if (n15 == 0) {
                    ((Enemy6)object3).eventKill();
                    SoundBuffer.play(9, 100);
                }
                n10 = ((Vector2)object).mY - vector22.mY - vector23.mY;
                if (n10 < this.mPixelineYProjection) {
                    this.mPixelineYProjection = n10;
                }
                this.mPixelineJump = true;
                continue;
            }
            this.mPixelineTakeDamageMonster = true;
        }
        if (this.mDanger1s.collision(n16, n17, n18, n19)) {
            this.mPixelineInstantDeath = true;
        }
        if (this.mDanger2s.collision(n16, n17, n18, n19)) {
            this.mPixelineTakeDamageDanger = true;
        }
        if (this.mDanger3s.collision(n16, n17, n18, n19)) {
            this.mPixelineTakeDamageDanger = true;
        }
        if (this.mDanger4s.collision(n16, n17, n18, n19)) {
            this.mPixelineTakeDamageDanger = true;
        }
        if (this.mPixelineJump) {
            this.mPixeline.eventJumpOnEnemy();
        }
        if (this.mPixelineInstantDeath) {
            this.mScriptHelper.handleEvent((byte)21);
            this.mHUD.eventLoseHealth(0);
            pixelineData.setHealth(0);
            this.mPixeline.eventDie();
            SoundBuffer.play(13, 1000);
            GameState.mLives = (byte)(GameState.mLives - 1);
        } else if ((this.mPixelineTakeDamageMonster || this.mPixelineTakeDamageDanger) && !pixelineData.isInvulnerable()) {
            n14 = pixelineData.getHealth();
            if (n14 > 1) {
                if (this.mPixelineTakeDamageDanger) {
                    SoundBuffer.play(0, 100);
                } else if (this.mPixelineTakeDamageMonster) {
                    SoundBuffer.play(0, 100);
                }
                this.mHUD.eventLoseHealth(n14 - 1);
                pixelineData.setHealth(n14 - 1);
                this.mPixeline.eventTakeDamage();
            } else {
                this.mScriptHelper.handleEvent((byte)21);
                this.mHUD.eventLoseHealth(0);
                pixelineData.setHealth(0);
                this.mPixeline.eventDie();
                SoundBuffer.play(13, 1000);
                GameState.mLives = (byte)(GameState.mLives - 1);
            }
        }
        this.mPixelineInstantDeath = false;
        this.mPixelineJump = false;
        this.mPixelineTakeDamageDanger = false;
        this.mPixelineTakeDamageMonster = false;
        if (!pixelineData.isAlive()) {
            return;
        }
        n14 = this.mCheckpoints.collision(n16, n17, n18, n19);
        if (n14 > -1) {
            GameState.mActiveCheckpoint = (byte)n14;
            GameState.mMemGoldCoinsFound = GameState.mActiveGoldCoinsFound;
            GameState.mMemKeysFound = GameState.mActiveKeysFound;
            GameState.mMemChestsOpened = GameState.mActiveChestsOpened;
            GameState.mMemNumGoldCoins = GameState.mActiveNumGoldCoins;
            GameState.mMemNumUnusedKeys = GameState.mActiveNumUnusedKeys;
            GameState.mMemNumChestsOpened = GameState.mActiveNumChestsOpened;
            SoundBuffer.play(23, 500);
            this.mScriptHelper.handleEvent((byte)14);
        }
        if ((n24 = this.mGoldCoins.collision(n16, n17, n18, n19)) > -1) {
            GameState.mActiveGoldCoinsFound = (short)(GameState.mActiveGoldCoinsFound | 1 << n24);
            GameState.mActiveNumGoldCoins = (byte)(GameState.mActiveNumGoldCoins + 1);
            Promotion.updateGoldCoinsCollected();
            this.mScreenEvents.queueEvent(0, GameState.mActiveNumGoldCoins, Defines.mNumGoldCoins[GameState.mLevel]);
            this.updateCollectionState();
            if (GameState.mAllChestsOpened && GameState.mAllGoldCoinsCollected) {
                this.mScriptHelper.handleEvent((byte)22);
            }
            SoundBuffer.play(12, 200);
        }
        if ((n6 = this.mSilverCoins.collision(n16, n17, n18, n19)) > 0) {
            this.addSilverCoins(n6);
            SoundBuffer.play(11, 200);
        }
        if ((n5 = this.mKeys.collision(n16, n17, n18, n19)) > -1) {
            GameState.mActiveKeysFound = (byte)(GameState.mActiveKeysFound | 1 << n5);
            GameState.mActiveNumUnusedKeys = (byte)(GameState.mActiveNumUnusedKeys + 1);
            SoundBuffer.play(24, 200);
        }
        if ((n4 = this.mChests.collision(n16, n17, n18, n19)) > -1 && GameState.mActiveNumUnusedKeys > 0) {
            GameState.mActiveNumUnusedKeys = (byte)(GameState.mActiveNumUnusedKeys - 1);
            this.mChests.open(n4);
            GameState.mActiveChestsOpened = (byte)(GameState.mActiveChestsOpened | 1 << n4);
            GameState.mActiveNumChestsOpened = (byte)(GameState.mActiveNumChestsOpened + 1);
            this.mScreenEvents.queueEvent(1, GameState.mActiveNumChestsOpened, Defines.mNumChests[GameState.mLevel]);
            this.updateCollectionState();
            if (GameState.mAllChestsOpened && GameState.mAllGoldCoinsCollected) {
                this.mScriptHelper.handleEvent((byte)22);
            } else {
                this.mScriptHelper.handleEvent((byte)13);
            }
            SoundBuffer.play(25, 200);
        }
        if ((n3 = this.mHealth.collision(n16, n17, n18, n19)) > -1 && (n2 = pixelineData.getHealth()) < 3) {
            pixelineData.setHealth(n2 + 1);
            this.mHealth.take(n3);
            SoundBuffer.play(22, 200);
        }
        if (this.mPixelineYProjection != 0) {
            vector23.mY += this.mPixelineYProjection - 65536;
            this.mPixelineYProjection = 0;
        }
        if ((n = this.mTutorialStones.collision(n16, n17, n18, n19)) > -1) {
            switch (n) {
                case 0: {
                    this.mScriptHelper.handleEvent((byte)1);
                    break;
                }
                case 1: {
                    this.mScriptHelper.handleEvent((byte)2);
                    break;
                }
                case 2: {
                    PixelineData pixelineData2 = this.mPixeline.getDataRef();
                    if (pixelineData2.getHealth() < 3) {
                        this.mScriptHelper.handleEvent((byte)4);
                        break;
                    }
                    this.mScriptHelper.handleEvent((byte)3);
                    break;
                }
                case 3: {
                    this.mScriptHelper.handleEvent((byte)5);
                    break;
                }
                case 4: {
                    this.mScriptHelper.handleEvent((byte)6);
                    break;
                }
                case 5: {
                    this.mScriptHelper.handleEvent((byte)7);
                    break;
                }
                case 6: {
                    this.mScriptHelper.handleEvent((byte)8);
                    break;
                }
                case 7: {
                    this.mScriptHelper.handleEvent((byte)9);
                    break;
                }
                case 8: {
                    this.mScriptHelper.handleEvent((byte)10);
                    break;
                }
                case 9: {
                    this.mScriptHelper.handleEvent((byte)11);
                    break;
                }
                case 10: {
                    this.mScriptHelper.handleEvent((byte)12);
                }
            }
        }
    }

    public void intersectionTest(int n, int n2, int n3, int n4, int n5, SurfaceIntersectionResult surfaceIntersectionResult) {
        surfaceIntersectionResult.clear();
        int n6 = this.mSurfaces.length;
        for (int i = 0; i < n6; ++i) {
            Surface surface = this.mSurfaces[i];
            if (surface == null || !surface.getSolidity()) continue;
            Vector2 vector2 = surface.getVelocity();
            int n7 = n3 - vector2.mX;
            int n8 = n4 - vector2.mY;
            if (!this.mSurfaces[i].intersectionTest(n, n2, n + n7, n2 + n8, n5, surfaceIntersectionResult)) continue;
            return;
        }
    }

    public boolean collisionTest(int n, int n2, AABB aABB) {
        return this.mTileManager.getCollisionInfo(n, n2, aABB);
    }

    public void handleEvent(byte by) {
        this.mScriptHelper.handleEvent(by);
    }

    public boolean isScriptPlaying() {
        return this.mScriptHelper.isScriptPlaying();
    }

    public void spawnParticle(int n, int n2, int n3, int n4, int n5) {
        this.mParticleSystem.spawnParticle(n, n2, n3, n4, n5, 0, -1, false);
    }

    public int getWorldMinX() {
        return this.mTileManager.getMinX();
    }

    public int getWorldMaxX() {
        return this.mTileManager.getMaxX();
    }

    public int getWorldMaxY() {
        return this.mTileManager.getMaxY();
    }

    public void startRaycast(int n, int n2, int n3, int n4) {
        this.mTileManager.startRaycast(n, n2, n3, n4);
    }

    public boolean nextRayStepValid() {
        return this.mTileManager.nextRayStepValid();
    }

    public boolean rayStep(AABB aABB) {
        return this.mTileManager.rayStep(aABB);
    }

    private void updateCollectionState() {
        if (GameState.mActiveNumGoldCoins == this.mGoldCoins.getNumTotalCoins()) {
            GameState.mAllGoldCoinsCollected = true;
        }
        if (GameState.mActiveNumChestsOpened == this.mChests.getNumTotalChests()) {
            GameState.mAllChestsOpened = true;
        }
    }

    private void addSilverCoins(int n) {
        int n2;
        boolean bl = false;
        for (n2 = GameState.mSilverCoins + n; n2 >= 100; n2 -= 100) {
            if (GameState.mLives >= 99) continue;
            bl = true;
            GameState.mLives = (byte)(GameState.mLives + 1);
        }
        if (bl) {
            this.mScriptHelper.handleEvent((byte)17);
            this.mHUD.eventGainLife();
            SoundBuffer.play(14, 500);
        }
        GameState.mSilverCoins = (byte)n2;
    }

    public boolean runEndLevelCode() {
        PixelineData pixelineData = this.mPixeline.getDataRef();
        if (pixelineData.isOnGround() && pixelineData.isAlive()) {
            this.mState = 3;
            this.mPixeline.eventWin();
            MusicBuffer.stop();
            SoundBuffer.play(26, 1000);
            this.mScriptHelper.handleEvent((byte)15);
            GameState.mGoldCoinsFound[GameState.mLevel] = GameState.mActiveGoldCoinsFound;
            GameState.mKeysFound[GameState.mLevel] = GameState.mActiveKeysFound;
            GameState.mChestsOpened[GameState.mLevel] = GameState.mActiveChestsOpened;
            GameState.mNumGoldCoins[GameState.mLevel] = GameState.mActiveNumGoldCoins;
            GameState.mNumUnusedKeys[GameState.mLevel] = GameState.mActiveNumUnusedKeys;
            GameState.mNumChestsOpened[GameState.mLevel] = GameState.mActiveNumChestsOpened;
            GameState.mLastPlayedLevel = (byte)-1;
            if (GameState.mLevel == GameState.mReachedLevel) {
                boolean bl = Defines.mWorldFinalLookup[GameState.mLevel];
                int n = Defines.mWorldLookup[GameState.mReachedLevel];
                if ((GameState.mReachedLevel = (byte)(GameState.mReachedLevel + 1)) < 23) {
                    GameState.mMovePixelineToNextLevel = true;
                }
                if (bl) {
                    int n2 = 0;
                    switch (n) {
                        case 0: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 4;
                            break;
                        }
                        case 2: {
                            n2 = 8;
                            break;
                        }
                        case 3: {
                            n2 = 16;
                            break;
                        }
                        case 4: {
                            n2 = 32;
                        }
                    }
                    if ((GameState.mCutsceneState & n2) == 0) {
                        GameState.mPlayCutscene = n2;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void debugGainGoldcoin() {
        if (this.mState == 1) {
            this.mScreenEvents.queueEvent(0, 1, 5);
        }
    }

    public void debugGainChest() {
        if (this.mState == 1) {
            this.mScreenEvents.queueEvent(1, 1, 3);
        }
    }

    public void nextScriptEvent() {
        ++this.mScriptID;
        if (this.mScriptID > 23) {
            this.mScriptID = 0;
        }
    }

    public void prevScriptEvent() {
        --this.mScriptID;
        if (this.mScriptID < 0) {
            this.mScriptID = 23;
        }
    }

    public void runScriptEvent() {
        this.mScriptHelper.handleEvent((byte)this.mScriptID);
    }
}

