/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.items;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Checkpoints {
    private static final int HALF_WIDTH = 16;
    private static final int HALF_WIDTH_FP = 0x100000;
    private static final int HEIGHT_FP = 0x500000;
    private Vector2[] mPositions;
    private Movie mAnimOff;
    private Movie mAnimOn;
    private Movie mAnimTaken;
    private boolean mPlayingTakenAnim;

    public Checkpoints(Vector2[] vector2Array) {
        this.mPositions = vector2Array;
        this.mAnimOff = Movie.load((short)-5847);
        this.mAnimOn = Movie.load((short)-280);
        this.mAnimTaken = Movie.load((short)-702);
        this.mAnimOff.loadGfx();
        this.mAnimOn.loadGfx();
        this.mAnimTaken.loadGfx();
        this.mAnimOff.gotoTick(0);
        this.mAnimOn.gotoTick(0);
        this.mAnimTaken.gotoTick(0);
        this.mPlayingTakenAnim = false;
    }

    public void update() {
        if (this.mPlayingTakenAnim) {
            this.mAnimTaken.update(Timer.mDt);
            if (this.mAnimTaken.isDone()) {
                this.mPlayingTakenAnim = false;
            }
        }
    }

    public void draw(Vector2 vector2) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 2;
            long l2 = (long)vector2.mX * 5L >> 2;
            int n = (int)((l >> 16) - (l2 >> 16));
            int n2 = 40;
            long l3 = (long)vector22.mY * 5L >> 2;
            long l4 = (long)vector2.mY * 5L >> 2;
            int n3 = (int)((l3 >> 16) - (l4 >> 16));
            int n4 = 100;
            if (!Camera.isInside(n - (n2 >> 1), n3 - (n4 >> 1), n2, n4)) continue;
            if (i == GameState.mActiveCheckpoint) {
                if (this.mPlayingTakenAnim) {
                    this.mAnimTaken.draw(n, n3);
                    continue;
                }
                this.mAnimOn.draw(n, n3);
                continue;
            }
            this.mAnimOff.draw(n, n3);
        }
    }

    public int collision(int n, int n2, int n3, int n4) {
        if (GameState.mActiveCheckpoint >= this.mPositions.length - 1) {
            return -1;
        }
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (i <= GameState.mActiveCheckpoint) continue;
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX - 0x100000;
            int n6 = vector2.mX + 0x100000;
            int n7 = vector2.mY - 0x500000;
            int n8 = vector2.mY;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            this.mAnimTaken.gotoTick(0);
            this.mPlayingTakenAnim = true;
            return i;
        }
        return -1;
    }

    public Vector2 getCheckpointPosition(int n) {
        return this.mPositions[n];
    }
}

