/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.items;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Chests {
    private static final int HALF_WIDTH = 13;
    private static final int HALF_WIDTH_FP = 851968;
    private static final int HEIGHT_FP = 0x180000;
    private static final int STATE_CHEST_SHUT = 0;
    private static final int STATE_CHEST_TAKEN = 1;
    private static final int STATE_CHEST_OPEN = 2;
    private Vector2[] mPositions;
    private int[] mStates;
    private Movie mAnimShut;
    private Movie mAnimTaken;
    private Movie mAnimOpen;

    public Chests(Vector2[] vector2Array) {
        this.mPositions = vector2Array;
        this.mStates = new int[vector2Array.length];
        this.mAnimShut = Movie.load((short)18422);
        this.mAnimTaken = Movie.load((short)-19668);
        this.mAnimOpen = Movie.load((short)-11127);
        this.mAnimShut.loadGfx();
        this.mAnimTaken.loadGfx();
        this.mAnimOpen.loadGfx();
        this.mAnimShut.gotoTick(0);
        this.mAnimTaken.gotoTick(0);
        this.mAnimOpen.gotoTick(0);
        for (int i = 0; i < this.mPositions.length; ++i) {
            short s = (short)(1 << i);
            if ((GameState.mActiveChestsOpened & s) == 0) continue;
            this.mStates[i] = 2;
        }
    }

    public void update() {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] != 1) continue;
            this.mAnimTaken.update(64 * Timer.mDt >> 6);
            if (this.mAnimTaken.isDone()) {
                this.mStates[i] = 2;
            }
            return;
        }
    }

    public void draw(Vector2 vector2) {
        block5: for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 2;
            long l2 = (long)vector2.mX * 5L >> 2;
            int n = (int)((l >> 16) - (l2 >> 16));
            int n2 = 33;
            long l3 = (long)vector22.mY * 5L >> 2;
            long l4 = (long)vector2.mY * 5L >> 2;
            int n3 = (int)((l3 >> 16) - (l4 >> 16));
            int n4 = 30;
            if (!Camera.isInside(n - (n2 >> 1), n3 - n4, n2, n4)) continue;
            switch (this.mStates[i]) {
                case 0: {
                    this.mAnimShut.draw(n, n3);
                    continue block5;
                }
                case 1: {
                    this.mAnimTaken.draw(n, n3);
                    continue block5;
                }
                case 2: {
                    this.mAnimOpen.draw(n, n3);
                }
            }
        }
    }

    public int collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] != 0) continue;
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX - 851968;
            int n6 = vector2.mX + 851968;
            int n7 = vector2.mY - 0x180000;
            int n8 = vector2.mY;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            return i;
        }
        return -1;
    }

    public void open(int n) {
        this.mAnimTaken.gotoTick(0);
        this.mStates[n] = 1;
    }

    public int getNumTotalChests() {
        return this.mPositions.length;
    }

    public Vector2 getChestPosition(int n) {
        return this.mPositions[n];
    }

    public boolean isChestOpened(int n) {
        return this.mStates[n] != 0;
    }
}

