/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateWinning
extends PixelineState {
    private static final int STATE_WAITING_TRANSITION = 0;
    private static final int STATE_PLAYING_ANIMATION = 1;
    private int mState;
    private int mWinDelay;
    private int mTotemTransitionDelay;

    public PixelineStateWinning(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mX = 0;
        vector2.mY = 0;
        if (this.mData.getTotemState() != 0) {
            this.mController.requestTotemTransition(0);
            this.mView.setAnimState(0, false);
            this.mState = 0;
        } else {
            this.mView.setAnimState(9, true);
            this.mState = 1;
        }
        this.mTotemTransitionDelay = 500;
        this.mWinDelay = 3000;
    }

    public void exit() {
    }

    public void update() {
        switch (this.mState) {
            case 0: {
                this.mTotemTransitionDelay -= Timer.mDt;
                if (this.mTotemTransitionDelay > 0) break;
                this.mView.setAnimState(9, true);
                this.mState = 1;
                break;
            }
            case 1: {
                World world = this.mData.getWorldRef();
                this.mWinDelay -= Timer.mDt;
                if (this.mWinDelay > 0 || world.isScriptPlaying()) break;
                StateGame.transitionToMenu(true);
            }
        }
    }
}

