/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;
import dk.progressivemedia.skeleton.script.Script;

public class StateCutscene {
    private static final int STATE_TRANSITION_IN = 0;
    private static final int STATE_IMAGE_CROSS_FADING = 1;
    private static final int STATE_SCRIPT = 2;
    private static final int STATE_TRANSITION_OUT = 3;
    private static int mState;
    private static int mCurrentCutscene;
    private static int mCurrentProgress;
    private static int mCurrentImage;
    private static int mNextImage;
    private static int mAlpha;
    private static Script mCurrentScript;
    private static int[][] mCutsceneImages;
    private static short[][] mCutsceneScripts;
    private static int[][] mScriptImageIndex;

    public static void init(int n) {
        PMFile.loadScreen = true;
        switch (GameState.mPlayCutscene) {
            case 1: {
                mCurrentCutscene = 0;
                break;
            }
            case 2: {
                mCurrentCutscene = 1;
                break;
            }
            case 4: {
                mCurrentCutscene = 2;
                break;
            }
            case 8: {
                mCurrentCutscene = 3;
                break;
            }
            case 16: {
                mCurrentCutscene = 4;
                break;
            }
            case 32: {
                mCurrentCutscene = 5;
            }
        }
        GameState.mCutsceneState = (byte)(GameState.mCutsceneState | GameState.mPlayCutscene);
        GameState.mPlayCutscene = 0;
        mCurrentProgress = 0;
        mCurrentImage = mCutsceneImages[mCurrentCutscene][mCurrentProgress];
        mCurrentScript = Script.load(mCutsceneScripts[mCurrentCutscene][mCurrentProgress]);
        mAlpha = 65536;
        mState = 0;
        TransitionEffect.init(false);
        SoundBuffer.init();
        Touch.init();
        Timer.initTimer();
        Dialog.init(1, 1);
        PMFile.loadScreen = false;
    }

    public static void deinit() {
        Dialog.deinit();
        PMImageManager.unloadAll();
    }

    public static void update() {
        Timer.updateTimer();
        Dialog.update();
        switch (mState) {
            case 0: {
                if (TransitionEffect.update()) {
                    mState = 2;
                }
                StateCutscene.draw();
                TransitionEffect.draw();
                break;
            }
            case 2: {
                mCurrentScript.update(Timer.mDt);
                if (mCurrentScript.isDone() && !Dialog.isActive()) {
                    mCurrentScript.stop();
                    mCurrentScript.unload();
                    if (mCutsceneScripts[mCurrentCutscene].length == ++mCurrentProgress) {
                        mState = 3;
                        TransitionEffect.init(true);
                    } else {
                        mAlpha = 65536;
                        int n = mScriptImageIndex[mCurrentCutscene][mCurrentProgress];
                        mNextImage = mCutsceneImages[mCurrentCutscene][n];
                        PMImageManager.load(mNextImage);
                        mState = 1;
                    }
                }
                StateCutscene.draw();
                break;
            }
            case 1: {
                if ((mAlpha -= 3971 * Timer.mDt >> 6) <= 0) {
                    PMImageManager.unload(mCurrentImage);
                    mCurrentImage = mNextImage;
                    mCurrentScript = Script.load(mCutsceneScripts[mCurrentCutscene][mCurrentProgress]);
                    mState = 2;
                    mAlpha = 65536;
                }
                StateCutscene.draw();
                break;
            }
            case 3: {
                if (TransitionEffect.update()) {
                    int n = -1;
                    switch (mCurrentCutscene) {
                        case 0: {
                            n = 7;
                            break;
                        }
                        case 1: {
                            n = 8;
                            break;
                        }
                        case 2: {
                            n = 9;
                            break;
                        }
                        case 3: {
                            n = 10;
                            break;
                        }
                        case 4: {
                            n = 11;
                            break;
                        }
                        case 5: {
                            n = 12;
                        }
                    }
                    PMStateManager.set(2, n);
                }
                StateCutscene.draw();
                TransitionEffect.draw();
            }
        }
        PMSystem.nextFrame();
    }

    private static void draw() {
        PMCanvas.PMGraphics_setColor(0xFFFFFF);
        PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
        int n = PMMath.MUL(mAlpha, 2560);
        int n2 = 640 - n;
        int n3 = 65536;
        int n4 = 65536;
        boolean bl = false;
        PMImageManager.draw(mCurrentImage, 0, 0, false, 0, 255, 65536, 65536);
        if (mState == 1) {
            int n5 = 320 - (n2 >> 1);
            PMImageManager.draw(mNextImage, n5, 0, false, 0, 255, 65536, 65536);
        }
        Dialog.draw();
    }

    static {
        mCutsceneImages = new int[][]{{528, 529}, {530, 531}, {532, 533}, {534, 535}, {536, 537}, {538, 539}};
        mCutsceneScripts = new short[][]{{12448, 195, 4322}, {-17533, -29728}, {25345, 21346}, {-9376, -5373}, {-15836, -3513}, {31301, 18982, 23047}};
        mScriptImageIndex = new int[][]{{0, 1, 0}, {0, 1}, {0, 1, 0}, {0, 1}, {0, 1}, {0, 1, 0}};
    }
}

