/*
 * Decompiled with CFR 0.152.
 */
package framework.graphics;

import framework.graphics.SimpleSprite;
import framework.math.FP;
import framework.math.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RotatableSprite {
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_ROT180 = 1;
    public int framesCount;
    private int[][] srcRgbDatas;
    private int[][] dstRgbDatas;
    private short srcImgWidth;
    private short srcImgHeight;
    private short dstImgSize;
    private short dstImgSizeDiv2;
    private short[] lastAngles;
    private int fp_origCenterX;
    private int fp_origCenterY;
    private int fp_newCenterX;
    private int fp_newCenterY;
    private int fp_srcImgWidth;
    private int fp_srcImgHeight;

    public RotatableSprite(String imgFileName, int framesCount) throws IOException {
        this(Image.createImage((String)imgFileName), framesCount);
    }

    public RotatableSprite(Image img, int framesCount) throws IOException {
        this.framesCount = framesCount;
        this.srcImgWidth = (short)(img.getWidth() / framesCount);
        this.srcImgHeight = (short)img.getHeight();
        this.dstImgSize = (short)(MathUtils.sqrt(this.srcImgWidth * this.srcImgWidth + this.srcImgHeight * this.srcImgHeight << FP.SHIFT) >> FP.SHIFT);
        this.dstImgSizeDiv2 = (short)(this.dstImgSize >> 1);
        this.srcRgbDatas = new int[framesCount][];
        this.dstRgbDatas = new int[framesCount][];
        this.lastAngles = new short[framesCount];
        int x = 0;
        for (int i = 0; i < framesCount; ++i) {
            this.srcRgbDatas[i] = new int[this.srcImgWidth * this.srcImgHeight];
            img.getRGB(this.srcRgbDatas[i], 0, (int)this.srcImgWidth, x, 0, (int)this.srcImgWidth, (int)this.srcImgHeight);
            this.dstRgbDatas[i] = new int[this.dstImgSize * this.dstImgSize];
            x += this.srcImgWidth;
            this.lastAngles[i] = -1;
        }
        this.fp_origCenterX = this.srcImgWidth >> 1 << FP.SHIFT;
        this.fp_origCenterY = this.srcImgHeight >> 1 << FP.SHIFT;
        this.fp_newCenterY = this.fp_newCenterX = this.dstImgSizeDiv2 << FP.SHIFT;
        this.fp_srcImgWidth = this.srcImgWidth << FP.SHIFT;
        this.fp_srcImgHeight = this.srcImgHeight << FP.SHIFT;
    }

    public void render(Graphics g, int centerX, int centerY, short angle, byte transform, int frameNumber, boolean processAlpha) {
        switch (transform) {
            case 1: {
                angle = (short)((angle + 180) % 360);
            }
        }
        if (angle != this.lastAngles[frameNumber]) {
            this.rotate(this.srcRgbDatas[frameNumber], this.dstRgbDatas[frameNumber], angle);
            this.lastAngles[frameNumber] = angle;
        }
        int dstX = centerX - this.dstImgSizeDiv2;
        int dstY = centerY - this.dstImgSizeDiv2;
        if (dstX >= 0 && dstY >= 0) {
            g.drawRGB(this.dstRgbDatas[frameNumber], 0, (int)this.dstImgSize, dstX, dstY, (int)this.dstImgSize, (int)this.dstImgSize, processAlpha);
        } else {
            int w = this.dstImgSize + dstX;
            int h = this.dstImgSize + dstY;
            if (w > 0 && h > 0) {
                if (dstX > 0) {
                    g.drawRGB(this.dstRgbDatas[frameNumber], -this.dstImgSize * dstY, (int)this.dstImgSize, dstX, 0, (int)this.dstImgSize, h, processAlpha);
                } else if (dstY > 0) {
                    g.drawRGB(this.dstRgbDatas[frameNumber], -dstX, (int)this.dstImgSize, 0, dstY, w, this.dstImgSize - 1, processAlpha);
                } else {
                    g.drawRGB(this.dstRgbDatas[frameNumber], -this.dstImgSize * dstY - dstX, (int)this.dstImgSize, 0, 0, w, h - 1, processAlpha);
                }
            }
        }
    }

    private void rotate(int[] rgb1, int[] rgb2, short angle) {
        int fp_cosAngle = MathUtils.cos(angle);
        int fp_sinAngle = MathUtils.sin(angle);
        int fp_origX = this.fp_origCenterX - (this.fp_newCenterX * fp_cosAngle >> FP.SHIFT) + (this.fp_newCenterY * fp_sinAngle >> FP.SHIFT);
        int fp_origY = this.fp_origCenterY - (this.fp_newCenterY * fp_cosAngle >> FP.SHIFT) - (this.fp_newCenterX * fp_sinAngle >> FP.SHIFT);
        int offset2 = 0;
        for (int newY = 0; newY < this.dstImgSize; ++newY) {
            int fp_tmpOrigX = fp_origX;
            int fp_tmpOrigY = fp_origY;
            for (int newX = 0; newX < this.dstImgSize; ++newX) {
                rgb2[offset2] = fp_tmpOrigX < 0 || fp_tmpOrigY < 0 || fp_tmpOrigX >= this.fp_srcImgWidth || fp_tmpOrigY >= this.fp_srcImgHeight ? 0 : rgb1[(fp_tmpOrigX >> FP.SHIFT) + (fp_tmpOrigY >> FP.SHIFT) * this.srcImgWidth];
                fp_tmpOrigX += fp_cosAngle;
                fp_tmpOrigY += fp_sinAngle;
                ++offset2;
            }
            fp_origX -= fp_sinAngle;
            fp_origY += fp_cosAngle;
        }
    }

    public SimpleSprite toSimpleSprite(short angle) {
        for (int i = 0; i < this.framesCount; ++i) {
            if (this.lastAngles[i] == angle) continue;
            this.rotate(this.srcRgbDatas[i], this.dstRgbDatas[i], angle);
        }
        int[] rgbData = new int[this.dstImgSize * this.framesCount * this.dstImgSize];
        int index1 = 0;
        for (int row = 0; row < this.dstImgSize; ++row) {
            int startIndex2 = row * this.dstImgSize;
            for (int frame = 0; frame < this.framesCount; ++frame) {
                int index2 = startIndex2;
                for (int column = 0; column < this.dstImgSize; ++column) {
                    rgbData[index1++] = this.dstRgbDatas[frame][index2++];
                }
            }
        }
        Image image = Image.createRGBImage((int[])rgbData, (int)(this.dstImgSize * this.framesCount), (int)this.dstImgSize, (boolean)true);
        return new SimpleSprite(image, this.framesCount);
    }

    public static SimpleSprite createRotatedSimpleSprite(Image img, int framesCount, short angle) throws IOException {
        if (angle == 0) {
            return new SimpleSprite(img, framesCount);
        }
        RotatableSprite rotSprite = new RotatableSprite(img, framesCount);
        SimpleSprite simpleSprite = rotSprite.toSimpleSprite(angle);
        rotSprite = null;
        System.gc();
        return simpleSprite;
    }
}

