/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.datapackets.subpackets.RankingInfo;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IRankingInfo;
import gs.common.info.IScoreInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.exceptions.GSException;
import gs.exceptions.PacketConversionException;
import java.util.Enumeration;
import java.util.Vector;

public class ScoreInfo
implements IScoreInfo,
IDataStringConvertible {
    private static final int NUMPACKETFILEDS = 2;
    private IGSId gameId;
    private Vector rankingInfo;

    public ScoreInfo() {
        this.gameId = null;
        this.rankingInfo = null;
    }

    public ScoreInfo(IScoreInfo info) throws GSException {
        this.gameId = info.getGameId();
        this.rankingInfo = info.getRankingInfo();
    }

    public ScoreInfo(IGSId gameId, Vector rankningInfo) {
        this.gameId = gameId;
        this.rankingInfo = new Vector();
        Enumeration elems = rankningInfo.elements();
        while (elems.hasMoreElements()) {
            IRankingInfo r = (IRankingInfo)elems.nextElement();
            this.rankingInfo.addElement(new RankingInfo(r));
        }
    }

    public IGSId getGameId() {
        return this.gameId;
    }

    public String toDataString() throws PacketConversionException {
        if (this.gameId == null || this.rankingInfo == null) {
            throw new PacketConversionException("ScoreInfo to data string: packet not initialized");
        }
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.gameId);
        result = result + DataPacketUtil.scoreInfoSeperator();
        for (int i = 0; i < this.rankingInfo.size(); ++i) {
            result = result + DataPacketUtil.objectToDataString((IRankingInfo)this.rankingInfo.elementAt(i));
            if (i >= this.rankingInfo.size() - 1) continue;
            result = result + DataPacketUtil.scoreListSeperator();
        }
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.scoreInfoSeperator());
        if (mainSplit.size() != 2) {
            throw new PacketConversionException("invalid packet type");
        }
        try {
            this.gameId = GSIdUtil.parseFromString((String)mainSplit.elementAt(0));
            this.rankingInfo = new Vector();
            Vector pSplit = CollectionUtil.splitString((String)mainSplit.elementAt(1), DataPacketUtil.scoreListSeperator());
            for (int i = 0; i < pSplit.size(); ++i) {
                RankingInfo rankingInfo2 = new RankingInfo();
                rankingInfo2.parseDataString((String)pSplit.elementAt(i));
                this.rankingInfo.addElement(rankingInfo2);
            }
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing ScoreInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public String toString() {
        String rankingInfoStr = "";
        for (int i = 0; i < this.rankingInfo.size(); ++i) {
            rankingInfoStr = rankingInfoStr + ((IRankingInfo)this.rankingInfo.elementAt(i)).toString() + ";";
        }
        return "ScoreInfo: gameId=" + ((Object)this.gameId).toString() + "; " + "rankingInfo=" + rankingInfoStr;
    }

    public Vector getRankingInfo() {
        return this.rankingInfo;
    }
}

