/*
 * Decompiled with CFR 0.152.
 */
package gs.common.gsconnectors.me;

import gs.common.Constants;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.gsconnectors.IGSConnector;
import gs.common.gsconnectors.me.SendDataWorker;
import gs.exceptions.ConnectorException;
import gs.exceptions.GSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public abstract class GSSocketConnectorME
implements IGSConnector,
Runnable {
    protected SocketConnection socket = null;
    protected InputStream inStream = null;
    protected OutputStream outStream = null;
    protected Boolean terminateConnection = Boolean.FALSE;
    protected Boolean isConnected = Boolean.FALSE;

    public void send(Object object) throws GSException {
        if (Boolean.TRUE.equals(this.isConnected)) {
            String string = ((IDataStringConvertible)object).toDataString();
            string = string + Constants.GSCONNECTORME_END_OF_LINE;
            SendDataWorker sendDataWorker = new SendDataWorker(this, this.outStream, string);
            Thread thread = new Thread(sendDataWorker);
            thread.start();
            thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.terminateConnection = Boolean.FALSE;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (Boolean.FALSE.equals(this.terminateConnection)) {
                if (this.inStream != null) {
                    n = this.inStream.read();
                }
                if (n == -1) {
                    this.notifyTerminated();
                    break;
                }
                stringBuffer.append((char)n);
                if (n != 10) continue;
                this.notifyReceived(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
        }
        catch (Exception exception) {
            if (!this.terminateConnection.equals(Boolean.TRUE) || !exception.getMessage().equals("Stream closed")) {
                System.out.println("Connection error.");
                this.notifyTerminated();
            }
        }
        finally {
            try {
                if (this.outStream != null) {
                    this.outStream.close();
                    this.outStream = null;
                }
                if (this.inStream != null) {
                    this.inStream.close();
                    this.inStream = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.isConnected = Boolean.FALSE;
            }
            catch (Exception exception) {
                System.out.println("Failed to deinitialize socket");
            }
        }
    }

    public abstract void notifyReceived(Object var1);

    public abstract void notifyTerminated();

    public abstract void sendFailed(String var1);

    public void connect(String string, int n) throws ConnectorException {
        try {
            this.socket = (SocketConnection)Connector.open((String)("socket://" + string + ":" + String.valueOf(n)), (int)3, (boolean)true);
            this.inStream = this.socket.openInputStream();
            this.outStream = this.socket.openOutputStream();
            this.isConnected = Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw new ConnectorException("Connect failed: " + iOException.getMessage());
        }
    }

    public void closeConnection() throws ConnectorException {
        this.terminateConnection = Boolean.TRUE;
        this.isConnected = Boolean.FALSE;
        try {
            if (this.outStream != null) {
                this.outStream.close();
            }
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            throw new ConnectorException("Error while closing connection: " + iOException.getMessage());
        }
    }

    public Boolean isConnected() {
        return this.isConnected;
    }
}

