/*
 * Decompiled with CFR 0.152.
 */
package framework.profiling;

import framework.graphics.TextRenderer;
import framework.profiling.Profiler;
import javax.microedition.lcdui.Graphics;

public final class ProfilerData {
    public String name;
    public long startTime;
    public long accDuration;
    private final StringBuffer stringBuffer = new StringBuffer();

    public ProfilerData(String name) {
        this.name = name;
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        long duration = System.currentTimeMillis() - this.startTime;
        this.accDuration += duration;
        Profiler.totalDuration += duration;
    }

    public void resetAccDuration() {
        this.accDuration = 0L;
    }

    public void render(Graphics g, int x, int y) {
        this.stringBuffer.delete(0, this.stringBuffer.length());
        this.stringBuffer.append(this.name);
        this.stringBuffer.append(": ");
        this.stringBuffer.append(this.accDuration);
        if (Profiler.totalDuration != 0L) {
            this.stringBuffer.append("  ");
            this.stringBuffer.append(this.accDuration * 100L / Profiler.totalDuration);
        } else {
            this.stringBuffer.append("  ");
        }
        TextRenderer.getInstance().renderText(g, x, y, this.stringBuffer);
    }
}

