/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.BoundedString;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.MessageType;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IMessageInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.GSException;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class MessageDataPacket
implements IDataStringConvertible,
IMessageInfo {
    private static final int NUMPACKETFIELDS = 5;
    private IGSId senderId;
    private BoundedString senderName;
    private Short messageType;
    private Vector receiverIds;

    public MessageDataPacket() {
        this.senderId = null;
        this.senderName = null;
        this.messageType = null;
        this.receiverIds = null;
    }

    public MessageDataPacket(IGSId senderId, Short messageType, Vector receiverIds) {
        this.senderId = senderId;
        this.senderName = BoundedString.empty();
        this.messageType = messageType;
        this.receiverIds = receiverIds;
    }

    public MessageDataPacket(IGSId senderId, Short messageType, BoundedString senderName) {
        this.senderId = senderId;
        this.senderName = senderName;
        this.messageType = messageType;
        this.receiverIds = new Vector();
    }

    public String toDataString() throws PacketConversionException {
        if (this.senderId == null || this.messageType == null || this.senderName == null && this.receiverIds == null) {
            throw new PacketConversionException("MessageDatapacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.senderId);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.senderName);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.messageType);
        result = result + DataPacketUtil.mainDPSeperator();
        for (int i = 0; i < this.receiverIds.size(); ++i) {
            result = result + DataPacketUtil.objectToDataString(this.receiverIds.elementAt(i));
            result = result + DataPacketUtil.listDPSeperator();
        }
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainsplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        try {
            if (PacketType.Message.equals(ObjectUtil.shortFromString((String)mainsplit.elementAt(0))) || mainsplit.size() != 5) {
                throw new PacketConversionException("parsing MessageDataPacket: invalid packet type");
            }
            this.senderId = GSIdUtil.parseFromString((String)mainsplit.elementAt(1));
            this.senderName = new BoundedString((String)mainsplit.elementAt(2));
            this.messageType = ObjectUtil.shortFromString((String)mainsplit.elementAt(3));
            this.receiverIds = new Vector();
            Vector rSplit = CollectionUtil.splitString((String)mainsplit.elementAt(4), DataPacketUtil.listDPSeperator());
            for (int i = 0; i < rSplit.size(); ++i) {
                this.receiverIds.addElement(GSIdUtil.parseFromString((String)rSplit.elementAt(i)));
            }
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing MessageDatapacket: " + e.getMessage());
        }
    }

    public IGSId getSenderId() throws GSException {
        return this.senderId;
    }

    public BoundedString getSenderName() throws GSException {
        return this.senderName;
    }

    public Vector getReceivers() throws GSException {
        return this.receiverIds;
    }

    public Short getMessage() throws GSException {
        return this.messageType;
    }

    public Short getPacketType() {
        return PacketType.Message;
    }

    public String toString() {
        return "MessageDataPacket: senderId=" + ((Object)this.senderId).toString() + "; " + "senderName=" + this.senderName.toString() + "; " + "messageType=" + MessageType.messageTypeToString(this.messageType) + "; " + "receiverIds=" + CollectionUtil.vectorToString(this.receiverIds);
    }
}

