/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.BoundedString;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.GameType;
import gs.common.enumerations.PacketType;
import gs.common.info.IRoomInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class RoomInfo
implements IDataStringConvertible,
IRoomInfo {
    private static final int NUMPACKETFILEDS = 5;
    private Integer roomNumber;
    private BoundedString roomName;
    private Short gameType;
    private Integer freeSlots;
    private Boolean isRanking;

    public RoomInfo() {
        this.roomNumber = new Integer(-1);
        this.roomName = null;
        this.gameType = GameType.Invalid;
        this.freeSlots = new Integer(-1);
        this.isRanking = null;
    }

    public RoomInfo(Integer roomNumber, BoundedString roomName, Short gameType, Integer freeSlots, Boolean isRanking) {
        this.roomNumber = roomNumber;
        this.roomName = roomName;
        this.gameType = gameType;
        this.freeSlots = freeSlots;
        this.isRanking = isRanking;
    }

    public RoomInfo(IRoomInfo info) {
        this.roomNumber = info.getNumber();
        this.roomName = info.getName();
        this.gameType = info.getGameType();
        this.freeSlots = info.getFreeSlots();
        this.isRanking = info.getIsRanking();
    }

    public String toDataString() throws PacketConversionException {
        if (new Integer(-1).equals(this.roomNumber) || this.roomName == null || this.gameType == GameType.Invalid || this.isRanking == null || new Integer(-1).equals(this.freeSlots)) {
            throw new PacketConversionException("RoomInfo to data string: packet not initialized");
        }
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.roomNumber);
        result = result + DataPacketUtil.roomInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.roomName);
        result = result + DataPacketUtil.roomInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameType);
        result = result + DataPacketUtil.roomInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.freeSlots);
        result = result + DataPacketUtil.roomInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.isRanking);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.roomInfoSeperator());
        if (mainSplit.size() != 5) {
            throw new PacketConversionException("parsing RoomInfo: invalid packet type");
        }
        try {
            this.roomNumber = ObjectUtil.integerFromString((String)mainSplit.elementAt(0));
            this.roomName = new BoundedString((String)mainSplit.elementAt(1));
            this.gameType = ObjectUtil.shortFromString((String)mainSplit.elementAt(2));
            this.freeSlots = ObjectUtil.integerFromString((String)mainSplit.elementAt(3));
            this.isRanking = ObjectUtil.booleanFromString((String)mainSplit.elementAt(4));
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing RoomInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public Integer getNumber() {
        return this.roomNumber;
    }

    public BoundedString getName() {
        return this.roomName;
    }

    public Short getGameType() {
        return this.gameType;
    }

    public Integer getFreeSlots() {
        return this.freeSlots;
    }

    public Boolean getIsRanking() {
        return this.isRanking;
    }

    public String toString() {
        return "RoomInfo: roomNumber=" + this.roomNumber.toString() + "; " + "roomName=" + this.roomName.toString() + "; " + "isRanking=" + this.isRanking.toString() + "; " + "gameType=" + GameType.gameTypeToString(this.gameType) + "; " + "freeSlots=" + this.freeSlots.toString();
    }
}

