/*
 * Decompiled with CFR 0.152.
 */
package menu;

import framework.Globals;
import framework.MainGameCanvas;
import framework.Texts;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import framework.sound.Music;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.MenuBackground;
import root.RMSSettings;
import root.TanksCanvas;
import root.TanksMIDlet;

public class InGameMenu {
    Font font1 = Font.getFont((int)0, (int)0, (int)8);
    public MenuForm menu;
    public MenuForm connectionTerminatedInfoMenu;
    private MenuForm lastMenu;
    public MenuForm pauseMenu;
    public MenuForm helpMenu;
    public MenuForm rulesMenu;
    public MenuForm scoreMenu;
    public MenuForm rematchMenu;
    public MenuForm controlsMenu;
    public MenuForm trainingInfoMenu;
    public MenuForm noRematchMenu;
    public MenuForm initializingMenu;
    public MenuForm waitingMenu;
    public MenuForm waitingBoardMenu;
    private int continueID;
    private int againID;
    private int menuID;
    private int soundID;
    private int musicID;
    private int helpID;
    private int vibrationsID;
    private int exitID;
    private int fontSize;
    private int score;
    private TanksCanvas tanksCanvas;
    public boolean isActive = false;
    public MainGameCanvas mainGameCanvas;
    private TanksMIDlet midlet;
    private StringBuffer playerText;
    private StringBuffer enemyText;
    private Image winImg;
    private Image loseImg;
    private Image drawImg;

    public InGameMenu(MainGameCanvas mainGameCanvas, TanksCanvas tanksCanvas, TanksMIDlet midlet) {
        this.mainGameCanvas = mainGameCanvas;
        this.tanksCanvas = tanksCanvas;
        this.midlet = midlet;
        this.fontSize = TextRenderer.getInstance().getStringHeight(1);
        this.loadMenus();
    }

    public boolean loadMenus() {
        if (this.pauseMenu == null) {
            this.createPauseMenu();
            this.menu = this.pauseMenu;
        }
        if (this.scoreMenu == null) {
            this.createScoreMenu(Texts.WIN, true);
        }
        if (this.rematchMenu == null) {
            this.createRematchMenu();
        }
        if (this.waitingMenu == null) {
            this.createWaitingMenu();
        }
        try {
            this.winImg = Image.createImage((String)"/t_zwyciestwo.png");
            this.loseImg = Image.createImage((String)"/t_przegrana.png");
            this.drawImg = Image.createImage((String)"/t_remis.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void updateSettings() {
        this.pauseMenu.getControlByID((int)this.musicID).text = Music.isMusic ? new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF);
        this.pauseMenu.getControlByID((int)this.soundID).text = Music.isSound ? new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
        this.pauseMenu.getControlByID((int)this.vibrationsID).text = Music.isVibration ? new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF);
    }

    public void deinitialize() {
        this.pauseMenu = null;
        this.menu = null;
        System.gc();
    }

    public void render(Graphics g) {
        if (this.isActive) {
            if (this.menu == this.connectionTerminatedInfoMenu || this.menu == this.waitingMenu) {
                MenuBackground.GetInstance().Draw(g, 2);
            } else if (this.menu == this.trainingInfoMenu || this.menu == this.scoreMenu) {
                MenuBackground.GetInstance().Draw(g, 5);
            } else {
                MenuBackground.GetInstance().Draw(g, 4);
            }
            if (this.menu == this.scoreMenu) {
                g.setColor(0);
                TextRenderer.getInstance().setCurrentFont("FONT_NORMAL");
                if (this.score == 1 || Globals.endGameType == 3 || Globals.endGameType == 20) {
                    g.drawImage(this.winImg, 125, 107, 17);
                } else if (this.score == 2 || Globals.endGameType == 4 || Globals.endGameType == 21) {
                    g.drawImage(this.loseImg, 125, 107, 17);
                } else if (this.score == 5) {
                    g.drawImage(this.drawImg, 125, 107, 17);
                }
            }
            if (this.menu != null) {
                this.menu.drawMenu(g);
            }
        }
    }

    private StringBuffer space(int count) {
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            str.append(" ");
        }
        return str;
    }

    public void setScore(int score) {
        this.score = score;
        this.playerText = new StringBuffer(Globals.playerNickname + " [" + Globals.playerPoints + "]" + this.space(10 - Globals.playerNickname.length() - Globals.playerPoints.length()) + Globals.pointsDiffPlayer);
        this.enemyText = new StringBuffer(Globals.enemyNickname + " [" + Globals.enemyPoints + "]" + this.space(10 - Globals.enemyNickname.length() - Globals.enemyPoints.length()) + Globals.pointsDiffEnemy);
    }

    public void update(int deltaTime) {
        this.menu.update(deltaTime);
    }

    public boolean isActive() {
        return this.menu != null;
    }

    private void createPauseMenu() {
        int[] cols = new int[]{0, 0, -1};
        int[] rows = new int[]{this.fontSize * 4, this.fontSize * 6, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, -1};
        this.pauseMenu = MenuForm.createMenuForm(6, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continueID = this.pauseMenu.createControl(4, 0, 3, 1, null, Texts.MENU_CONTINUE);
        this.musicID = Music.isMusic ? this.pauseMenu.createControl(4, 1, 4, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON)) : this.pauseMenu.createControl(4, 1, 4, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF));
        this.soundID = Music.isSound ? this.pauseMenu.createControl(4, 2, 5, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON)) : this.pauseMenu.createControl(4, 2, 5, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF));
        this.vibrationsID = Music.isVibration ? this.pauseMenu.createControl(4, 3, 6, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON)) : this.pauseMenu.createControl(4, 3, 6, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF));
        this.helpID = this.pauseMenu.createControl(4, 4, 7, 1, null, Texts.MENU_HELP);
        this.exitID = this.pauseMenu.createControl(4, 5, 8, 1, null, Texts.MENU_END);
        this.connectionTerminatedInfoMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.connectionTerminatedInfoMenu.createControl(4, -1, 6, 1, null, Texts.CONNECTION_TERMINATED_TEXT);
        this.initializingMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.initializingMenu.createControl(4, -1, 6, 1, null, Texts.MENU_LOADING_TERRAIN);
        this.trainingInfoMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.trainingInfoMenu.createScrollBox(168, 160, -1, 2, 1, 10, 10, Texts.TRAINING_INFO, 0);
        this.waitingBoardMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.waitingBoardMenu.createScrollBox(168, 160, -1, 4, 1, 10, 10, Texts.WAITING_FOR_BOARD, 0);
        this.controlsMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.controlsMenu.createScrollBox(168, 160, -1, 2, 1, 10, 10, Texts.MENU_CONTROLS_INFO, 0);
    }

    public void createScoreMenu(StringBuffer info, boolean rematchPossible) {
        int[] cols = new int[]{0, 0, -1};
        int[] rows = new int[]{this.fontSize * 5, this.fontSize * 6, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, -1};
        if (rematchPossible) {
            this.scoreMenu = MenuForm.createDynamicMenuForm(rows, cols, 240, 320, (byte)1, (byte)0, 5);
            if (!TanksCanvas.isTraining) {
                this.scoreMenu.createControl(4, -1, 4, 1, null, this.playerText);
                this.scoreMenu.createControl(4, -1, 5, 1, null, this.enemyText);
                this.againID = this.scoreMenu.createControl(4, 0, 7, 1, null, Texts.PLAY_AGAIN);
                this.menuID = this.scoreMenu.createControl(4, 1, 8, 1, null, Texts.MENU);
            } else {
                this.againID = this.scoreMenu.createControl(4, 0, 5, 1, null, Texts.PLAY_AGAIN);
                this.menuID = this.scoreMenu.createControl(4, 1, 6, 1, null, Texts.MENU);
            }
        } else {
            this.scoreMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
            this.scoreMenu.createControl(1, 168, 80, -1, 3, 1, 10, 10, null, info, 0, 0);
            this.scoreMenu.createControl(4, -1, 5, 1, null, this.playerText);
            this.scoreMenu.createControl(4, -1, 6, 1, null, this.enemyText);
            this.menuID = this.scoreMenu.createControl(4, 0, 8, 1, null, Texts.MENU);
            this.againID = -1;
        }
    }

    private void createRematchMenu() {
        int[] cols = new int[]{0, 0, -1};
        int[] rows = new int[]{this.fontSize * 7, this.fontSize + 2, this.fontSize * 6, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, -1};
        this.rematchMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.rematchMenu.createControl(1, 240 - 2 * this.fontSize - this.fontSize / 2, 106, -1, 3, 1, 10, 10, null, Texts.CONFIRM_REMATCH, 0, 0);
        this.noRematchMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.noRematchMenu.createControl(1, 240 - 2 * this.fontSize - this.fontSize / 2, 106, -1, 3, 1, 10, 10, null, Texts.NO_REMATCH, 0, 0);
    }

    private void createWaitingMenu() {
        int[] cols = new int[]{0, 0, -1};
        int[] rows = new int[]{this.fontSize * 7, this.fontSize + 2, this.fontSize * 6, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, -1};
        this.waitingMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.waitingMenu.createControl(1, 240 - 2 * this.fontSize - this.fontSize / 2, 106, -1, 3, 1, 10, 10, null, Texts.WAITING_FOR_ANSWER, 0, 0);
    }

    public void handleInput() {
        if (this.menu != null) {
            this.menu.handleInput(this.tanksCanvas.getKeyStates());
        }
    }

    public void keyPressed(int keyCode) {
        block26: {
            block25: {
                block24: {
                    block23: {
                        if (keyCode == -6 || keyCode == -5 || keyCode == 53) {
                            this.notifyKeypressed(this.menu.id, this.menu.focusedID);
                        }
                        if ((this.menu.id == this.controlsMenu.id || this.menu.id == this.waitingMenu.id) && keyCode == -7) {
                            this.menu = this.pauseMenu;
                        }
                        if (this.menu.id == this.rematchMenu.id) {
                            if (keyCode == -6) {
                                this.menu = this.initializingMenu;
                                this.tanksCanvas.sendRematchAnswer(true);
                            }
                            if (keyCode == -7) {
                                this.tanksCanvas.sendRematchAnswer(false);
                                this.tanksCanvas.quitGame(false);
                            }
                        } else if (this.menu.id == this.noRematchMenu.id) {
                            if (keyCode == -7 || keyCode == -6) {
                                this.tanksCanvas.quitGame(false);
                            }
                        } else if (this.menu.id == this.connectionTerminatedInfoMenu.id) {
                            if (keyCode == -7) {
                                this.tanksCanvas.quitGame(false);
                            }
                        } else if (this.menu.id == this.trainingInfoMenu.id && (keyCode == -6 || keyCode == -7 || keyCode == -5)) {
                            this.isActive = false;
                            this.menu = this.pauseMenu;
                        }
                        if (keyCode == -2) break block23;
                        if (keyCode != 56) break block24;
                    }
                    if (this.menu.id == this.trainingInfoMenu.id || this.menu.id == this.controlsMenu.id) {
                        ++this.menu.getControlByID((int)0).currentLine;
                    }
                }
                if (keyCode == -1) break block25;
                if (keyCode != 50) break block26;
            }
            if (this.menu.id == this.trainingInfoMenu.id || this.menu.id == this.controlsMenu.id) {
                --this.menu.getControlByID((int)0).currentLine;
            }
        }
    }

    public void notifyKeypressed(int formID, int controlID) {
        if (formID == this.pauseMenu.id) {
            if (controlID == this.continueID) {
                this.isActive = false;
            }
            if (controlID == this.musicID) {
                this.changeMusic();
            }
            if (controlID == this.soundID) {
                this.changeSound();
            }
            if (controlID == this.vibrationsID) {
                this.changeVibrations();
            }
            if (controlID == this.helpID) {
                this.menu = this.controlsMenu;
            }
            if (controlID == this.exitID) {
                if (TanksCanvas.isTraining) {
                    TanksCanvas.isTraining = false;
                    this.tanksCanvas.quitGame(false);
                } else {
                    this.tanksCanvas.quitGame(true);
                }
            }
        }
        if (formID == this.scoreMenu.id) {
            if (controlID == this.againID) {
                if (TanksCanvas.isTraining) {
                    this.tanksCanvas.startGame();
                } else {
                    this.tanksCanvas.sendRematchRequest();
                    this.menu = this.waitingMenu;
                }
            }
            if (controlID == this.menuID) {
                this.tanksCanvas.quitGame(false);
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void changeMusic() {
        if (!Music.isMusic) {
            Music.isMusic = true;
            this.pauseMenu.getControlByID((int)this.musicID).text = new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON);
            if (Music.isSound) {
                this.changeSound();
            }
            Music.playMusic(TanksMIDlet.gameMusicId);
            RMSSettings.saveRecords();
        } else {
            Music.isMusic = false;
            this.pauseMenu.getControlByID((int)this.musicID).text = new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF);
            Music.stopMusic();
            RMSSettings.saveRecords();
        }
    }

    public void changeSound() {
        if (!Music.isSound) {
            Music.isSound = true;
            this.pauseMenu.getControlByID((int)this.soundID).text = new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON);
            if (Music.isMusic) {
                this.changeMusic();
            } else {
                RMSSettings.saveRecords();
            }
        } else {
            Music.isSound = false;
            RMSSettings.saveRecords();
            this.pauseMenu.getControlByID((int)this.soundID).text = new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
        }
    }

    public void changeVibrations() {
        if (!Music.isVibration) {
            Music.isVibration = true;
            this.pauseMenu.getControlByID((int)this.vibrationsID).text = new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON);
            RMSSettings.saveRecords();
        } else {
            Music.isVibration = false;
            this.pauseMenu.getControlByID((int)this.vibrationsID).text = new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF);
            RMSSettings.saveRecords();
        }
    }

    public void updateGameMenu() {
        this.pauseMenu.getControlByID((int)this.vibrationsID).text = Music.isVibration ? new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF);
        this.pauseMenu.getControlByID((int)this.soundID).text = Music.isSound ? new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
        this.pauseMenu.getControlByID((int)this.soundID).text = Music.isSound ? new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
    }
}

