/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Fire
extends Sprite {
    private boolean typePlayer = false;
    private int speedX;
    private int speedY;
    private boolean isLeft = true;
    private byte sleep = 0;
    public boolean active = false;

    public Fire(Image img, boolean typePlayer) {
        super(img, img.getWidth(), img.getHeight());
        int[] sequence = new int[]{0};
        this.setFrameSequence(sequence);
        this.setVisible(true);
        this.defineReferencePixel(img.getHeight() / 2, img.getHeight() / 2);
        this.off();
        this.typePlayer = typePlayer;
    }

    public boolean start(Player player) {
        if (!this.active) {
            this.on();
            int y = player.getY() + 15;
            this.isLeft = player.lookLeft;
            int x = 0;
            x = this.isLeft ? player.getX() + 5 : player.getX() + player.getWidth() - 10;
            this.setPosition(x, y);
            return true;
        }
        return false;
    }

    public void startSearch(Sprite spDestino, Sprite spOrigen) {
        if (!this.active) {
            this.on();
            int x = spOrigen.getX();
            int y = spOrigen.getY();
            this.setPosition(x, y);
            this.setPosition(spDestino);
        }
    }

    public void compute() {
        if (this.active) {
            if (this.getX() + this.getWidth() < 0 || this.getX() > Interface.SCREEN_W || this.getY() + this.getHeight() < 0 || this.getY() > Interface.SCREEN_H) {
                this.off();
            }
            if (this.typePlayer) {
                if (this.isLeft) {
                    this.move(-6, 0);
                } else {
                    this.move(6, 0);
                }
            } else {
                this.sleep = (byte)(this.sleep + 1);
                if (this.sleep > 1) {
                    this.move(this.speedX, this.speedY);
                    this.sleep = 0;
                }
            }
        }
    }

    public void draw(Graphics g) {
        if (this.active) {
            super.paint(g);
        }
    }

    private void setPosition(Sprite sp) {
        int dy_abs;
        int[] aux = new int[]{6, 6, 7, 7, 8, 8, 9, 9};
        int velocidad = aux[Interface.level];
        int dx = sp.getX() - this.getX();
        int dy = sp.getY() - this.getY();
        int dx_abs = Math.abs(dx) + 1;
        if (dx_abs > (dy_abs = Math.abs(dy) + 1)) {
            this.speedX = dx > 0 ? velocidad : -velocidad;
            this.speedY = dy * velocidad / dx_abs;
        } else {
            this.speedY = dy > 0 ? velocidad : -velocidad;
            this.speedX = dx * velocidad / dy_abs;
        }
    }

    public void off() {
        this.active = false;
    }

    public void on() {
        this.active = true;
    }
}

