/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Elements
extends Sprite {
    private byte count = 0;
    private byte[][] isActive;

    public Elements(int maxScreen, Image img) {
        super(img, img.getWidth() / 5, img.getHeight());
        int[] sequence = new int[]{0, 1, 2, 3, 4};
        this.setFrameSequence(sequence);
        this.setVisible(true);
        this.defineReferencePixel(img.getHeight() / 2, img.getHeight() / 2);
        this.isActive = new byte[maxScreen][4];
    }

    public void resetAll(int id) {
        int i;
        for (int n = 0; n < this.isActive.length; ++n) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.isActive[n][i2] = 0;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.isActive[1][i] = 1;
        }
        for (i = 0; i < 4; ++i) {
            this.isActive[2][i] = 3;
        }
        for (i = 0; i < 4; ++i) {
            this.isActive[3][i] = 1;
        }
        for (i = 0; i < 4; ++i) {
            this.isActive[5][i] = 4;
        }
    }

    public void reset(Plataforma plataforma) {
        this.count = (byte)plataforma.cuadros;
        if (this.count > 4) {
            this.count = (byte)4;
        }
        if (plataforma.h > 10) {
            this.setPosition(plataforma.x + 5, plataforma.y - 20);
        } else {
            this.setPosition(plataforma.x + 5, plataforma.y + 10);
        }
        if (this.isActive[plataforma.level][0] > 0) {
            this.setFrame(this.isActive[plataforma.level][0]);
        }
    }

    public int collision(Sprite sp, int idPlataformaLevel) {
        if (sp.getY() + sp.getHeight() > this.getY() && sp.getY() < this.getY() + this.getHeight()) {
            int auxX = this.getX();
            for (int n = 0; n < this.count; ++n) {
                if (this.isActive[idPlataformaLevel][n] > -1 && sp.getX() + sp.getWidth() > auxX && sp.getX() < auxX + this.getWidth()) {
                    byte aux = this.isActive[idPlataformaLevel][n];
                    this.isActive[idPlataformaLevel][n] = -1;
                    return aux;
                }
                auxX += 20;
            }
        }
        return -1;
    }

    public void draw(Graphics g, int idPlataformaLevel) {
        int auxX = this.getX();
        for (int n = 0; n < this.count; ++n) {
            if (this.isActive[idPlataformaLevel][n] > -1) {
                super.setFrame((int)this.isActive[idPlataformaLevel][n]);
                super.paint(g);
            }
            this.move(20, 0);
        }
        this.setPosition(auxX, this.getY());
    }
}

