/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall;

import com.george.games.Drawable;
import com.george.games.Number;
import com.george.headfall.Game;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Setting;
import com.george.headfall.Viewport;
import com.george.headfall.objects.Player;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bar
implements Drawable {
    private Player player;
    private Game game;
    private Image imgHealth;
    private int lastHealth;
    private int lastScore;
    private Number scoreNumber;
    private Number topScoreNumber;
    private Image imgTime;
    private long time;
    private long lastTime;

    public Bar(Game game) {
        this.game = game;
        this.player = Player.getInstance();
        this.imgHealth = HeadFallRes.HEALTH2;
        this.lastHealth = this.player.getHealth();
        this.scoreNumber = new Number(this.player.getScore(), 10, 20);
        this.topScoreNumber = new Number(Setting.getInstance().getTopScore(), 40, HeadFallRes.BAR_BACK.getHeight() + 7);
        this.lastScore = this.player.getScore();
        this.lastTime = this.time = game.getTime();
        this.imgTime = Image.createImage((Image)HeadFallRes.PROG2, (int)0, (int)0, (int)HeadFallRes.PROG2.getWidth(), (int)1, (int)0);
    }

    public void cycle() {
        Image image;
        this.time = this.game.getTime();
        try {
            image = HeadFallRes.PROG2;
            if (this.lastTime != this.time) {
                this.imgTime = Image.createImage((Image)image, (int)0, (int)(image.getHeight() - (int)this.time), (int)image.getWidth(), (int)((int)this.time), (int)0);
                this.lastTime = this.time;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.lastHealth != this.player.getHealth()) {
            this.lastHealth = this.player.getHealth();
            try {
                image = HeadFallRes.HEALTH2;
                if (this.player.getHealth() != 0) {
                    this.imgHealth = Image.createImage((Image)image, (int)0, (int)0, (int)(image.getWidth() * this.player.getHealth() / 5), (int)image.getHeight(), (int)0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.lastScore != this.player.getScore()) {
            this.scoreNumber.setNumber(this.player.getScore());
            this.lastScore = this.player.getScore();
        }
    }

    public void draw(Graphics g) {
        if (this.game.isPaused()) {
            return;
        }
        g.drawImage(HeadFallRes.BAR_BACK, 0, 0, 0);
        g.drawImage(HeadFallRes.TOP_SCORE, 10, HeadFallRes.BAR_BACK.getHeight(), 0);
        g.drawImage(HeadFallRes.HEALTH, 100, 15, 0);
        if (this.player.getHealth() != 0) {
            g.drawImage(this.imgHealth, 100, 15, 0);
        }
        g.drawImage(HeadFallRes.PAUSE, Viewport.WIDTH - HeadFallRes.PAUSE.getWidth() - 5, 2, 0);
        this.scoreNumber.draw(g);
        this.topScoreNumber.draw(g);
        g.drawImage(HeadFallRes.PROG1, 10, 100, 0);
        g.drawImage(this.imgTime, 10, 100 + (HeadFallRes.PROG1.getHeight() - this.imgTime.getHeight()), 0);
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (x > Viewport.WIDTH - HeadFallRes.PAUSE.getWidth() - 5) {
            this.game.pause();
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public boolean contains(int y) {
        return y < HeadFallRes.BAR_BACK.getHeight();
    }

    public void keyPressed(int keyCode) {
    }

    public void input(int keyStates) {
    }
}

