/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.headfall.Game;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Main;
import com.george.headfall.res.ResMenu;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class TrailMenu
implements Drawable {
    private Sprite pointer;
    private Sprite mainMenu;
    private Sprite fullVersion;
    private Vector vecSprites;
    private Game game;

    public TrailMenu(Game game) {
        this.game = game;
        this.pointer = new Sprite(Image.createImage((int)5, (int)5));
        this.pointer.setPosition(-5, -5);
        this.mainMenu = ResMenu.MAIN_MENU;
        this.mainMenu.setFrame(0);
        this.mainMenu.setPosition(163, 548);
        this.vecSprites = new Vector();
        this.vecSprites.addElement(this.mainMenu);
        this.fullVersion = HeadFallRes.FULL_VERSION;
        this.fullVersion.setFrame(0);
        this.fullVersion.setPosition(217, 20);
    }

    public void cycle() {
    }

    public void draw(Graphics g) {
        g.drawImage(HeadFallRes.TRIAL, 0, 0, 0);
        this.mainMenu.paint(g);
        this.fullVersion.paint(g);
    }

    public void pointerPressed(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1);
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.mainMenu, false)) {
            this.game.setEndTask(Tasks.ViewMainMenu());
            this.game.stop();
        }
        if (this.pointer.collidesWith(this.fullVersion, false)) {
            Main.getFullVersion();
        }
        this.pointer.setPosition(-5, -5);
        this.resetAll();
    }

    public void pointerDragged(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1);
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    private void resetAll() {
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            sprite.setFrame(0);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void input(int keyStates) {
    }
}

