/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall.objects;

import com.george.headfall.HeadFallRes;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import com.george.headfall.objects.FallingObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Stone
extends FallingObject {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private boolean hittedPlayer;

    public Stone(int sp, int type) {
        this.sp = sp;
        Image image = null;
        image = HeadFallRes.STONE;
        this.sprite = new Sprite(image, image.getWidth() / 3, image.getHeight());
        switch (type) {
            case 0: {
                this.sprite.setPosition(50, -this.sprite.getHeight());
                break;
            }
            case 1: {
                this.sprite.setPosition(Viewport.WIDTH - 50 - this.sprite.getWidth(), -this.sprite.getHeight());
            }
        }
    }

    public void cycle() {
        if (!this.hittedPlayer && this.player.collides(this.sprite, true)) {
            SoundsPlayer.getInstance().runrock();
            this.player.hit(1);
            this.hittedPlayer = true;
            this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + 50);
            this.sprite.setPosition(this.player.getX() + this.player.getWidth() / 2 - HeadFallRes.STONE_BREAK.getWidth() / 2, this.sprite.getY());
        }
        if (this.sprite.getY() > Viewport.HEIGHT) {
            this.legalForRemove = true;
        }
        this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + this.sp);
        this.sprite.nextFrame();
    }

    public void draw(Graphics g) {
        if (!this.hittedPlayer) {
            this.sprite.paint(g);
        } else {
            g.drawImage(HeadFallRes.STONE_BREAK, this.sprite.getX(), this.sprite.getY(), 0);
        }
    }
}

