/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.tools;

import com.inodesoft.game.tools.ICFunctions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ICResourceManager {
    private static final String PACKAGE_NAME = "res";
    private int numFiles;
    private String[] resNames;
    private byte[] resIndex;
    private short[] resLength;
    private int[] resOffset;
    private int lastIndex = -1;
    private InputStream is;
    private static ICResourceManager m_instance = null;

    public static ICResourceManager getInstance() {
        if (m_instance == null) {
            m_instance = new ICResourceManager();
        }
        return m_instance;
    }

    public byte[] getResource(String name) {
        byte[] buffer = new byte[64];
        try {
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(baos.getClass().getResourceAsStream("/" + name));
            while ((length = dis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] data = baos.toByteArray();
            dis.close();
            baos.close();
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Image getImage(String name) {
        try {
            return Image.createImage((String)("/" + name));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public DataInputStream getResourceAsStream(String name) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/" + name));
            return dis;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Image loadImage(DataInputStream dis, int[] palette) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        int readed = dis.read(buffer);
        while (readed != -1) {
            baos.write(buffer, 0, readed);
            readed = dis.read(buffer);
        }
        buffer = baos.toByteArray();
        if (palette != null) {
            ICFunctions.changePNGPalette(buffer, palette);
        }
        Image resimage = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
        baos.close();
        dis.close();
        baos = null;
        dis = null;
        return resimage;
    }

    public static Image loadImage(String file) {
        Image res = null;
        try {
            res = ICResourceManager.getInstance().loadImage(ICResourceManager.getInstance().getResourceAsStream(file), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }
}

