/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.GameEngine;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICResourceManager;
import javax.microedition.lcdui.Graphics;

public class InvProjectile
extends InvObject {
    public static final int PROJECTILE_TYPE_MISSILE = 0;
    public static final int PROJECTILE_TYPE_BULLET = 1;
    public static final int PROJECTILE_TYPE_PLASMA = 2;
    public static final long MAX_ALIVE_TIME = 3000L;
    static ICAnimation m_missiles = null;
    static int max_sprite_width = -1;
    long started_at;
    int type;
    int dir;
    boolean alive = false;
    boolean terrestrial = false;

    public InvProjectile(GameEngine ge, int type, int dir) {
        super(ge);
        if (m_missiles == null) {
            m_missiles = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("projectiles.lqa"));
        }
        this.m_sprite = m_missiles;
        if (max_sprite_width == -1) {
            for (int i = 0; i < this.m_sprite.getNumSprites(); ++i) {
                if (max_sprite_width >= this.m_sprite.getSpriteWidth(i)) continue;
                max_sprite_width = this.m_sprite.getSpriteWidth(i);
            }
        }
        this.started_at = System.currentTimeMillis();
        this.alive = true;
        this.type = type;
        this.dir = dir;
        switch (type) {
            case 0: {
                this.col_x = 0;
                this.col_y = 0;
                this.col_w = 21;
                this.col_h = 11;
                break;
            }
            case 1: {
                this.col_x = 0;
                this.col_y = 0;
                this.col_w = 6;
                this.col_h = 6;
                break;
            }
            case 2: {
                this.col_x = 0;
                this.col_y = 0;
                this.col_w = 13;
                this.col_h = 14;
            }
        }
        if (dir < 0) {
            this.col_x -= this.col_w;
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isTerrestrial() {
        return this.terrestrial;
    }

    public void setTerrestrial() {
        this.terrestrial = true;
    }

    public void paint(Graphics g, int world_offset) {
        this.m_x_pos = this.ab_pos_x + world_offset;
        if (this.m_x_pos < -max_sprite_width || this.m_x_pos > this.ge.getWidth() + max_sprite_width) {
            return;
        }
        switch (this.type) {
            case 0: {
                this.m_sprite.drawSprite(g, 9, this.m_x_pos, this.m_y_pos, this.dir > 0 ? 0 : 2);
                break;
            }
            case 1: {
                this.m_sprite.drawSprite(g, 10, this.m_x_pos, this.m_y_pos, this.dir > 0 ? 0 : 2);
                break;
            }
            case 2: {
                this.m_sprite.drawSprite(g, 17, this.m_x_pos, this.m_y_pos, this.dir > 0 ? 0 : 2);
            }
        }
    }

    public void update(long time, int world_offset) {
        long alive_time = System.currentTimeMillis() - this.started_at;
        this.alive = alive_time < 3000L;
        this.curr_state_time = time - this.start_state_time;
        this.ab_pos_x += this.dir * 8;
        this.tcol_x = this.ab_pos_x;
        if (this.terrestrial) {
            this.m_y_pos -= 8;
        }
    }

    public void explode() {
        this.alive = false;
    }
}

