/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Line;

public strictfp class LineCircleCollider
implements Collider {
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        Line line = (Line)bodyA.getShape();
        Circle circle = (Circle)bodyB.getShape();
        Vector2f[] vertsA = line.getVertices(bodyA.getPosition(), bodyA.getRotation());
        Vector2f startA = vertsA[0];
        Vector2f endA = vertsA[1];
        ROVector2f startB = bodyB.getPosition();
        Vector2f endB = new Vector2f(endA);
        endB.sub(startA);
        endB.set(endB.y, -endB.x);
        float d = endB.y * (endA.x - startA.x);
        float uA = endB.x * (startA.y - startB.getY());
        uA -= endB.y * (startA.x - startB.getX());
        Vector2f position = null;
        position = uA < 0.0f ? startA : (uA > 1.0f ? endA : new Vector2f(startA.x + (uA /= (d -= endB.x * (endA.y - startA.y))) * (endA.x - startA.x), startA.y + uA * (endA.y - startA.y)));
        Vector2f normal = endB;
        normal.set(startB);
        normal.sub(position);
        float distSquared = normal.lengthSquared();
        float radiusSquared = circle.getRadius() * circle.getRadius();
        if (distSquared < radiusSquared) {
            contacts[0].setPosition(position);
            contacts[0].setFeature(new FeaturePair());
            normal.normalise();
            contacts[0].setNormal(normal);
            float separation = (float)Math.sqrt(distSquared) - circle.getRadius();
            contacts[0].setSeparation(separation);
            return 1;
        }
        return 0;
    }
}

