/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLayer;
import com.jarbull.efw.game.EFTiledLayer;
import com.jarbull.efw.game.ISprite;
import javax.microedition.lcdui.Graphics;

public class EFSprite
extends EFLayer
implements ISprite {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    String sourceImagePath;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int dRefX;
    int dRefY;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;
    int t_currentTransformation;
    int t_collisionRectX;
    int t_collisionRectY;
    int t_collisionRectWidth;
    int t_collisionRectHeight;

    public EFSprite(String imagePath) {
        super(ImageHandler.getInstance().getImage(imagePath).getWidth(), ImageHandler.getInstance().getImage(imagePath).getHeight());
        this.initializeFrames(imagePath, ImageHandler.getInstance().getImage(imagePath).getWidth(), ImageHandler.getInstance().getImage(imagePath).getHeight(), false);
        this.initCollisionRectBounds();
        this.setTransformImpl(0);
    }

    public EFSprite(String imagePath, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        if (frameWidth < 1 || frameHeight < 1 || ImageHandler.getInstance().getImage(imagePath).getWidth() % frameWidth != 0 || ImageHandler.getInstance().getImage(imagePath).getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(imagePath, frameWidth, frameHeight, false);
        this.initCollisionRectBounds();
        this.setTransformImpl(0);
    }

    public String getImageId() {
        return this.sourceImagePath;
    }

    public void defineReferencePixel(int inp_x, int inp_y) {
        this.dRefX = inp_x;
        this.dRefY = inp_y;
    }

    public void setRefPixelPosition(int inp_x, int inp_y) {
        this.x = inp_x - this.getTransformedPtX(this.dRefX, this.dRefY, this.t_currentTransformation);
        this.y = inp_y - this.getTransformedPtY(this.dRefX, this.dRefY, this.t_currentTransformation);
    }

    public int getRefPixelX() {
        return this.x + this.getTransformedPtX(this.dRefX, this.dRefY, this.t_currentTransformation);
    }

    public int getRefPixelY() {
        return this.y + this.getTransformedPtY(this.dRefX, this.dRefY, this.t_currentTransformation);
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            g.drawRegion(ImageHandler.getInstance().getImage(this.sourceImagePath), this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.frameCoordsY[this.frameSequence[this.sequenceIndex]], this.srcFrameWidth, this.srcFrameHeight, this.t_currentTransformation, this.x, this.y, 20);
        }
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i = 0; i < this.numberFrames; ++i) {
                this.frameSequence[i] = i;
            }
            return;
        }
        if (sequence.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (sequence[i] >= 0 && sequence[i] < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.frameSequence, 0, sequence.length);
        this.sequenceIndex = 0;
    }

    public void setImage(String imagePath, int frameWidth, int frameHeight) {
        if (frameWidth < 1 || frameHeight < 1 || ImageHandler.getInstance().getImage(imagePath).getWidth() % frameWidth != 0 || ImageHandler.getInstance().getImage(imagePath).getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        int noOfFrames = ImageHandler.getInstance().getImage(imagePath).getWidth() / frameWidth * (ImageHandler.getInstance().getImage(imagePath).getHeight() / frameHeight);
        boolean maintainCurFrame = true;
        if (noOfFrames < this.numberFrames) {
            maintainCurFrame = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != frameWidth || this.srcFrameHeight != frameHeight) {
            int oldX = this.x + this.getTransformedPtX(this.dRefX, this.dRefY, this.t_currentTransformation);
            int oldY = this.y + this.getTransformedPtY(this.dRefX, this.dRefY, this.t_currentTransformation);
            this.setWidth(frameWidth);
            this.setHeight(frameHeight);
            this.initializeFrames(imagePath, frameWidth, frameHeight, maintainCurFrame);
            this.initCollisionRectBounds();
            this.x = oldX - this.getTransformedPtX(this.dRefX, this.dRefY, this.t_currentTransformation);
            this.y = oldY - this.getTransformedPtY(this.dRefX, this.dRefY, this.t_currentTransformation);
            this.computeTransformedBounds(this.t_currentTransformation);
        } else {
            this.initializeFrames(imagePath, frameWidth, frameHeight, maintainCurFrame);
        }
    }

    public final boolean collidesWith(EFSprite s, boolean pixelLevel) {
        if (!s.visible || !this.visible) {
            return false;
        }
        int otherLeft = s.x + s.t_collisionRectX;
        int otherTop = s.y + s.t_collisionRectY;
        int otherRight = otherLeft + s.t_collisionRectWidth;
        int otherBottom = otherTop + s.t_collisionRectHeight;
        int left = this.x + this.t_collisionRectX;
        int top = this.y + this.t_collisionRectY;
        int right = left + this.t_collisionRectWidth;
        int bottom = top + this.t_collisionRectHeight;
        if (this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom)) {
            if (pixelLevel) {
                if (this.t_collisionRectX < 0) {
                    left = this.x;
                }
                if (this.t_collisionRectY < 0) {
                    top = this.y;
                }
                if (this.t_collisionRectX + this.t_collisionRectWidth > this.width) {
                    right = this.x + this.width;
                }
                if (this.t_collisionRectY + this.t_collisionRectHeight > this.height) {
                    bottom = this.y + this.height;
                }
                if (s.t_collisionRectX < 0) {
                    otherLeft = s.x;
                }
                if (s.t_collisionRectY < 0) {
                    otherTop = s.y;
                }
                if (s.t_collisionRectX + s.t_collisionRectWidth > s.width) {
                    otherRight = s.x + s.width;
                }
                if (s.t_collisionRectY + s.t_collisionRectHeight > s.height) {
                    otherBottom = s.y + s.height;
                }
                if (!this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom)) {
                    return false;
                }
                int intersectLeft = left < otherLeft ? otherLeft : left;
                int intersectTop = top < otherTop ? otherTop : top;
                int intersectRight = right < otherRight ? right : otherRight;
                int intersectBottom = bottom < otherBottom ? bottom : otherBottom;
                int intersectWidth = Math.abs(intersectRight - intersectLeft);
                int intersectHeight = Math.abs(intersectBottom - intersectTop);
                int thisImageXOffset = this.getImageTopLeftX(intersectLeft, intersectTop, intersectRight, intersectBottom);
                int thisImageYOffset = this.getImageTopLeftY(intersectLeft, intersectTop, intersectRight, intersectBottom);
                int otherImageXOffset = s.getImageTopLeftX(intersectLeft, intersectTop, intersectRight, intersectBottom);
                int otherImageYOffset = s.getImageTopLeftY(intersectLeft, intersectTop, intersectRight, intersectBottom);
                return EFSprite.doPixelCollision(thisImageXOffset, thisImageYOffset, otherImageXOffset, otherImageYOffset, this.sourceImagePath, this.t_currentTransformation, s.sourceImagePath, s.t_currentTransformation, intersectWidth, intersectHeight);
            }
            return true;
        }
        return false;
    }

    public final boolean collidesWith(EFTiledLayer t, boolean pixelLevel) {
        int endRow;
        if (!t.visible || !this.visible) {
            return false;
        }
        int tLx1 = t.x;
        int tLy1 = t.y;
        int tLx2 = tLx1 + t.width;
        int tLy2 = tLy1 + t.height;
        int tW = t.getCellWidth();
        int tH = t.getCellHeight();
        int sx1 = this.x + this.t_collisionRectX;
        int sy1 = this.y + this.t_collisionRectY;
        int sx2 = sx1 + this.t_collisionRectWidth;
        int sy2 = sy1 + this.t_collisionRectHeight;
        int tNumCols = t.getColumns();
        int tNumRows = t.getRows();
        if (!this.intersectRect(tLx1, tLy1, tLx2, tLy2, sx1, sy1, sx2, sy2)) {
            return false;
        }
        int startCol = sx1 <= tLx1 ? 0 : (sx1 - tLx1) / tW;
        int startRow = sy1 <= tLy1 ? 0 : (sy1 - tLy1) / tH;
        int endCol = sx2 < tLx2 ? (sx2 - 1 - tLx1) / tW : tNumCols - 1;
        int n = endRow = sy2 < tLy2 ? (sy2 - 1 - tLy1) / tH : tNumRows - 1;
        if (!pixelLevel) {
            for (int row = startRow; row <= endRow; ++row) {
                for (int col = startCol; col <= endCol; ++col) {
                    if (t.getCell(col, row) == 0) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.t_collisionRectX < 0) {
            sx1 = this.x;
        }
        if (this.t_collisionRectY < 0) {
            sy1 = this.y;
        }
        if (this.t_collisionRectX + this.t_collisionRectWidth > this.width) {
            sx2 = this.x + this.width;
        }
        if (this.t_collisionRectY + this.t_collisionRectHeight > this.height) {
            sy2 = this.y + this.height;
        }
        if (!this.intersectRect(tLx1, tLy1, tLx2, tLy2, sx1, sy1, sx2, sy2)) {
            return false;
        }
        startCol = sx1 <= tLx1 ? 0 : (sx1 - tLx1) / tW;
        startRow = sy1 <= tLy1 ? 0 : (sy1 - tLy1) / tH;
        endCol = sx2 < tLx2 ? (sx2 - 1 - tLx1) / tW : tNumCols - 1;
        endRow = sy2 < tLy2 ? (sy2 - 1 - tLy1) / tH : tNumRows - 1;
        int cellTop = startRow * tH + tLy1;
        int cellBottom = cellTop + tH;
        int row = startRow;
        while (row <= endRow) {
            int cellLeft = startCol * tW + tLx1;
            int cellRight = cellLeft + tW;
            int col = startCol;
            while (col <= endCol) {
                int tileIndex = t.getCell(col, row);
                if (tileIndex != 0) {
                    int image2YOffset;
                    int image2XOffset;
                    int image1YOffset;
                    int temp;
                    int intersectBottom;
                    int intersectLeft = sx1 < cellLeft ? cellLeft : sx1;
                    int intersectTop = sy1 < cellTop ? cellTop : sy1;
                    int intersectRight = sx2 < cellRight ? sx2 : cellRight;
                    int n2 = intersectBottom = sy2 < cellBottom ? sy2 : cellBottom;
                    if (intersectLeft > intersectRight) {
                        temp = intersectRight;
                        intersectRight = intersectLeft;
                        intersectLeft = temp;
                    }
                    if (intersectTop > intersectBottom) {
                        temp = intersectBottom;
                        intersectBottom = intersectTop;
                        intersectTop = temp;
                    }
                    int intersectWidth = intersectRight - intersectLeft;
                    int intersectHeight = intersectBottom - intersectTop;
                    int image1XOffset = this.getImageTopLeftX(intersectLeft, intersectTop, intersectRight, intersectBottom);
                    if (EFSprite.doPixelCollision(image1XOffset, image1YOffset = this.getImageTopLeftY(intersectLeft, intersectTop, intersectRight, intersectBottom), image2XOffset = t.tileSetX[tileIndex] + (intersectLeft - cellLeft), image2YOffset = t.tileSetY[tileIndex] + (intersectTop - cellTop), this.sourceImagePath, this.t_currentTransformation, t.sourceImagePath, 0, intersectWidth, intersectHeight)) {
                        return true;
                    }
                }
                ++col;
                cellLeft += tW;
                cellRight += tW;
            }
            ++row;
            cellTop += tH;
            cellBottom += tH;
        }
        return false;
    }

    private void initializeFrames(String imagePath, int fWidth, int fHeight, boolean maintainCurFrame) {
        int imageW = ImageHandler.getInstance().getImage(imagePath).getWidth();
        int imageH = ImageHandler.getInstance().getImage(imagePath).getHeight();
        int numHorizontalFrames = imageW / fWidth;
        int numVerticalFrames = imageH / fHeight;
        this.sourceImagePath = imagePath;
        this.srcFrameWidth = fWidth;
        this.srcFrameHeight = fHeight;
        this.numberFrames = numHorizontalFrames * numVerticalFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!maintainCurFrame) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int currentFrame = 0;
        for (int yy = 0; yy < imageH; yy += fHeight) {
            for (int xx = 0; xx < imageW; xx += fWidth) {
                this.frameCoordsX[currentFrame] = xx;
                this.frameCoordsY[currentFrame] = yy;
                if (!this.customSequenceDefined) {
                    this.frameSequence[currentFrame] = currentFrame;
                }
                ++currentFrame;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int r1x1, int r1y1, int r1x2, int r1y2, int r2x1, int r2y1, int r2x2, int r2y2) {
        return r2x1 < r1x2 && r2y1 < r1y2 && r2x2 > r1x1 && r2y2 > r1y1;
    }

    private static boolean doPixelCollision(int image1XOffset, int image1YOffset, int image2XOffset, int image2YOffset, String imagePath1, int transform1, String imagePath2, int transform2, int width, int height) {
        int yIncr2;
        int startY2;
        int xIncr2;
        int yIncr1;
        int startY1;
        int xIncr1;
        int numPixels = height * width;
        int[] argbData1 = new int[numPixels];
        int[] argbData2 = new int[numPixels];
        if (0 != (transform1 & 4)) {
            if (0 != (transform1 & 1)) {
                xIncr1 = -height;
                startY1 = numPixels - height;
            } else {
                xIncr1 = height;
                startY1 = 0;
            }
            if (0 != (transform1 & 2)) {
                yIncr1 = -1;
                startY1 += height - 1;
            } else {
                yIncr1 = 1;
            }
            ImageHandler.getInstance().getImage(imagePath1).getRGB(argbData1, 0, height, image1XOffset, image1YOffset, height, width);
        } else {
            if (0 != (transform1 & 1)) {
                startY1 = numPixels - width;
                yIncr1 = -width;
            } else {
                startY1 = 0;
                yIncr1 = width;
            }
            if (0 != (transform1 & 2)) {
                xIncr1 = -1;
                startY1 += width - 1;
            } else {
                xIncr1 = 1;
            }
            ImageHandler.getInstance().getImage(imagePath1).getRGB(argbData1, 0, width, image1XOffset, image1YOffset, width, height);
        }
        if (0 != (transform2 & 4)) {
            if (0 != (transform2 & 1)) {
                xIncr2 = -height;
                startY2 = numPixels - height;
            } else {
                xIncr2 = height;
                startY2 = 0;
            }
            if (0 != (transform2 & 2)) {
                yIncr2 = -1;
                startY2 += height - 1;
            } else {
                yIncr2 = 1;
            }
            ImageHandler.getInstance().getImage(imagePath2).getRGB(argbData2, 0, height, image2XOffset, image2YOffset, height, width);
        } else {
            if (0 != (transform2 & 1)) {
                startY2 = numPixels - width;
                yIncr2 = -width;
            } else {
                startY2 = 0;
                yIncr2 = width;
            }
            if (0 != (transform2 & 2)) {
                xIncr2 = -1;
                startY2 += width - 1;
            } else {
                xIncr2 = 1;
            }
            ImageHandler.getInstance().getImage(imagePath2).getRGB(argbData2, 0, width, image2XOffset, image2YOffset, width, height);
        }
        int xLocalBegin1 = startY1;
        int xLocalBegin2 = startY2;
        for (int numIterRows = 0; numIterRows < height; ++numIterRows) {
            int x1 = xLocalBegin1;
            int x2 = xLocalBegin2;
            for (int numIterColumns = 0; numIterColumns < width; ++numIterColumns) {
                if ((argbData1[x1] & 0xFF000000) != 0 && (argbData2[x2] & 0xFF000000) != 0) {
                    return true;
                }
                x1 += xIncr1;
                x2 += xIncr2;
            }
            xLocalBegin1 += yIncr1;
            xLocalBegin2 += yIncr2;
        }
        return false;
    }

    private int getImageTopLeftX(int x1, int y1, int x2, int y2) {
        int retX = 0;
        switch (this.t_currentTransformation) {
            case 0: 
            case 1: {
                retX = x1 - this.x;
                break;
            }
            case 2: 
            case 3: {
                retX = this.x + this.width - x2;
                break;
            }
            case 4: 
            case 5: {
                retX = y1 - this.y;
                break;
            }
            case 6: 
            case 7: {
                retX = this.y + this.height - y2;
            }
        }
        return retX += this.frameCoordsX[this.frameSequence[this.sequenceIndex]];
    }

    private int getImageTopLeftY(int x1, int y1, int x2, int y2) {
        int retY = 0;
        switch (this.t_currentTransformation) {
            case 0: 
            case 2: {
                retY = y1 - this.y;
                break;
            }
            case 1: 
            case 3: {
                retY = this.y + this.height - y2;
                break;
            }
            case 4: 
            case 6: {
                retY = x1 - this.x;
                break;
            }
            case 5: 
            case 7: {
                retY = this.x + this.width - x2;
            }
        }
        return retY += this.frameCoordsY[this.frameSequence[this.sequenceIndex]];
    }

    public void defineCollisionRectangle(int inp_x, int inp_y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = inp_x;
        this.collisionRectY = inp_y;
        this.collisionRectWidth = width;
        this.collisionRectHeight = height;
        this.setTransformImpl(this.t_currentTransformation);
    }

    public void setTransform(int transform) {
        this.setTransformImpl(transform);
    }

    private void setTransformImpl(int transform) {
        this.x = this.x + this.getTransformedPtX(this.dRefX, this.dRefY, this.t_currentTransformation) - this.getTransformedPtX(this.dRefX, this.dRefY, transform);
        this.y = this.y + this.getTransformedPtY(this.dRefX, this.dRefY, this.t_currentTransformation) - this.getTransformedPtY(this.dRefX, this.dRefY, transform);
        this.computeTransformedBounds(transform);
        this.t_currentTransformation = transform;
    }

    private void computeTransformedBounds(int transform) {
        switch (transform) {
            case 0: {
                this.t_collisionRectX = this.collisionRectX;
                this.t_collisionRectY = this.collisionRectY;
                this.t_collisionRectWidth = this.collisionRectWidth;
                this.t_collisionRectHeight = this.collisionRectHeight;
                this.width = this.srcFrameWidth;
                this.height = this.srcFrameHeight;
                break;
            }
            case 2: {
                this.t_collisionRectX = this.srcFrameWidth - (this.collisionRectX + this.collisionRectWidth);
                this.t_collisionRectY = this.collisionRectY;
                this.t_collisionRectWidth = this.collisionRectWidth;
                this.t_collisionRectHeight = this.collisionRectHeight;
                this.width = this.srcFrameWidth;
                this.height = this.srcFrameHeight;
                break;
            }
            case 1: {
                this.t_collisionRectY = this.srcFrameHeight - (this.collisionRectY + this.collisionRectHeight);
                this.t_collisionRectX = this.collisionRectX;
                this.t_collisionRectWidth = this.collisionRectWidth;
                this.t_collisionRectHeight = this.collisionRectHeight;
                this.width = this.srcFrameWidth;
                this.height = this.srcFrameHeight;
                break;
            }
            case 5: {
                this.t_collisionRectX = this.srcFrameHeight - (this.collisionRectHeight + this.collisionRectY);
                this.t_collisionRectY = this.collisionRectX;
                this.t_collisionRectHeight = this.collisionRectWidth;
                this.t_collisionRectWidth = this.collisionRectHeight;
                this.width = this.srcFrameHeight;
                this.height = this.srcFrameWidth;
                break;
            }
            case 3: {
                this.t_collisionRectX = this.srcFrameWidth - (this.collisionRectWidth + this.collisionRectX);
                this.t_collisionRectY = this.srcFrameHeight - (this.collisionRectHeight + this.collisionRectY);
                this.t_collisionRectWidth = this.collisionRectWidth;
                this.t_collisionRectHeight = this.collisionRectHeight;
                this.width = this.srcFrameWidth;
                this.height = this.srcFrameHeight;
                break;
            }
            case 6: {
                this.t_collisionRectX = this.collisionRectY;
                this.t_collisionRectY = this.srcFrameWidth - (this.collisionRectWidth + this.collisionRectX);
                this.t_collisionRectHeight = this.collisionRectWidth;
                this.t_collisionRectWidth = this.collisionRectHeight;
                this.width = this.srcFrameHeight;
                this.height = this.srcFrameWidth;
                break;
            }
            case 7: {
                this.t_collisionRectX = this.srcFrameHeight - (this.collisionRectHeight + this.collisionRectY);
                this.t_collisionRectY = this.srcFrameWidth - (this.collisionRectWidth + this.collisionRectX);
                this.t_collisionRectHeight = this.collisionRectWidth;
                this.t_collisionRectWidth = this.collisionRectHeight;
                this.width = this.srcFrameHeight;
                this.height = this.srcFrameWidth;
                break;
            }
            case 4: {
                this.t_collisionRectY = this.collisionRectX;
                this.t_collisionRectX = this.collisionRectY;
                this.t_collisionRectHeight = this.collisionRectWidth;
                this.t_collisionRectWidth = this.collisionRectHeight;
                this.width = this.srcFrameHeight;
                this.height = this.srcFrameWidth;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    int getTransformedPtX(int x, int y, int transform) {
        int t_x = 0;
        switch (transform) {
            case 0: {
                t_x = x;
                break;
            }
            case 2: {
                t_x = this.srcFrameWidth - x - 1;
                break;
            }
            case 1: {
                t_x = x;
                break;
            }
            case 5: {
                t_x = this.srcFrameHeight - y - 1;
                break;
            }
            case 3: {
                t_x = this.srcFrameWidth - x - 1;
                break;
            }
            case 6: {
                t_x = y;
                break;
            }
            case 7: {
                t_x = this.srcFrameHeight - y - 1;
                break;
            }
            case 4: {
                t_x = y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return t_x;
    }

    int getTransformedPtY(int x, int y, int transform) {
        int t_y = 0;
        switch (transform) {
            case 0: {
                t_y = y;
                break;
            }
            case 2: {
                t_y = y;
                break;
            }
            case 1: {
                t_y = this.srcFrameHeight - y - 1;
                break;
            }
            case 5: {
                t_y = x;
                break;
            }
            case 3: {
                t_y = this.srcFrameHeight - y - 1;
                break;
            }
            case 6: {
                t_y = this.srcFrameWidth - x - 1;
                break;
            }
            case 7: {
                t_y = this.srcFrameWidth - x - 1;
                break;
            }
            case 4: {
                t_y = x;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return t_y;
    }
}

