/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.input.KeyCodeAdapter;
import com.jarbull.efw.manager.EGameCanvas;
import com.jarbull.efw.manager.GameXmlReader;
import com.jarbull.efw.manager.InternalCanvas;
import com.jarbull.efw.manager.InternalProcessor;
import com.jarbull.efw.manager.Properties;
import com.jarbull.efw.manager.Settings;
import com.jarbull.efw.ui.ScreenHolder;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import org.xmlpull.v1.XmlPullParserException;

public abstract class EMidlet
extends MIDlet {
    private static EMidlet instance;
    InternalCanvas canvas;
    InternalProcessor processor;
    EGameCanvas userCanvas;
    Settings settings;
    Properties properties;
    int gameId;
    String gameRecName;
    String efwVersion;
    String gameVersion;
    int demoDuration;

    public final void startApp() {
        instance = this;
        this.properties = new Properties(this);
        GameXmlReader reader = new GameXmlReader(this);
        try {
            reader.readConfigXml(this);
            this.gameRecName = "JB" + this.gameId;
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            System.out.println("******CONFIG.XML FILE NOT FOUND UNDER \"/res\" DIRECTORY******");
            ex.printStackTrace();
        }
        this.canvas = new InternalCanvas(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        new Thread(this.canvas).start();
        KeyCodeAdapter.getInstance().setCanvas(this.canvas);
        try {
            reader.readMenuXml();
            reader.readGameXml(this);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final void pauseApp() {
        this.settings.save();
        this.processor.setPaused(true);
        this.canvas.setPaused(true);
        this.pause();
    }

    public final void destroyApp(boolean unconditional) {
        this.destroyGame();
    }

    public static EMidlet getInstance() {
        return instance;
    }

    public String getGameRecName() {
        return this.gameRecName;
    }

    public void pauseGame(boolean paused) {
        ScreenHolder.getInstance().setActiveScreenId("pausemenuscreen");
        this.processor.setPaused(paused);
    }

    public final boolean isGamePaused() {
        if (this.processor != null) {
            return this.processor.isPaused();
        }
        return true;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public EGameCanvas getUserCanvas() {
        return this.userCanvas;
    }

    public void setUserCanvas(EGameCanvas userCanvas) {
        this.userCanvas = userCanvas;
    }

    void destroyGame() {
        if (this.processor != null) {
            this.processor.setPaused(true);
            this.processor.kill();
            this.destroy();
            this.settings.save();
        }
        this.processor = null;
    }

    public abstract void start();

    public abstract void pause();

    public abstract void resume();

    public abstract void destroy();
}

