/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.util;

import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.Matrix2x2;
import com.jarbull.platform.util.Tile;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TileLayer {
    DynamicWorld world;
    boolean wireframe;
    byte[][] tiles;
    final Image image;
    final int columns;
    final int rows;
    final int tileSize;
    Tile[] tileTypes;
    int[] paintArea;
    final int width;
    final int height;

    public TileLayer(DynamicWorld world, Image image, int columns, int rows, int tileSize) {
        this.world = world;
        this.image = image;
        this.columns = columns;
        this.rows = rows;
        this.tileSize = tileSize;
        this.width = columns * tileSize;
        this.height = rows * tileSize;
        this.setWireframe(true);
        this.paintArea = new int[4];
        this.tiles = new byte[columns][rows];
        this.tileTypes = new Tile[image.getWidth() / tileSize];
        for (int i = 0; i < this.tileTypes.length; ++i) {
            this.tileTypes[i] = new Tile(tileSize);
        }
    }

    public void initialize() {
        boolean[][] validEdges = new boolean[this.tileTypes.length][4];
        boolean[] useAxis = new boolean[this.tileTypes.length];
        for (int i = 0; i < this.tileTypes.length; ++i) {
            try {
                this.tileTypes[i].initBody(this.world, this.tileTypes[i].getCollisionProxy(), 0, 0);
            }
            catch (PhysicsException ex) {
                ex.printStackTrace();
            }
            validEdges[i] = this.tileTypes[i].getValidEdges();
            useAxis[i] = this.tileTypes[i].isUseAxis();
        }
        try {
            this.world.setTiles(this.tileSize << 10, this.tiles, this.tileTypes, validEdges, useAxis);
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        for (int c = 0; c < this.tiles.length; ++c) {
            for (int r = 0; r < this.tiles[0].length; ++r) {
                if (this.tiles[c][r] == -1 || this.paintArea[0] >= (c + 1) * this.tileSize || this.paintArea[1] >= (r + 1) * this.tileSize || this.paintArea[0] + this.paintArea[2] <= c * this.tileSize || this.paintArea[1] + this.paintArea[3] <= r * this.tileSize) continue;
                if (this.wireframe) {
                    g.setColor(0xFF0000);
                    this.tileTypes[this.tiles[c][r]].getCollisionProxy().draw(g, c * this.tileSize + this.tileSize / 2, r * this.tileSize + this.tileSize / 2, Matrix2x2.IDENTITY);
                    continue;
                }
                g.drawRegion(this.image, this.tiles[c][r] * this.tileSize, 0, this.tileSize, this.tileSize, 0, c * this.tileSize, r * this.tileSize, 0);
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public Tile getTileType(int index) {
        return this.tileTypes[index];
    }

    public void setTileType(int index, Tile tile) {
        this.tileTypes[index] = tile;
    }

    public byte getTileValue(int column, int row) {
        return this.tiles[column][row];
    }

    public void setTileValue(int column, int row, byte value) {
        this.tiles[column][row] = value;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public void setWireframe(boolean wireframe) {
        this.wireframe = wireframe;
    }

    public void setPaintAreaX(int x) {
        this.paintArea[0] = x;
    }

    public void setPaintAreaY(int y) {
        this.paintArea[1] = y;
    }

    public void setPaintAreaWidth(int width) {
        this.paintArea[2] = width;
    }

    public void setPaintAreaHeight(int height) {
        this.paintArea[3] = height;
    }
}

