/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;
import javax.microedition.lcdui.Graphics;

public class Joint {
    public PhysicalObject obj1;
    public PhysicalObject obj2;
    private Vector2 localAnchor1;
    private Vector2 localAnchor2;
    private static final byte LIMITSTATE_DISABLED = 0;
    private static final byte LIMITSTATE_INACTIVE = 1;
    private static final byte LIMITSTATE_LOWER = 2;
    private static final byte LIMITSTATE_UPPER = 3;
    private byte limitState = 0;
    private int limitLowerAngle = 0;
    private int limitUpperAngle = 0;
    private static Vector2 tmpVector = new Vector2();
    private static Vector2 absoluteAnchor1 = new Vector2();
    private static Vector2 absoluteAnchor2 = new Vector2();
    private static Vector2 r1 = new Vector2();
    private static Vector2 r2 = new Vector2();
    private static Matrix2x2 K = new Matrix2x2();
    private static Vector2 bias = new Vector2();
    private static Vector2 impulse = new Vector2();

    public Joint(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 pAnchor) {
        this.obj1 = pObj1;
        this.obj2 = pObj2;
        this.localAnchor1 = pAnchor.minus(this.obj1.getPosition()).timesTransposedWithShift(this.obj1.getOrientation());
        this.localAnchor2 = pAnchor.minus(this.obj2.getPosition()).timesTransposedWithShift(this.obj2.getOrientation());
    }

    public Joint(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 pAnchor1, Vector2 pAnchor2) {
        this.obj1 = pObj1;
        this.obj2 = pObj2;
        this.localAnchor1 = new Vector2(pAnchor1);
        this.localAnchor2 = new Vector2(pAnchor2);
    }

    public Joint(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 pAnchor1, Vector2 pAnchor2, int pLimitLowerAngle, int pLimitUpperAngle) {
        this.obj1 = pObj1;
        this.obj2 = pObj2;
        this.localAnchor1 = new Vector2(pAnchor1);
        this.localAnchor2 = new Vector2(pAnchor2);
        this.limitState = 1;
        this.limitLowerAngle = pLimitLowerAngle;
        this.limitUpperAngle = pLimitUpperAngle;
    }

    public void enableLimit() {
        if (this.limitState == 0) {
            this.limitState = 1;
        }
    }

    public Vector2 getAbsoluteAnchor1() {
        absoluteAnchor1.copy(this.localAnchor1);
        absoluteAnchor1.multiplyWithShift(this.obj1.getOrientation());
        absoluteAnchor1.add(this.obj1.getPosition());
        return absoluteAnchor1;
    }

    public Vector2 getAbsoluteAnchor2() {
        absoluteAnchor2.copy(this.localAnchor2);
        absoluteAnchor2.multiplyWithShift(this.obj2.getOrientation());
        absoluteAnchor2.add(this.obj2.getPosition());
        return absoluteAnchor2;
    }

    public Vector2 getLocalAnchor1() {
        return this.localAnchor1;
    }

    public Vector2 getLocalAnchor2() {
        return this.localAnchor2;
    }

    public void disableLimit() {
        this.limitState = 0;
    }

    public void setLimitLowerAngle(int pAngle) {
        this.limitLowerAngle = pAngle;
    }

    public void setLimitUpperAngle(int pAngle) {
        this.limitUpperAngle = pAngle;
    }

    public int getLimitLowerAngle() {
        return this.limitLowerAngle;
    }

    public int getLimitUpperAngle() {
        return this.limitUpperAngle;
    }

    public void _applyImpulse() {
        int tmp;
        int inv_m1_shifted2 = this.obj1.getInvMass_shifted2();
        int inv_m2_shifted2 = this.obj2.getInvMass_shifted2();
        int inv_i1_shifted2 = this.obj1.getInvInertia_shifted2();
        int inv_i2_shifted2 = this.obj2.getInvInertia_shifted2();
        r1.copy(this.localAnchor1);
        r1.multiplyWithShift(this.obj1.getOrientation());
        r2.copy(this.localAnchor2);
        r2.multiplyWithShift(this.obj2.getOrientation());
        Joint.K.data[0][0] = tmp = inv_m1_shifted2 + inv_m2_shifted2 >> 10;
        Joint.K.data[0][1] = 0;
        Joint.K.data[1][0] = 0;
        Joint.K.data[1][1] = tmp;
        int[] nArray = Joint.K.data[0];
        nArray[0] = nArray[0] + (int)(((long)inv_i1_shifted2 * (long)Joint.r1.y >> 20) * (long)Joint.r1.y >> 10);
        tmp = -((int)(((long)inv_i1_shifted2 * (long)Joint.r1.x >> 20) * (long)Joint.r1.y >> 10));
        int[] nArray2 = Joint.K.data[0];
        nArray2[1] = nArray2[1] + tmp;
        int[] nArray3 = Joint.K.data[1];
        nArray3[0] = nArray3[0] + tmp;
        int[] nArray4 = Joint.K.data[1];
        nArray4[1] = nArray4[1] + (int)(((long)inv_i1_shifted2 * (long)Joint.r1.x >> 20) * (long)Joint.r1.x >> 10);
        int[] nArray5 = Joint.K.data[0];
        nArray5[0] = nArray5[0] + (int)(((long)inv_i2_shifted2 * (long)Joint.r2.y >> 20) * (long)Joint.r2.y >> 10);
        tmp = -((int)(((long)inv_i2_shifted2 * (long)Joint.r2.x >> 20) * (long)Joint.r2.y >> 10));
        int[] nArray6 = Joint.K.data[0];
        nArray6[1] = nArray6[1] + tmp;
        int[] nArray7 = Joint.K.data[1];
        nArray7[0] = nArray7[0] + tmp;
        int[] nArray8 = Joint.K.data[1];
        nArray8[1] = nArray8[1] + (int)(((long)inv_i2_shifted2 * (long)Joint.r2.x >> 20) * (long)Joint.r2.x >> 10);
        K.invert();
        bias.copy(this.obj1.getPosition());
        bias.add(r1);
        bias.subtract(this.obj2.getPosition());
        bias.subtract(r2);
        bias.multiplyWithShift(102);
        impulse.copyPerpendicular(r2);
        impulse.multiplyWithShift(this.obj2.getAngularVelocity_shifted(), 2);
        tmpVector.copyPerpendicular(r1);
        tmpVector.multiplyWithShift(this.obj1.getAngularVelocity_shifted(), 2);
        impulse.subtract(tmpVector);
        impulse.add(this.obj2.getLinearVelocity());
        impulse.subtract(this.obj1.getLinearVelocity());
        impulse.subtract(bias);
        Joint.impulse.x = -Joint.impulse.x;
        Joint.impulse.y = -Joint.impulse.y;
        impulse.multiplyWithShift(K);
        if (inv_m1_shifted2 > 0) {
            DynamicObject dobj1 = (DynamicObject)this.obj1;
            tmpVector.copy(impulse);
            tmpVector.multiplyWithShift(inv_m1_shifted2, 3);
            dobj1.getLinearVelocity().subtract(tmpVector);
            if (inv_i1_shifted2 > 0) {
                dobj1.setAngularVelocity_shifted(dobj1.getAngularVelocity_shifted() - (int)((long)r1.crossProductWithShift(impulse) * (long)inv_i1_shifted2 >> 20));
            }
            if (dobj1.isAsleep()) {
                dobj1.wakeUp();
            }
        }
        if (inv_m2_shifted2 > 0) {
            DynamicObject dobj2 = (DynamicObject)this.obj2;
            tmpVector.copy(impulse);
            tmpVector.multiplyWithShift(inv_m2_shifted2, 3);
            dobj2.getLinearVelocity().add(tmpVector);
            if (inv_i2_shifted2 > 0) {
                dobj2.setAngularVelocity_shifted(dobj2.getAngularVelocity_shifted() + (int)((long)r2.crossProductWithShift(impulse) * (long)inv_i2_shifted2 >> 20));
            }
            if (dobj2.isAsleep()) {
                dobj2.wakeUp();
            }
        }
        if (this.limitState != 0) {
            int jointAngle = MathUtils.angleDistance(this.obj1.getAngle_shifted(), this.obj2.getAngle_shifted());
            this.limitState = jointAngle <= this.limitLowerAngle ? (byte)2 : (jointAngle >= this.limitUpperAngle ? (byte)3 : (byte)1);
            if (this.limitState != 1) {
                int force = (int)(-((long)(this.obj2.getAngularVelocity_shifted() - this.obj1.getAngularVelocity_shifted()) << 20) / (long)(inv_i1_shifted2 + inv_i2_shifted2));
                if (this.limitState == 2 && force < 0) {
                    force = 0;
                } else if (this.limitState == 3 && force > 0) {
                    force = 0;
                }
                if (inv_i1_shifted2 > 0) {
                    ((DynamicObject)this.obj1).setAngularVelocity_shifted(this.obj1.getAngularVelocity_shifted() - (int)((long)force * (long)inv_i1_shifted2 >> 20));
                }
                if (inv_i2_shifted2 > 0) {
                    ((DynamicObject)this.obj2).setAngularVelocity_shifted(this.obj2.getAngularVelocity_shifted() + (int)((long)force * (long)inv_i2_shifted2 >> 20));
                }
            }
        }
    }

    public void draw(Graphics pGraph, Vector2 pCoordSystemPosition) {
        r1.copy(this.getAbsoluteAnchor1());
        r1.shiftRight();
        r1.add(pCoordSystemPosition);
        r2.copy(this.getAbsoluteAnchor2());
        r2.shiftRight();
        r2.add(pCoordSystemPosition);
        pGraph.drawLine(Joint.r1.x, Joint.r1.y, Joint.r2.x, Joint.r2.y);
    }
}

