/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.domain;

import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.platform.domain.Antenna;
import com.jarbull.platform.domain.Bee;
import com.jarbull.platform.domain.Bird;
import com.jarbull.platform.domain.Bonus;
import com.jarbull.platform.domain.Butterfly;
import com.jarbull.platform.domain.Caterpillar;
import com.jarbull.platform.domain.Crab;
import com.jarbull.platform.domain.PhysicObject;
import com.jarbull.platform.domain.PhysicsObjList;
import com.jarbull.platform.domain.Rat;
import com.jarbull.platform.domain.Smoke;
import com.jarbull.platform.main.BoombaCanvas;
import javax.microedition.lcdui.Graphics;

public class PhyObjManager {
    private static final PhyObjManager instance = new PhyObjManager();
    private PhysicsObjList PhysicList = new PhysicsObjList();
    private int currId = 0;

    public static PhyObjManager getInstance() {
        return instance;
    }

    public void moveInStartPos(int dx) {
        if (this.PhysicList != null) {
            for (int i = this.PhysicList.size() - 1; i >= 0; --i) {
                PhysicalObject phyObj = (PhysicalObject)((Object)this.PhysicList.elementAt(i));
                phyObj._setPosition(new Vector2(phyObj.getPosition_shiftedRight().x - dx, phyObj.getPosition_shiftedRight().y).shiftLeft());
            }
        }
    }

    public void draw(Graphics g) {
        int tickSize = this.PhysicList.size();
        if (!this.PhysicList.isEmpty()) {
            for (int i = this.PhysicList.size() - 1; i >= 0 && tickSize == this.PhysicList.size(); --i) {
                this.PhysicList.elementAt(i).draw(g);
            }
        }
    }

    public void tick() {
        int tickSize = this.PhysicList.size();
        if (!this.PhysicList.isEmpty()) {
            for (int i = this.PhysicList.size() - 1; i >= 0 && tickSize == this.PhysicList.size(); --i) {
                this.PhysicList.elementAt(i).tick();
                this.checkRemovePhyObj((PhysicalObject)((Object)this.PhysicList.elementAt(i)));
            }
        }
    }

    public void createPhyObjects(byte[][] arrMap, int startColumn, DynamicWorld world) {
        for (int i = 0; i < arrMap.length; ++i) {
            for (int j = 0; j < arrMap[i].length; ++j) {
                if (j <= startColumn) continue;
                if (arrMap[i][j] == 92) {
                    ++this.currId;
                    this.createObstacle(world, j * 16, i * 16, this.currId, 0);
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 93) {
                    ++this.currId;
                    this.PhysicList.addElement(new Bonus(world, j * 16, i * 16, this.currId));
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 94) {
                    ++this.currId;
                    switch (MathUtils.random(0, 1)) {
                        case 0: {
                            this.PhysicList.addElement(new Bonus(world, j * 16, i * 16, this.currId));
                            break;
                        }
                        case 1: {
                            this.createObstacle(world, j * 16, i * 16, this.currId, 0);
                        }
                    }
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 95) {
                    ++this.currId;
                    if (MathUtils.random(0, 1) == 1) {
                        this.createObstacle(world, j * 16, i * 16, this.currId, 0);
                    }
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 96) {
                    ++this.currId;
                    if (MathUtils.random(0, 1) == 1) {
                        this.PhysicList.addElement(new Bonus(world, j * 16, i * 16, this.currId));
                    }
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 97) {
                    ++this.currId;
                    this.createObstacle(world, j * 16, i * 16, this.currId, 1);
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] == 98) {
                    ++this.currId;
                    switch (MathUtils.random(0, 1)) {
                        case 0: {
                            this.PhysicList.addElement(new Bonus(world, j * 16, i * 16, this.currId));
                            break;
                        }
                        case 1: {
                            this.createObstacle(world, j * 16, i * 16, this.currId, 1);
                        }
                    }
                    arrMap[i][j] = 0;
                }
                if (arrMap[i][j] != 99) continue;
                ++this.currId;
                if (MathUtils.random(0, 1) == 1) {
                    this.createObstacle(world, j * 16, i * 16, this.currId, 1);
                }
                arrMap[i][j] = 0;
            }
        }
    }

    private void createObstacle(DynamicWorld world, int x, int y, int id, int type) {
        System.out.println("LevelHolder.getInstance().getCurrentLevel() = " + LevelHolder.getInstance().getCurrentLevel());
        switch (type) {
            case 0: {
                if (LevelHolder.getInstance().getCurrentLevel() < 4) {
                    System.out.println("CREATED BIRD");
                    this.PhysicList.addElement(new Bird(world, x, y, id));
                    break;
                }
                if (LevelHolder.getInstance().getCurrentLevel() < 6) {
                    System.out.println("CREATED CATERPILLAR");
                    this.PhysicList.addElement(new Caterpillar(world, x, y, id));
                    break;
                }
                if (LevelHolder.getInstance().getCurrentLevel() < 8) {
                    System.out.println("CREATED SMOKE");
                    this.PhysicList.addElement(new Smoke(world, x, y, id));
                    break;
                }
                System.out.println("CREATED BUTTERFLY");
                this.PhysicList.addElement(new Crab(world, x, y, id));
                break;
            }
            case 1: {
                if (LevelHolder.getInstance().getCurrentLevel() < 4) {
                    this.PhysicList.addElement(new Antenna(world, x, y, id));
                    System.out.println("CREATED ANTENNA");
                    break;
                }
                if (LevelHolder.getInstance().getCurrentLevel() < 6) {
                    this.PhysicList.addElement(new Bee(world, x, y, id));
                    System.out.println("CREATED BEE");
                    break;
                }
                if (LevelHolder.getInstance().getCurrentLevel() < 8) {
                    this.PhysicList.addElement(new Rat(world, x, y, id));
                    break;
                }
                this.PhysicList.addElement(new Butterfly(world, x, y, id));
            }
        }
    }

    private void checkRemovePhyObj(PhysicalObject pObj) {
        if (pObj.getPosition_shiftedRight().x + 32 < BoombaCanvas.distance) {
            try {
                pObj.despawnBody();
            }
            catch (PhysicsException ex) {
                ex.printStackTrace();
            }
            this.PhysicList.removeElement((PhysicObject)((Object)pObj));
        }
        if (((PhysicObject)((Object)pObj)).isDespawn()) {
            try {
                pObj.despawnBody();
            }
            catch (PhysicsException ex) {
                ex.printStackTrace();
            }
            this.PhysicList.removeElement((PhysicObject)((Object)pObj));
        }
    }

    public PhysicsObjList getPhysicList() {
        return this.PhysicList;
    }
}

