/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.screens;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFLayerManager;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Label;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.main.GameStateController;
import javax.microedition.lcdui.Graphics;

public class ScreenLevelSelection {
    final int LOCATIONS_COUNT;
    final int KEY_DOWN_STATE;
    final int KEY_UP_STATE;
    final int LABEL_DESC_MARGIN;
    String sLevelName;
    String score;
    int iOpenLocationCnt;
    int iPressedLeftTime;
    int iCurrLocation = 0;
    boolean bLButtonAnimFlag = false;
    boolean bRButtonAnimFlag = false;
    private static int state;
    EFLiteSprite sprEFBtnLeft;
    EFLiteSprite sprEFBtnRight;
    EFLiteSprite sprEFLocation;
    EFLiteSprite sprEFLocationCloses;
    EFLiteSprite sprEFBoard;
    EFLiteSprite sprEFBg;
    EFLayerManager lmEF;
    Label lblDesc;

    public ScreenLevelSelection() {
        this.LOCATIONS_COUNT = 4;
        this.KEY_DOWN_STATE = 1;
        this.KEY_UP_STATE = 2;
        this.LABEL_DESC_MARGIN = -3;
        System.out.println("lvlSel DataManager.getInstance() = " + DataManager.getInstance());
        this.iOpenLocationCnt = DataManager.getInstance().getLocationCnt();
        state = 2;
        this.lmEF = new EFLayerManager();
        this.sprEFBoard = new EFLiteSprite("/res/framework/images/levelSelectScreen/board.png");
        this.sprEFBoard.setPosition(ResolutionHandler.getInstance().getCurrentWidth() / 2 - this.sprEFBoard.getWidth() / 2, ResolutionHandler.getInstance().getCurrentHeight() / 2 - this.sprEFBoard.getHeight() / 2);
        this.sprEFBtnLeft = new EFLiteSprite("/res/framework/images/levelSelectScreen/btnLeft.png", ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/btnLeft.png").getWidth() / 4, ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/btnLeft.png").getHeight());
        this.sprEFBtnLeft.setFrameSequence(new int[]{0, 0, 1, 1, 2, 2, 3, 3});
        this.sprEFBtnLeft.setPosition(this.sprEFBoard.getX() - this.sprEFBtnLeft.getWidth(), this.sprEFBoard.getY() + this.sprEFBoard.getHeight() / 2 - this.sprEFBtnLeft.getHeight() / 2);
        this.sprEFBtnRight = new EFLiteSprite("/res/framework/images/levelSelectScreen/btnRight.png", ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/btnRight.png").getWidth() / 4, ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/btnRight.png").getHeight());
        this.sprEFBtnRight.setFrameSequence(new int[]{0, 0, 1, 1, 2, 2, 3, 3});
        this.sprEFBtnRight.setPosition(this.sprEFBoard.getX() + this.sprEFBoard.getWidth(), this.sprEFBoard.getY() + this.sprEFBoard.getHeight() / 2 - this.sprEFBtnLeft.getHeight() / 2);
        this.sprEFLocation = new EFLiteSprite("/res/framework/images/levelSelectScreen/location1.png");
        this.sprEFLocation.setPosition(this.sprEFBoard.getX() + this.sprEFBoard.getWidth() / 2 - this.sprEFLocation.getWidth() / 2, this.sprEFBoard.getY() + this.sprEFBoard.getHeight() / 2 - this.sprEFLocation.getHeight());
        this.sprEFLocationCloses = new EFLiteSprite("/res/framework/images/levelSelectScreen/locationCloses.png");
        this.sprEFLocationCloses.setPosition(this.sprEFBoard.getX() + this.sprEFBoard.getWidth() / 2 - this.sprEFLocationCloses.getWidth() / 2, this.sprEFBoard.getY() + this.sprEFBoard.getHeight() / 2 - this.sprEFLocationCloses.getHeight() - 3);
        this.sprEFBg = new EFLiteSprite("/res/framework/images/page.png");
        this.lmEF.append(this.sprEFBtnLeft);
        this.lmEF.append(this.sprEFBtnRight);
        this.lmEF.append(this.sprEFLocationCloses);
        this.lmEF.append(this.sprEFLocation);
        this.lmEF.append(this.sprEFBoard);
        this.lmEF.append(this.sprEFBg);
        this.descTextInit();
        GameStateController.getInstance().setState((byte)1);
        this.checkComponentsStates();
    }

    private void descTextInit() {
        this.lblDesc = new Label("1", "task");
        this.lblDesc.setText("description", true);
        this.lblDesc.setMarginBetweenLines(-3);
        this.lblDesc.setBgColor(-1);
        this.lblDesc.setFgColor(-1);
        this.lblDesc.setBorderSize(0);
        this.lblDesc.setPosition(this.sprEFBoard.getX() + 10, ResolutionHandler.getInstance().getCurrentHeight() / 2);
        this.lblDesc.setSize(this.sprEFBoard.getWidth() - 20, this.sprEFBoard.getHeight() / 2);
        this.lblDesc.setAlignment(1);
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 206: 
            case 224: {
                this.iCurrLocation = this.iCurrLocation < 3 ? this.iCurrLocation + 1 : 0;
                this.checkComponentsStates();
                this.bRButtonAnimFlag = true;
                break;
            }
            case 204: 
            case 223: {
                this.iCurrLocation = this.iCurrLocation > 0 ? this.iCurrLocation - 1 : 3;
                this.checkComponentsStates();
                this.bLButtonAnimFlag = true;
                break;
            }
            case -203: 
            case 205: 
            case 225: {
                this.startGame(this.iCurrLocation);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.iPressedLeftTime > 0) {
            return;
        }
        this.iPressedLeftTime = 5;
        if (x > this.sprEFBtnLeft.getX() && x < this.sprEFBtnLeft.getX() + this.sprEFBtnLeft.getWidth() && y > this.sprEFBtnLeft.getY() && y < this.sprEFBtnLeft.getY() + this.sprEFBtnLeft.getHeight()) {
            this.iCurrLocation = this.iCurrLocation > 0 ? this.iCurrLocation - 1 : 3;
            this.bLButtonAnimFlag = true;
        }
        if (x > this.sprEFBtnRight.getX() && x < this.sprEFBtnRight.getX() + this.sprEFBtnRight.getWidth() && y > this.sprEFBtnRight.getY() && y < this.sprEFBtnRight.getY() + this.sprEFBtnRight.getHeight()) {
            this.iCurrLocation = this.iCurrLocation < 3 ? this.iCurrLocation + 1 : 0;
            this.bRButtonAnimFlag = true;
        }
        this.checkComponentsStates();
        if (x > this.sprEFLocation.getX() && x < this.sprEFLocation.getX() + this.sprEFLocation.getWidth() && y > this.sprEFLocation.getY() && y < this.sprEFLocation.getY() + this.sprEFLocation.getHeight() && this.iCurrLocation < this.iOpenLocationCnt) {
            this.startGame(this.iCurrLocation);
        }
    }

    private void checkComponentsStates() {
        System.out.println("iCurrLocation = " + this.iCurrLocation);
        System.out.println("iOpenLocationCnt = " + this.iOpenLocationCnt);
        switch (this.iCurrLocation) {
            case 0: {
                this.sprEFLocation.setImage("/res/framework/images/levelSelectScreen/location1.png", this.sprEFLocation.getWidth(), this.sprEFLocation.getHeight());
                this.score = LocalizationSupport.getMessage("bestresult") + LevelHolder.getInstance().getLevel(3).getBestScore();
                this.sLevelName = LocalizationSupport.getMessage("locationRoofs");
                this.lblDesc.setText("descForLocRoofs", true);
                break;
            }
            case 1: {
                this.sprEFLocation.setImage("/res/framework/images/levelSelectScreen/location2.png", this.sprEFLocation.getWidth(), this.sprEFLocation.getHeight());
                this.sLevelName = LocalizationSupport.getMessage("locationTrees");
                this.score = LocalizationSupport.getMessage("bestresult") + LevelHolder.getInstance().getLevel(5).getBestScore();
                this.lblDesc.setText("descForLocTrees", true);
                break;
            }
            case 2: {
                this.sprEFLocation.setImage("/res/framework/images/levelSelectScreen/location3.png", this.sprEFLocation.getWidth(), this.sprEFLocation.getHeight());
                this.score = LocalizationSupport.getMessage("bestresult") + LevelHolder.getInstance().getLevel(7).getBestScore();
                this.sLevelName = LocalizationSupport.getMessage("locationCanalization");
                this.lblDesc.setText("descForLocCanalization", true);
                break;
            }
            case 3: {
                this.sprEFLocation.setImage("/res/framework/images/levelSelectScreen/location4.png", this.sprEFLocation.getWidth(), this.sprEFLocation.getHeight());
                this.score = LocalizationSupport.getMessage("bestresult") + LevelHolder.getInstance().getLevel(9).getBestScore();
                this.sLevelName = LocalizationSupport.getMessage("locationStreet");
                this.lblDesc.setText("descForLocStreet", true);
            }
        }
        if (this.iCurrLocation < this.iOpenLocationCnt) {
            this.sprEFLocationCloses.setVisible(false);
        } else {
            this.sprEFLocationCloses.setVisible(true);
        }
    }

    private void startGame(int levelNo) {
        if (levelNo < this.iOpenLocationCnt) {
            GameStateController.getInstance().setState((byte)2);
            switch (levelNo) {
                case 0: {
                    Action act = new Action(this, "SETCURRENTLEVEL", "1");
                    act.doAction();
                    break;
                }
                case 1: {
                    Action act = new Action(this, "SETCURRENTLEVEL", "4");
                    act.doAction();
                    break;
                }
                case 2: {
                    Action act = new Action(this, "SETCURRENTLEVEL", "6");
                    act.doAction();
                    break;
                }
                case 3: {
                    Action act = new Action(this, "SETCURRENTLEVEL", "8");
                    act.doAction();
                }
            }
        }
    }

    private void checkButtonAnim() {
        if (this.bLButtonAnimFlag) {
            this.sprEFBtnLeft.nextFrame();
            if (this.sprEFBtnLeft.getFrame() >= this.sprEFBtnLeft.getFrameSequenceLength() - 1) {
                this.sprEFBtnLeft.setFrame(0);
                this.bLButtonAnimFlag = false;
            }
        }
        if (this.bRButtonAnimFlag) {
            this.sprEFBtnRight.nextFrame();
            if (this.sprEFBtnRight.getFrame() >= this.sprEFBtnRight.getFrameSequenceLength() - 1) {
                this.sprEFBtnRight.setFrame(0);
                this.bRButtonAnimFlag = false;
            }
        }
    }

    public void paint(Graphics g) {
        TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("lao"));
        TextWriter.getInstance().setWriterType(0);
        this.lmEF.paint(g, 0, 0);
        if (this.lblDesc != null) {
            this.lblDesc.paint(g);
            TextWriter.getInstance().drawText(g, this.score, ResolutionHandler.getInstance().getCurrentWidth() / 2 - TextWriter.getInstance().getTextWidth(this.score) / 2, this.sprEFBoard.getY() + 15);
        }
    }

    public void tick() {
        this.checkButtonAnim();
        this.iPressedLeftTime = this.iPressedLeftTime > 0 ? this.iPressedLeftTime - 1 : 0;
    }

    public void destroy() {
        this.sprEFBtnLeft = null;
        this.sprEFBtnRight = null;
        this.sprEFLocation = null;
        this.sprEFBoard = null;
        this.lmEF.removeAllLayers();
        this.lmEF = null;
    }
}

