/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Random;
import java.util.Vector;
import mynotes.FileDescriptor;

public class QuickSort {
    private static long comparisons = 0L;
    private static long exchanges = 0L;

    public static void quicksort(Vector a) {
        QuickSort.shuffle(a);
        QuickSort.quicksort(a, 0, a.size() - 1);
    }

    public static void quicksort(Vector a, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = QuickSort.partition(a, left, right);
        QuickSort.quicksort(a, left, i - 1);
        QuickSort.quicksort(a, i + 1, right);
    }

    private static int partition(Vector a, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (QuickSort.less(a.elementAt(++i), a.elementAt(right))) {
                continue;
            }
            while (QuickSort.less(a.elementAt(right), a.elementAt(--j)) && j != left) {
            }
            if (i >= j) break;
            QuickSort.exch(a, i, j);
        }
        QuickSort.exch(a, i, right);
        return i;
    }

    private static boolean less(Object x, Object y) {
        ++comparisons;
        return ((FileDescriptor)x).compareTo(y) < 0;
    }

    private static void exch(Vector a, int i, int j) {
        ++exchanges;
        Object swap = a.elementAt(i);
        a.setElementAt(a.elementAt(j), i);
        a.setElementAt(swap, j);
    }

    private static void shuffle(Vector a) {
        Random rnd = new Random();
        int N = a.size();
        for (int i = 0; i < N; ++i) {
            int r = i + Math.abs(rnd.nextInt()) % (N - i);
            QuickSort.exch(a, i, r);
        }
    }
}

