/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.TextField;
import mynotes.Commands;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.ResourceBundle;

public class Find
extends Form
implements MyDisplayable,
CommandListener {
    private static TextField searchText;
    private static ChoiceGroup searchType;
    private static ChoiceGroup caseSensitive;
    private static Spacer spacer;
    private static Alert waitSearch;
    public static Gauge gauge;

    public Find() {
        super("MyNotes");
        searchType = new ChoiceGroup(ResourceBundle.getString("fd-type"), 1);
        searchType.append(ResourceBundle.getString("fd-tcon"), null);
        searchType.append(ResourceBundle.getString("fd-tnam"), null);
        caseSensitive = new ChoiceGroup("", 2);
        caseSensitive.append(ResourceBundle.getString("fd-case"), null);
        spacer = new Spacer(10, 10);
        searchText = new TextField(ResourceBundle.getString("fd-text"), "", 100, 0x200000);
        this.addCommand(Commands.BACK);
        this.addCommand(Commands.OK);
        this.append((Item)searchType);
        this.append((Item)spacer);
        this.append((Item)caseSensitive);
        this.append((Item)searchText);
        this.setCommandListener(this);
    }

    public void activate() {
        MyNotes.display.setCurrent((Displayable)this);
    }

    public void updateGauge() {
        if (gauge == null) {
            return;
        }
        int newValue = gauge.getValue() + 1;
        if (newValue < gauge.getMaxValue()) {
            gauge.setValue(gauge.getValue() + 1);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == Commands.OK) {
            final String text = searchText.getString();
            gauge = new Gauge(null, false, MyNotes.fs.files.size(), 0);
            if (text.length() != 0) {
                new Thread(new Runnable(){

                    public void run() {
                        MyNotes.notesBrowser.showSearchResults(text, searchType.isSelected(0), caseSensitive.isSelected(0));
                    }
                }).start();
                waitSearch = new Alert("MyNotes", ResourceBundle.getString("fd-wait"), null, AlertType.INFO);
                waitSearch.addCommand(Commands.DUMMY);
                waitSearch.setTimeout(-2);
                waitSearch.setIndicator(gauge);
                waitSearch.setCommandListener((CommandListener)this);
                MyNotes.display.setCurrent((Displayable)waitSearch);
            }
        }
        if (c == Commands.BACK) {
            MyNotes.menu.activate();
        }
    }
}

