/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.FileDescriptor;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.QuickSort;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class NotesFileSystem {
    static final int NOTHING = -1;
    static final int ROOT_DIR = 0;
    static final String RS_FDNAME = "fs";
    static final String RS_DIRNAME = "dir";
    static final int NOT_FOUND = -1;
    private int lastId;
    public Vector files;
    private static RecordStore rs;
    private Vector toDelete;

    public FileDescriptor getDescriptorById(int id) {
        FileDescriptor fd = null;
        boolean found = false;
        for (int i = 0; i < this.files.size(); ++i) {
            fd = (FileDescriptor)this.files.elementAt(i);
            if (id != fd.id) continue;
            found = true;
            break;
        }
        return found ? fd : null;
    }

    private int getFilesIndexById(int id) {
        int found = -1;
        FileDescriptor fd = null;
        for (int i = 0; i < this.files.size(); ++i) {
            fd = (FileDescriptor)this.files.elementAt(i);
            if (fd == null || id != fd.id) continue;
            found = i;
            break;
        }
        return found;
    }

    public static boolean openFDStorage() {
        try {
            rs = RecordStore.openRecordStore((String)RS_FDNAME, (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean openDirStorage(int dirId) {
        try {
            rs = RecordStore.openRecordStore((String)(RS_DIRNAME + dirId), (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean closeStorage() {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (RecordStoreException ex) {
                return false;
            }
        }
        return true;
    }

    public int init() {
        rs = null;
        this.toDelete = new Vector();
        this.files = new Vector();
        try {
            NotesFileSystem.openFDStorage();
            if (rs.getNumRecords() == 0) {
                this.lastId = this.makeDir(".", -1);
            } else {
                FileDescriptor fd = new FileDescriptor();
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                this.lastId = 0;
                while (re.hasNextElement()) {
                    int id = re.nextRecordId();
                    byte[] data = rs.getRecord(id);
                    fd.fromByteArray(data);
                    fd.recordId = id;
                    if (fd.id > this.lastId) {
                        this.lastId = fd.id;
                    }
                    this.files.addElement(fd.clone());
                }
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        NotesFileSystem.closeStorage();
        return this.files.size();
    }

    public int makeDir(String name, int parent) {
        try {
            FileDescriptor fd = new FileDescriptor();
            fd.isDirectory = true;
            fd.type = 17;
            fd.name = name;
            fd.size = 0;
            fd.date = System.currentTimeMillis();
            if (parent == -1) {
                fd.id = 0;
                fd.parentDirId = parent;
                if (this.files != null) {
                    this.files.removeAllElements();
                }
            } else {
                fd.id = this.nextId();
                fd.parentDirId = parent;
            }
            byte[] data = fd.toByteArray();
            NotesFileSystem.openFDStorage();
            fd.recordId = rs.addRecord(data, 0, data.length);
            NotesFileSystem.closeStorage();
            if (this.files == null) {
                this.files = new Vector();
            }
            this.files.addElement(fd);
            NotesFileSystem.openDirStorage(fd.id);
            NotesFileSystem.closeStorage();
            return fd.id;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public boolean rename(int id, String newName) {
        int index = this.getFilesIndexById(id);
        if (index == -1) {
            return false;
        }
        FileDescriptor fd = (FileDescriptor)this.files.elementAt(index);
        try {
            fd.name = newName;
            this.files.setElementAt(fd, index);
            byte[] data = fd.toByteArray();
            NotesFileSystem.openFDStorage();
            rs.setRecord(fd.recordId, data, 0, data.length);
            NotesFileSystem.closeStorage();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean delete(int id) {
        this.toDelete.removeAllElements();
        this.delete0(id);
        for (int i = 0; i < this.toDelete.size(); ++i) {
            int delId = (Integer)this.toDelete.elementAt(i);
            int index = this.getFilesIndexById(delId);
            this.files.setElementAt(null, index);
        }
        Vector<FileDescriptor> f = new Vector<FileDescriptor>();
        for (int i = 0; i < this.files.size(); ++i) {
            Object o = this.files.elementAt(i);
            if (o == null) continue;
            f.addElement(((FileDescriptor)this.files.elementAt(i)).clone());
        }
        this.files.removeAllElements();
        this.files = f;
        return true;
    }

    private boolean deleteNote(FileDescriptor fd) {
        try {
            NotesFileSystem.openDirStorage(fd.parentDirId);
            if (fd.dirRecordId != -1) {
                rs.deleteRecord(fd.dirRecordId);
            }
            NotesFileSystem.closeStorage();
            NotesFileSystem.openFDStorage();
            rs.deleteRecord(fd.recordId);
            NotesFileSystem.closeStorage();
            this.toDelete.addElement(new Integer(fd.id));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private boolean deleteEmptyDir(int id, int recordId) {
        try {
            NotesFileSystem.openFDStorage();
            rs.deleteRecord(recordId);
            NotesFileSystem.closeStorage();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)(RS_DIRNAME + new Integer(id).toString()));
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.toDelete.addElement(new Integer(id));
        return true;
    }

    private boolean delete0(int id) {
        if (id == 0) {
            return false;
        }
        FileDescriptor fd = this.getDescriptorById(id);
        if (fd == null) {
            return false;
        }
        if (!fd.isDirectory) {
            this.deleteNote(fd);
        } else {
            FileDescriptor f;
            int i;
            int delCount = 0;
            for (i = 0; i < this.files.size(); ++i) {
                f = (FileDescriptor)this.files.elementAt(i);
                if (f.parentDirId != id) continue;
                ++delCount;
            }
            if (delCount == 0) {
                this.deleteEmptyDir(id, fd.recordId);
                return true;
            }
            for (i = 0; i < this.files.size(); ++i) {
                f = (FileDescriptor)this.files.elementAt(i);
                if (f.parentDirId != id) continue;
                this.delete0(f.id);
            }
            this.deleteEmptyDir(id, fd.recordId);
        }
        return true;
    }

    public int makeNote(String name, int parentDir, int type) {
        FileDescriptor fd = new FileDescriptor();
        fd.name = name;
        fd.date = System.currentTimeMillis();
        fd.id = this.nextId();
        fd.size = 0;
        fd.type = type;
        fd.isDirectory = false;
        fd.dirRecordId = -1;
        fd.parentDirId = parentDir;
        try {
            byte[] data = fd.toByteArray();
            if (!NotesFileSystem.openFDStorage()) {
                return -1;
            }
            fd.recordId = rs.addRecord(data, 0, data.length);
            NotesFileSystem.closeStorage();
            this.files.addElement(fd);
        }
        catch (RecordStoreException ex) {
            fd.recordId = -1;
        }
        return fd.id;
    }

    public synchronized int setNote(int id, Note note) {
        int index = this.getFilesIndexById(id);
        if (index == -1) {
            return -1;
        }
        FileDescriptor fd = (FileDescriptor)this.files.elementAt(index);
        if (fd.isDirectory) {
            return -1;
        }
        try {
            NotesFileSystem.openDirStorage(fd.parentDirId);
            byte[] data = note.toByteArray();
            if (fd.dirRecordId == -1) {
                fd.dirRecordId = rs.getNextRecordID();
                fd.dirRecordId = rs.addRecord(data, 0, data.length);
                this.files.setElementAt(fd, index);
            } else {
                rs.setRecord(fd.dirRecordId, data, 0, data.length);
            }
            NotesFileSystem.closeStorage();
            NotesFileSystem.openFDStorage();
            fd.size = data.length;
            data = fd.toByteArray();
            rs.setRecord(fd.recordId, data, 0, data.length);
            NotesFileSystem.closeStorage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
        return fd.dirRecordId;
    }

    public synchronized Note getNote(int id) {
        FileDescriptor fd = this.getDescriptorById(id);
        Note note = null;
        if (fd == null) {
            return null;
        }
        if (fd.dirRecordId == -1) {
            note = new Note();
            note.id = id;
            note.text = "";
            return note;
        }
        try {
            if (!NotesFileSystem.openDirStorage(fd.parentDirId)) {
                return null;
            }
            byte[] data = rs.getRecord(fd.dirRecordId);
            NotesFileSystem.closeStorage();
            if (data == null) {
                return null;
            }
            note = new Note();
            note.fromByteArray(data);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return note;
    }

    public Vector getDirectoryListing(int id, int sortType) {
        int i;
        FileDescriptor fd;
        Vector<FileDescriptor> f = new Vector<FileDescriptor>();
        Vector<FileDescriptor> d = new Vector<FileDescriptor>();
        for (int i2 = 0; i2 < this.files.size(); ++i2) {
            fd = (FileDescriptor)this.files.elementAt(i2);
            if (fd.parentDirId != id) continue;
            if (fd.isDirectory) {
                d.addElement(fd);
                continue;
            }
            f.addElement(fd);
        }
        QuickSort.quicksort(f);
        QuickSort.quicksort(d);
        Vector<FileDescriptor> all = new Vector<FileDescriptor>();
        if (id != 0) {
            fd = this.getDescriptorById(id).clone();
            fd.name = "..";
            all.addElement(fd);
        }
        for (i = 0; i < d.size(); ++i) {
            all.addElement((FileDescriptor)d.elementAt(i));
        }
        for (i = 0; i < f.size(); ++i) {
            all.addElement((FileDescriptor)f.elementAt(i));
        }
        return all;
    }

    public Vector getListingByName(String text, boolean caseSensitive) {
        Vector<FileDescriptor> f = new Vector<FileDescriptor>();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fd = (FileDescriptor)this.files.elementAt(i);
            MyNotes.find.updateGauge();
            if (fd.isDirectory) continue;
            boolean match = false;
            String altText = text;
            String altName = fd.name;
            if (!caseSensitive) {
                altText.toUpperCase();
                altName.toUpperCase();
            }
            if (altName.indexOf(altText) != -1) {
                match = true;
            }
            if (!match) continue;
            f.addElement(fd);
        }
        QuickSort.quicksort(f);
        return f;
    }

    public Vector getListingByContent(String text, boolean caseSensitive) {
        Vector<FileDescriptor> f = new Vector<FileDescriptor>();
        String altText = text;
        if (!caseSensitive) {
            altText = altText.toUpperCase();
        }
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fd = (FileDescriptor)this.files.elementAt(i);
            MyNotes.find.updateGauge();
            if (fd.isDirectory) continue;
            boolean match = false;
            Note note = MyNotes.fs.getNote(fd.id);
            String altContent = "";
            if (note != null) {
                altContent = note.text;
            }
            if (!caseSensitive) {
                altContent = altContent.toUpperCase();
            }
            if (altContent.indexOf(altText) != -1) {
                match = true;
            }
            if (!match) continue;
            f.addElement(fd);
        }
        QuickSort.quicksort(f);
        return f;
    }

    private int nextId() {
        return ++this.lastId;
    }

    public int getLastId() {
        return this.lastId;
    }

    public int makeCopy(int id, int destDirId, boolean deleteAfterCopy) {
        int newId = -1;
        FileDescriptor fd = this.getDescriptorById(id);
        if (fd == null) {
            return newId;
        }
        if (fd.isDirectory) {
            newId = deleteAfterCopy ? this.moveDir(fd, destDirId) : this.makeCopyOfDir(fd, destDirId);
        } else {
            newId = this.makeCopyOfNote(fd, destDirId);
            if (deleteAfterCopy) {
                this.delete(fd.id);
            }
        }
        return newId;
    }

    private int makeCopyOfNote(FileDescriptor fd, int destDirId) {
        if (fd.isDirectory) {
            return -1;
        }
        String newName = destDirId == fd.parentDirId ? ResourceBundle.getString("nb-copyof") : "";
        newName = newName + fd.name;
        int newId = this.makeNote(newName, destDirId, fd.type);
        Note note = this.getNote(fd.id);
        note.id = newId;
        this.setNote(newId, note);
        return newId;
    }

    private int makeCopyOfDir(FileDescriptor fd, int destDirId) {
        if (!fd.isDirectory) {
            return -1;
        }
        int dirId = destDirId;
        while (dirId != 0) {
            if (fd.id == dirId) {
                return -1;
            }
            FileDescriptor f = this.getDescriptorById(dirId);
            dirId = f.parentDirId;
        }
        String newName = destDirId == fd.parentDirId ? ResourceBundle.getString("nb-copyof") : "";
        newName = newName + fd.name;
        int newId = this.makeDir(newName, destDirId);
        Vector ids = this.getDirectoryListing(fd.id, 0);
        for (int i = 0; i < ids.size(); ++i) {
            FileDescriptor f = (FileDescriptor)ids.elementAt(i);
            if (f.name.equals("..")) continue;
            this.makeCopy(f.id, newId, false);
        }
        return newId;
    }

    private int moveDir(FileDescriptor fd, int destDirId) {
        if (!fd.isDirectory) {
            return -1;
        }
        int dirId = destDirId;
        while (dirId != 0) {
            if (fd.id == dirId) {
                return -1;
            }
            FileDescriptor f = this.getDescriptorById(dirId);
            dirId = f.parentDirId;
        }
        fd.parentDirId = destDirId;
        this.files.setElementAt(fd, this.getFilesIndexById(fd.id));
        this.rename(fd.id, fd.name);
        return 0;
    }

    public int getAllDataSize() {
        FileDescriptor fd;
        int i;
        int size = 0;
        size += 4;
        int notesCount = 0;
        for (i = 0; i < this.files.size(); ++i) {
            fd = (FileDescriptor)this.files.elementAt(i);
            byte[] data = fd.toByteArray();
            size += 4 + data.length;
            if (fd.isDirectory) continue;
            ++notesCount;
        }
        size += 4;
        for (i = 0; i < this.files.size(); ++i) {
            Note note;
            fd = (FileDescriptor)this.files.elementAt(i);
            if (fd.isDirectory || (note = MyNotes.fs.getNote(fd.id)) == null) continue;
            byte[] data = note.toByteArray();
            size += 4 + data.length;
        }
        return size;
    }

    public static void encodeEverythigOnce() {
        Vector<FileDescriptor> tempFiles = new Vector<FileDescriptor>();
        try {
            if (MyNotes.properties.getStringValue("encrypted") != null) {
                return;
            }
            NotesFileSystem.openFDStorage();
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                byte[] data = rs.getRecord(id);
                Utils.encrypt(data);
                FileDescriptor fd = new FileDescriptor();
                fd.fromByteArray(data);
                fd.recordId = id;
                tempFiles.addElement(fd.clone());
            }
            NotesFileSystem.closeStorage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < tempFiles.size(); ++i) {
            byte[] data;
            FileDescriptor fd = (FileDescriptor)tempFiles.elementAt(i);
            try {
                if (!fd.isDirectory && fd.dirRecordId != -1) {
                    NotesFileSystem.openDirStorage(fd.parentDirId);
                    data = rs.getRecord(fd.dirRecordId);
                    Utils.encrypt(data);
                    rs.setRecord(fd.dirRecordId, data, 0, data.length);
                    NotesFileSystem.closeStorage();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NotesFileSystem.closeStorage();
            }
            try {
                NotesFileSystem.openFDStorage();
                fd.type |= 0x10;
                data = fd.toByteArray();
                rs.setRecord(fd.recordId, data, 0, data.length);
                NotesFileSystem.closeStorage();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        MyNotes.properties.put("encrypted", "y", 9);
    }

    public void deleteAllData() {
        String[] names = RecordStore.listRecordStores();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("settings")) continue;
            try {
                RecordStore.deleteRecordStore((String)names[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.files.removeAllElements();
    }
}

