/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MainMenu;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class Export
extends Form
implements MyDisplayable,
CommandListener {
    private static TextField path;
    private static Alert jsr75NotSupported;
    private static Alert exportError;
    private static Alert exportComplete;
    private static Alert waitExport;
    private static Gauge gauge;
    private boolean exportFinished;
    private boolean errors;

    public Export() {
        super(ResourceBundle.getString("ex-title"));
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            jsr75NotSupported = new Alert("MyNotes", ResourceBundle.getString("ex-nojsr75"), null, AlertType.WARNING);
            jsr75NotSupported.setTimeout(-2);
            MyNotes.display.setCurrent(jsr75NotSupported, MainMenu.menu.getDisplayable());
            return;
        }
        String string = "";
        try {
            string = System.getProperty("fileconn.dir.photos") + "MN_" + Utils.dateAsString2(System.currentTimeMillis()) + ".mn1";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        path = new TextField(ResourceBundle.getString("ex-path"), string, 120, 0);
        this.addCommand(Commands.BACK);
        this.addCommand(Commands.OK);
        this.append((Item)path);
        this.setCommandListener(this);
    }

    public void activate() {
        MyNotes.display.setCurrent((Displayable)this);
    }

    public void updateGauge() {
        if (gauge == null) {
            return;
        }
        int n = gauge.getValue() + 1;
        if (n < gauge.getMaxValue()) {
            gauge.setValue(gauge.getValue() + 1);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Commands.OK) {
            String string = path.getString();
            if (string.length() == 0) {
                return;
            }
            this.errors = false;
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)string);
                if (!fileConnection.exists()) {
                    fileConnection.create();
                    fileConnection.close();
                    fileConnection = (FileConnection)Connector.open((String)string, (int)2);
                }
                gauge = new Gauge(null, false, MyNotes.fs.files.size(), 0);
                final OutputStream outputStream = fileConnection.openOutputStream();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Export.this.writeAllDataToStream(outputStream);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }).start();
                waitExport = new Alert("MyNotes", ResourceBundle.getString("ex-wait"), null, AlertType.INFO);
                waitExport.addCommand(Commands.DUMMY);
                waitExport.setTimeout(-2);
                waitExport.setIndicator(gauge);
                waitExport.setCommandListener((CommandListener)this);
                MyNotes.display.setCurrent((Displayable)waitExport);
            }
            catch (Exception exception) {
                this.errors = true;
                exception.printStackTrace();
            }
            new Thread(new Runnable(){

                public void run() {
                    try {
                        while (!Export.this.exportFinished) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (Export.this.errors) {
                        exportError = new Alert("MyNotes", ResourceBundle.getString("ex-errors"), null, AlertType.ERROR);
                        exportError.setTimeout(2000);
                        MyNotes.display.setCurrent(exportError, MainMenu.menu.getDisplayable());
                    } else {
                        exportComplete = new Alert("MyNotes", ResourceBundle.getString("ex-ok"), null, AlertType.INFO);
                        exportComplete.setTimeout(2000);
                        MyNotes.display.setCurrent(exportComplete, MainMenu.menu.getDisplayable());
                    }
                }
            }).start();
        }
        if (command == Commands.BACK) {
            MyNotes.menu.activate();
        }
    }

    public void writeAllDataToStream(OutputStream outputStream) {
        this.exportFinished = false;
        try {
            Object object;
            FileDescriptor fileDescriptor;
            int n;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            Vector vector = MyNotes.fs.files;
            dataOutputStream.writeInt(vector.size());
            int n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                fileDescriptor = (FileDescriptor)vector.elementAt(n);
                object = fileDescriptor.toByteArray();
                dataOutputStream.writeInt(((byte[])object).length);
                dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
                if (fileDescriptor.isDirectory) continue;
                ++n2;
            }
            dataOutputStream.writeInt(n2);
            for (n = 0; n < vector.size(); ++n) {
                this.updateGauge();
                fileDescriptor = (FileDescriptor)vector.elementAt(n);
                if (fileDescriptor.isDirectory || (object = (Object)MyNotes.fs.getNote(fileDescriptor.id)) == null) continue;
                byte[] byArray = ((Note)object).toByteArray();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.exportFinished = true;
    }
}

