/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.Property;

public class Properties {
    private String storageName;
    RecordStore rs;
    Hashtable pairs = new Hashtable();

    public Properties(String string) {
        this.storageName = string;
    }

    public void loadTable() {
        this.openStorage();
        this.pairs.clear();
        try {
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                Property property = new Property();
                int n = recordEnumeration.nextRecordId();
                byte[] byArray = this.rs.getRecord(n);
                if (!property.fromByteArray(byArray)) continue;
                property.rsId = n;
                this.pairs.put(property.key, property);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        this.closeStorage();
    }

    public void addPair(String string, Object object, int n) {
        Property property = null;
        if (this.pairs.containsKey(string)) {
            property = (Property)this.pairs.get(string);
        } else {
            property = new Property();
            property.rsId = -1;
        }
        property.type = n;
        property.key = string;
        property.value = object;
        this.openStorage();
        byte[] byArray = property.toByteArray();
        try {
            if (property.rsId != -1) {
                this.rs.setRecord(property.rsId, byArray, 0, byArray.length);
            } else {
                property.rsId = this.rs.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        this.closeStorage();
        this.pairs.put(property.key, property);
    }

    public Integer getIntValue(String string) {
        Integer n = null;
        Property property = (Property)this.pairs.get(string);
        if (property != null && property.value != null && property.value.getClass().getName().equals("java.lang.Integer")) {
            n = (Integer)property.value;
        }
        return n;
    }

    public String getStringValue(String string) {
        String string2 = null;
        Property property = (Property)this.pairs.get(string);
        if (property != null && property.value != null && property.value.getClass().getName().equals("java.lang.String")) {
            string2 = (String)property.value;
        }
        return string2;
    }

    public void removePair(String string) {
        Property property = (Property)this.pairs.get(string);
        this.openStorage();
        try {
            this.rs.deleteRecord(property.rsId);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        this.closeStorage();
        this.pairs.remove(string);
    }

    private boolean openStorage() {
        try {
            this.rs = RecordStore.openRecordStore((String)this.storageName, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        return true;
    }

    private boolean closeStorage() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        return true;
    }
}

