/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountForm;
import JabpLite.AccountStore;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.CurrencyStore;
import JabpLite.CurrencyView;
import JabpLite.FindForm;
import JabpLite.FindView;
import JabpLite.FutureBalance;
import JabpLite.ImportExportForm;
import JabpLite.InvestmentStore;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.KeyStore;
import JabpLite.NameId;
import JabpLite.NetWorth;
import JabpLite.OptionForm;
import JabpLite.PasswordForm;
import JabpLite.PreferenceForm;
import JabpLite.PreferenceStore;
import JabpLite.ProgramKeysForm;
import JabpLite.PurgeForm;
import JabpLite.RegularStore;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderStore;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.TransactionView;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class AccountView
extends Canvas
implements CommandListener,
Runnable {
    Account a;
    Account a1;
    Account oldA;
    AccountForm af;
    Form debug;
    AccountStore as;
    Alert alert;
    Display display;
    Font font;
    Form cmf;
    Form rbf;
    Form about;
    Form info;
    Form cad;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    FindForm ff;
    OptionForm ol;
    ViewForm vl;
    PreferenceForm pf;
    PasswordForm pwf;
    ProgramKeysForm pkf;
    PurgeForm puf;
    TextBox faq;
    TextBox helpKeys;
    JabpLite parent;
    String msg = "";
    ImportExportForm ief;
    boolean paintWholeScreen = true;
    boolean paintHeaderOnly = false;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int spacing;
    int accountWidth;
    int numberWidth;
    int openPosition;
    int currentPosition;
    int todayPosition;
    int reconciledPosition;
    int totalOpen;
    int totalCurrent;
    int totalToday;
    int totalReconciled;
    int runMode;
    int minAccountWidth;
    int accountDisplayType;
    int minAccountAmount;
    int maxAccountAmount;
    long timePointerOnScreen;
    boolean pointerExecute;

    public AccountView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.entriesCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.extraCommand);
        this.addCommand(this.parent.findCommand);
        this.addCommand(this.parent.toggleDefaultActionCommand);
        this.addCommand(this.parent.aboutCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.as = new AccountStore(this.parent);
        this.numItems = this.as.getNumAccounts();
        this.setTotals();
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.ief = null;
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.setPositions();
            this.showHeader(graphics);
            if (!this.paintHeaderOnly || this.parent.isBlackberry) {
                this.showPage(graphics);
                this.showFooter(graphics);
            }
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
        this.paintHeaderOnly = false;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.a = this.as.getAccountFromIndex(i + this.startPos);
            this.buildLine(graphics, this.a, this.lineHeight * i + this.lineHeight);
        }
        this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.a = this.as.getAccountFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.a, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.a = this.as.getAccountFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.a, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            String string = "Accounts";
            if (this.font.stringWidth(string) > this.accountWidth) {
                string = "Accts";
            }
            graphics.drawString(string, this.parent.widthAdjustment, n, 20);
            if (this.accountDisplayType == 0) {
                graphics.drawString("Open", this.openPosition + this.numberWidth - this.font.stringWidth("Open"), n, 20);
            }
            if (this.accountDisplayType <= 1) {
                graphics.drawString("Current", this.currentPosition + this.numberWidth - this.font.stringWidth("Current"), n, 20);
                graphics.drawString("Today", this.todayPosition + this.numberWidth - this.font.stringWidth("Today"), n, 20);
                string = "Reconciled";
                if (this.font.stringWidth(string) > this.numberWidth) {
                    string = "Rec";
                }
                graphics.drawString(string, this.reconciledPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
            } else {
                if (this.parent.showBalanceType) {
                    graphics.drawString("Current", this.currentPosition + this.numberWidth - this.font.stringWidth("Current"), n, 20);
                } else {
                    graphics.drawString("Today", this.todayPosition + this.numberWidth - this.font.stringWidth("Today"), n, 20);
                }
                if (this.accountDisplayType < 3) {
                    graphics.drawString("Rec", this.reconciledPosition + this.numberWidth - this.font.stringWidth("Rec"), n, 20);
                }
            }
        } else {
            graphics.setColor(this.parent.colorMessage);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString(this.msg, this.parent.widthAdjustment, n, 20);
        }
    }

    void showFooter(Graphics graphics) {
        int n = this.height - this.lineHeight + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Totals", this.parent.widthAdjustment, n, 20);
        String string = "";
        if (this.accountDisplayType == 0) {
            string = Utilities.numberToString(this.totalOpen, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.openPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        }
        if (this.accountDisplayType <= 1) {
            string = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
            string = Utilities.numberToString(this.totalToday, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        } else if (this.parent.showBalanceType) {
            string = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        } else {
            string = Utilities.numberToString(this.totalToday, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        }
        if (this.accountDisplayType < 3) {
            string = Utilities.numberToString(this.totalReconciled, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.reconciledPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        }
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void buildLine(Graphics graphics, Account account, int n) {
        int n2 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        int n3 = account.name.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = n3 - i;
            if (this.font.stringWidth(account.name.substring(0, n4)) > this.accountWidth) continue;
            graphics.drawString(account.name.substring(0, n4), this.parent.widthAdjustment, n2, 20);
            break;
        }
        String string = "";
        if (this.accountDisplayType == 0) {
            string = Utilities.numberToString(account.open, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.openPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        }
        if (this.accountDisplayType <= 1) {
            string = Utilities.numberToString(account.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
            string = Utilities.numberToString(account.today, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        } else if (this.parent.showBalanceType) {
            string = Utilities.numberToString(account.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        } else {
            string = Utilities.numberToString(account.today, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        }
        if (this.accountDisplayType < 3) {
            string = Utilities.numberToString(account.reconciled, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.reconciledPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        }
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.minAccountAmount < -9999999 || this.maxAccountAmount > 99999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("9,999,999.99") : this.font.stringWidth("9999999.99")) : (this.minAccountAmount < -999999 || this.maxAccountAmount > 9999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99")) : (this.minAccountAmount < -99999 || this.maxAccountAmount > 999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("99,999.99") : this.font.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.font.stringWidth("9,999.99") : this.font.stringWidth("9999.99"))));
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.minAccountWidth = this.font.stringWidth("My Accounts");
        if (this.parent.accountColumnsPortrait > 0 && this.getHeight() > this.getWidth()) {
            this.minAccountWidth = this.font.stringWidth("Accts");
            this.accountDisplayType = 4 - this.parent.accountColumnsPortrait;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * this.parent.accountColumnsPortrait - this.spacing * this.parent.accountColumnsPortrait;
        } else if (this.parent.accountColumnsLandscape > 0 && this.getWidth() > this.getHeight()) {
            this.accountDisplayType = 4 - this.parent.accountColumnsLandscape;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * this.parent.accountColumnsLandscape - this.spacing * this.parent.accountColumnsLandscape;
        } else {
            this.accountDisplayType = 0;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * 4 - this.spacing * 4;
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 1;
                this.accountWidth += this.numberWidth + this.spacing;
            }
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 2;
                this.accountWidth += this.numberWidth + this.spacing;
            }
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 3;
                this.accountWidth += this.numberWidth + this.spacing;
            }
        }
        if (this.accountDisplayType == 0) {
            this.openPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.currentPosition = this.openPosition + this.numberWidth + this.spacing;
            this.todayPosition = this.currentPosition + this.numberWidth + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        } else if (this.accountDisplayType == 1) {
            this.currentPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.todayPosition = this.currentPosition + this.numberWidth + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        } else if (this.parent.showBalanceType) {
            this.currentPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.reconciledPosition = this.currentPosition + this.numberWidth + this.spacing;
        } else {
            this.todayPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        }
    }

    Account showAccount() {
        this.oldA = new Account();
        this.oldA.clone(this.a);
        return this.a;
    }

    void newAccount(Account account) {
        this.a1 = account;
        this.a1.id = this.as.saveNewAccount(this.a1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), 1);
        }
        if (this.a == null) {
            this.a = this.a1;
        }
        ++this.numItems;
        this.totalCurrent += account.current;
        this.totalToday += account.today;
        this.totalReconciled += account.reconciled;
        this.checkMinMax(this.a1);
        this.repaint();
    }

    void editAccount(Account account) {
        this.a1 = account;
        this.as.saveExistingAccount(this.a1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), 1);
        }
        this.totalCurrent += this.a1.current - this.oldA.current;
        this.totalToday += this.a1.today - this.oldA.today;
        this.totalReconciled += this.a1.reconciled - this.oldA.reconciled;
        this.checkMinMax(this.a1);
        if (!this.a1.name.equals(this.oldA.name)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.as.toByteArray(this.oldA), -1);
            }
            this.msg = "";
        }
        this.repaint();
    }

    void deleteAccount(Account account) {
        this.a1 = account;
        this.as.deleteAccount(this.a1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), -1);
        }
        this.as.deleteIndex(this.startPos + this.currentPos);
        this.parent.transactionHt.remove(this.a1.name);
        this.totalCurrent -= this.a1.current;
        this.totalToday -= this.a1.today;
        this.totalReconciled -= this.a1.reconciled;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void checkMinMax(Account account) {
        this.minAccountAmount = Math.min(this.minAccountAmount, account.current);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, account.current);
        this.minAccountAmount = Math.min(this.minAccountAmount, this.totalCurrent);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, this.totalCurrent);
    }

    void setTotals() {
        this.totalOpen = 0;
        this.totalCurrent = 0;
        this.totalToday = 0;
        this.totalReconciled = 0;
        this.minAccountAmount = 0;
        this.maxAccountAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.a = this.as.getAccountFromIndex(i);
            this.totalOpen += this.a.open;
            this.totalCurrent += this.a.current;
            this.totalToday += this.a.today;
            this.totalReconciled += this.a.reconciled;
            this.minAccountAmount = Math.min(this.minAccountAmount, this.a.current);
            this.maxAccountAmount = Math.max(this.maxAccountAmount, this.a.current);
        }
        this.minAccountAmount = Math.min(this.minAccountAmount, this.totalCurrent);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, this.totalCurrent);
    }

    void updateAccountName() {
        Object object;
        this.as.deleteIndex(this.startPos + this.currentPos);
        this.as.addIndex(this.a1);
        TransactionStore transactionStore = new TransactionStore(this.parent, this.oldA);
        RecordEnumeration recordEnumeration = transactionStore.getTransactions();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                object = transactionStore.getTransaction(n);
                if (((Transaction)object).account.equals(this.oldA.name)) {
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(transactionStore.toByteArray((Transaction)object), -8);
                    }
                    ((Transaction)object).account = this.a1.name;
                    transactionStore.saveExistingTransaction((Transaction)object);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(transactionStore.toByteArray((Transaction)object), 8);
                    }
                }
                if (!((Transaction)object).transferFlag || !((Transaction)object).transferAccount.equals(this.oldA.name)) continue;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(transactionStore.toByteArray((Transaction)object), -8);
                }
                ((Transaction)object).transferAccount = this.a1.name;
                transactionStore.saveExistingTransaction((Transaction)object);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(transactionStore.toByteArray((Transaction)object), 8);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " av5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        transactionStore.closeTransactionStore();
        transactionStore = null;
        Hashtable hashtable = (Hashtable)this.parent.transactionHt.get(this.oldA.name);
        this.parent.transactionHt.remove(this.oldA.name);
        this.parent.transactionHt.put(this.a1.name, hashtable);
        object = new StandingOrderStore(this.parent);
        recordEnumeration = ((StandingOrderStore)object).getStandingOrders();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                StandingOrder standingOrder = ((StandingOrderStore)object).getStandingOrder(n);
                if (standingOrder.account.equals(this.oldA.name)) {
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(((StandingOrderStore)object).toByteArray(standingOrder), -6);
                    }
                    standingOrder.account = this.a1.name;
                    ((StandingOrderStore)object).saveExistingStandingOrder(standingOrder);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(((StandingOrderStore)object).toByteArray(standingOrder), 6);
                    }
                }
                if (!standingOrder.transferFlag || !standingOrder.transferAccount.equals(this.oldA.name)) continue;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(((StandingOrderStore)object).toByteArray(standingOrder), -6);
                }
                standingOrder.transferAccount = this.a1.name;
                ((StandingOrderStore)object).saveExistingStandingOrder(standingOrder);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(((StandingOrderStore)object).toByteArray(standingOrder), 6);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " av5a");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((StandingOrderStore)object).closeStandingOrderStore();
        object = null;
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.oldA), -1);
        }
        if (this.parent.sov != null) {
            this.parent.sov.runThread();
        }
        this.msg = "";
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    void purgeTransactions() {
        this.puf.processPurge();
        this.puf = null;
        this.msg = "";
        this.repaint();
    }

    void compressFiles() {
        Object object;
        this.show("Compressing transactions...", true);
        if (this.parent.tv == null) {
            object = new TransactionStore(this.parent, new Account());
            ((TransactionStore)object).compressTransactions();
            ((TransactionStore)object).closeTransactionStore();
            object = null;
            RegularStore regularStore = new RegularStore(this.parent);
            this.show("Compressing regulars...", true);
            regularStore.compressRegulars();
            regularStore.closeRegularStore();
            regularStore = null;
        } else {
            this.parent.tv.ts.compressTransactions();
            this.show("Compressing regulars...", true);
            this.parent.tv.rs.compressRegulars();
        }
        this.show("Compressing accounts...", true);
        this.as.compressAccounts();
        this.show("Compressing categories...", true);
        if (this.parent.cv == null) {
            object = new CategoryStore(this.parent);
            ((CategoryStore)object).compressCategories();
            ((CategoryStore)object).closeCategoryStore();
            object = null;
        } else {
            this.parent.cv.cs.compressCategories();
        }
        this.show("Compressing currencies...", true);
        if (this.parent.ccyv == null) {
            object = new CurrencyStore(this.parent);
            ((CurrencyStore)object).compressCurrencies();
            ((CurrencyStore)object).closeCurrencyStore();
            object = null;
        } else {
            this.parent.ccyv.ccys.compressCurrencies();
        }
        this.show("Compressing investments...", true);
        if (this.parent.iv == null) {
            object = new InvestmentStore(this.parent);
            ((InvestmentStore)object).compressInvestments();
            ((InvestmentStore)object).closeInvestmentStore();
            object = null;
        } else {
            this.parent.iv.is.compressInvestments();
        }
        this.show("Compressing standing orders...", true);
        if (this.parent.sov == null) {
            object = new StandingOrderStore(this.parent);
            ((StandingOrderStore)object).compressStandingOrders();
            ((StandingOrderStore)object).closeStandingOrderStore();
            object = null;
        } else {
            this.parent.sov.sos.compressStandingOrders();
        }
        this.cmf = null;
        this.msg = "";
        this.repaint();
    }

    void resetDisplay() {
        this.as.closeAccountStore();
        this.as = new AccountStore(this.parent);
        this.numItems = this.as.getNumAccounts();
        this.setTotals();
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
    }

    void show(String string, boolean bl) {
        this.paintHeaderOnly = bl;
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    void processFind() {
        String string = this.ff.execute();
        this.ff = null;
        this.msg = "";
        FindView findView = new FindView(this.parent, this.display, string, false);
        this.display.setCurrent((Displayable)findView);
    }

    void processFAQ() {
        int n = 9000;
        this.faq = new TextBox("JabpLite FAQ", null, n, 131072);
        this.faq.addCommand(this.parent.okCommand);
        this.faq.addCommand(this.parent.exitCommand);
        this.faq.setCommandListener((CommandListener)this);
        try {
            DataInputStream dataInputStream = new DataInputStream(this.parent.getClass().getResourceAsStream("/Text/JabpLiteFAQ.txt"));
            if (dataInputStream == null) {
                this.faq.setString("Could not open FAQ");
            } else {
                byte[] byArray = new byte[n];
                int n2 = dataInputStream.read(byArray, 0, n);
                this.faq.setString(new String(byArray, 0, n2));
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.faq.setString("Failed to load text");
        }
        this.display.setCurrent((Displayable)this.faq);
        this.msg = "";
    }

    void processHelpKeys() {
        int n = 5000;
        this.helpKeys = new TextBox("Program keys", null, n, 131072);
        this.helpKeys.addCommand(this.parent.okCommand);
        this.helpKeys.addCommand(this.parent.exitCommand);
        this.helpKeys.setCommandListener((CommandListener)this);
        try {
            DataInputStream dataInputStream = new DataInputStream(this.parent.getClass().getResourceAsStream("/Text/HelpKeys.txt"));
            if (dataInputStream == null) {
                this.helpKeys.setString("Could not open help file");
            } else {
                byte[] byArray = new byte[n];
                int n2 = dataInputStream.read(byArray, 0, n);
                this.helpKeys.setString(new String(byArray, 0, n2));
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.helpKeys.setString("Failed to load text");
        }
        this.display.setCurrent((Displayable)this.helpKeys);
        this.msg = "";
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.updateAccountName();
        }
        if (this.runMode == 2) {
            this.purgeTransactions();
        }
        if (this.runMode == 3) {
            this.compressFiles();
        }
        if (this.runMode == 4) {
            this.processFind();
        }
        if (this.runMode == 5) {
            this.parent.recreateIndices(true);
        }
        if (this.runMode == 6) {
            this.processFAQ();
        }
        if (this.runMode == 7) {
            this.processHelpKeys();
        }
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            if (this.parent.showMenuAccountView) {
                this.displayTouchScreenMenu();
                return;
            }
            if (this.parent.tv != null) {
                this.parent.tv.ts.closeTransactionStore();
                this.parent.tv.rs.closeRegularStore();
            }
            this.parent.tv = new TransactionView(this.parent, this.display, this.a);
            this.display.setCurrent((Displayable)this.parent.tv);
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n2 + " of " + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.as.ht.get((Object)new Short((short)s))).id;
            this.debug.append("Record ID " + n3 + "\n");
            this.debug.append("Record length " + this.as.getRecordSize(n3) + "\n");
            this.debug.append("RecordStore size " + this.as.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = true;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        if (this.parent.showMenuAccountView) {
            this.displayTouchScreenMenu();
            return;
        }
        this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
        }
        this.parent.tv = new TransactionView(this.parent, this.display, this.a);
        this.display.setCurrent((Displayable)this.parent.tv);
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Account Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("Entries", null);
        this.cgtsm.append("New", null);
        this.cgtsm.append("Edit", null);
        this.cgtsm.append("Delete", null);
        this.cgtsm.append("Show", null);
        this.cgtsm.append("Switch Views", null);
        this.cgtsm.append("Extra Options", null);
        this.cgtsm.append("Find", null);
        this.cgtsm.append("Toggle Default Action", null);
        this.cgtsm.append("About", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        RecordEnumeration recordEnumeration;
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.entriesCommand) {
                this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
                if (this.parent.tv != null) {
                    this.parent.tv.ts.closeTransactionStore();
                    this.parent.tv.rs.closeRegularStore();
                }
                this.parent.tv = new TransactionView(this.parent, this.display, this.a);
                this.display.setCurrent((Displayable)this.parent.tv);
            }
            if (command == this.parent.newCommand) {
                this.af = new AccountForm(this.parent, new Account(), "New");
                this.af.addCommand(this.parent.createCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No accounts set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "Updating account, please wait...";
                this.repaint();
                this.af = new AccountForm(this.parent, this.showAccount(), "Edit");
                this.af.addCommand(this.parent.updateCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No accounts set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.af = new AccountForm(this.parent, this.showAccount(), "Delete");
                this.af.addCommand(this.parent.deleteCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No accounts set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.af = new AccountForm(this.parent, this.showAccount(), "Show");
                this.af.addCommand(this.parent.okCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.extraCommand) {
                this.msg = "Processing, please wait...";
                this.repaint();
                this.ol = new OptionForm();
                this.ol.addCommand(this.parent.okCommand);
                this.ol.addCommand(this.parent.cancelCommand);
                this.ol.addCommand(this.parent.exitCommand);
                this.ol.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ol);
            }
            if (command == this.parent.findCommand) {
                this.msg = "Processing, please wait...";
                this.repaint();
                this.ff = new FindForm(this.parent, true);
                this.ff.addCommand(this.parent.okCommand);
                this.ff.addCommand(this.parent.cancelCommand);
                this.ff.addCommand(this.parent.exitCommand);
                this.ff.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ff);
            }
            if (command == this.parent.toggleDefaultActionCommand) {
                if (this.parent.showMenuAccountView) {
                    this.parent.showMenuAccountView = false;
                    this.alert.setString("Default action: show account entries");
                } else {
                    this.parent.showMenuAccountView = true;
                    this.alert.setString("Default action: show menu");
                }
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.aboutCommand) {
                this.about = new Form("About JabpLite");
                this.about.append("\nJabpLite Version 1.67");
                this.about.append("\n\n(c) Malcolm Bryant & FreEPOC, 2004-2010");
                this.about.append("\nwww.freepoc.org");
                this.about.append("\nmalcolm@freepoc.org");
                if (this.parent.isAndroid) {
                    this.about.append("\n\nUses Microemu by Bartek Teodorczyk");
                }
                this.about.addCommand(this.parent.okCommand);
                this.about.addCommand(this.parent.exitCommand);
                this.about.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.about);
            }
        }
        if (displayable == this.af) {
            if (command == this.parent.deleteCommand) {
                this.af = null;
                if (((Hashtable)this.parent.transactionHt.get(this.a.name)).size() != 0) {
                    this.alert.setString("Cannot delete, there are transactions");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
                recordEnumeration = standingOrderStore.getStandingOrders();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        StandingOrder standingOrder = standingOrderStore.getStandingOrder(n);
                        if (!standingOrder.account.equals(this.a.name)) continue;
                        this.alert.setString("Cannot delete, there are standing orders");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        standingOrderStore.closeStandingOrderStore();
                        standingOrderStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " cv5a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                standingOrderStore.closeStandingOrderStore();
                standingOrderStore = null;
                this.deleteAccount(this.a);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.msg = "";
                this.af = null;
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.a1 = this.af.update(true);
                if (this.a1.name.equals("")) {
                    this.alert.setString("Blank account name");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                if (this.as.lookUpId(this.a1) != 0) {
                    this.alert.setString(this.a1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newAccount(this.a1);
                this.af = null;
            }
            if (command == this.parent.updateCommand) {
                this.a1 = this.af.update(false);
                if (this.a1.name.equals("")) {
                    this.alert.setString("Blank account name");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                int n = this.a1.id;
                if (!this.a1.name.equals(this.oldA.name) && this.as.lookUpId(this.a1) != 0) {
                    this.alert.setString(this.a1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                this.a1.id = n;
                this.display.setCurrent((Displayable)this);
                this.editAccount(this.a1);
                this.af = null;
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.af = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.pf) {
            if (command == this.parent.okCommand) {
                this.pf.update();
                this.setPositions();
                if (this.parent.cv != null) {
                    this.parent.cv.setPositions();
                }
                if (this.parent.ccyv != null) {
                    this.parent.ccyv.setPositions();
                }
                if (this.parent.tv != null) {
                    this.parent.tv.setPositions();
                }
                if (this.parent.sov != null) {
                    this.parent.sov.setPositions();
                    this.parent.sov.sof = null;
                }
                if (this.parent.iv != null) {
                    this.parent.iv.setPositions();
                }
                this.parent.tf2 = null;
                this.alert.setString("Preferences saved");
                this.pf = null;
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.customColorsCommand) {
                this.pf.setupCustomColors();
                this.pf.f1.addCommand(this.parent.okCommand);
                this.pf.f1.addCommand(this.parent.cancelCommand);
                this.pf.f1.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.pf.f1);
            }
            if (command == this.parent.cancelCommand) {
                this.pf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (this.pf != null && displayable == this.pf.f1) {
            if (command == this.parent.okCommand) {
                this.pf.updateCustomColors();
                this.alert.setString("Colours saved");
                this.pf = null;
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.pf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.pwf) {
            if (command == this.parent.okCommand) {
                if (!this.pwf.update()) {
                    this.alert.setString("Mismatched password");
                    this.display.setCurrent(this.alert, (Displayable)this.pwf);
                    return;
                }
                this.alert.setString("Password saved");
                this.display.setCurrent(this.alert, (Displayable)this);
                this.pwf = null;
            }
            if (command == this.parent.cancelCommand) {
                this.pwf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.pkf) {
            if (command == this.parent.okCommand) {
                this.pkf.update();
                KeyStore keyStore = new KeyStore(this.parent);
                keyStore.saveKeys();
                keyStore.closeKeyStore();
                this.pkf = null;
                this.alert.setString("Key weightings saved");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.deleteCommand) {
                this.parent.changedKeys = false;
                KeyStore keyStore = new KeyStore(this.parent);
                keyStore.closeKeyStore();
                keyStore.deleteKeyStore();
                this.pkf = null;
                this.alert.setString("Defaults restored");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.pkf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.puf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 2;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.deleteAllDataCommand) {
                this.msg = "";
                this.cad = new Form("Delete All Data");
                this.cad.append("This will DELETE ALL DATA!\n");
                this.cad.append("The program will restart\n");
                this.cad.append("Choose Delete to delete your data\n");
                this.cad.append("Or Cancel to keep your data\n");
                this.cad.addCommand(this.parent.deleteCommand);
                this.cad.addCommand(this.parent.cancelCommand);
                this.cad.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.cad);
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.puf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.cmf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 3;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cmf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.rbf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 5;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.rbf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv != null) {
                        this.parent.tv.ts.closeTransactionStore();
                        this.parent.tv.rs.closeRegularStore();
                    }
                    this.parent.tv = new TransactionView(this.parent, this.display, this.a);
                    this.display.setCurrent((Displayable)this.parent.tv);
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.ol) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ol = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.ol.update() == 0) {
                    this.msg = "";
                    this.pf = new PreferenceForm(this.parent);
                    this.pf.addCommand(this.parent.okCommand);
                    this.pf.addCommand(this.parent.customColorsCommand);
                    this.pf.addCommand(this.parent.cancelCommand);
                    this.pf.addCommand(this.parent.exitCommand);
                    this.pf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.pf);
                }
                if (this.ol.update() == 1) {
                    this.msg = "";
                    this.pwf = new PasswordForm(this.parent);
                    this.pwf.addCommand(this.parent.okCommand);
                    this.pwf.addCommand(this.parent.cancelCommand);
                    this.pwf.addCommand(this.parent.exitCommand);
                    this.pwf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.pwf);
                }
                if (this.ol.update() == 2) {
                    this.msg = "";
                    if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
                        this.alert.setString("Your device is not allowed to access the memory card from Java. Sync mode turned off.");
                        this.parent.syncMode = false;
                        this.display.setCurrent(this.alert, (Displayable)this);
                        return;
                    }
                    if (this.ief == null) {
                        this.ief = new ImportExportForm(this.parent);
                    }
                    this.display.setCurrent((Displayable)this.ief);
                }
                if (this.ol.update() == 3) {
                    this.msg = "";
                    NetWorth netWorth = new NetWorth(this.parent, this.display);
                    this.display.setCurrent((Displayable)netWorth);
                }
                if (this.ol.update() == 4) {
                    this.msg = "";
                    FutureBalance futureBalance = new FutureBalance(this.parent, this.display);
                    futureBalance.runThread();
                    this.display.setCurrent((Displayable)futureBalance);
                }
                if (this.ol.update() == 5) {
                    long l;
                    this.msg = "";
                    Calendar calendar = Calendar.getInstance();
                    this.parent.genericDate = calendar.getTime();
                    if (this.parent.isAndroid) {
                        this.parent.todayDate = calendar.getTime();
                    } else {
                        recordEnumeration = new DateField(null, 1);
                        recordEnumeration.setDate(this.parent.genericDate);
                        this.parent.todayDate = recordEnumeration.getDate();
                    }
                    if (this.parent.todayDate == null) {
                        this.parent.todayDate = calendar.getTime();
                    }
                    if ((l = Utilities.longToDays(this.parent.todayDate.getTime())) > this.parent.todayDays) {
                        this.parent.checkForNewDay();
                    } else {
                        this.alert.setString("Balances already updated");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    }
                }
                if (this.ol.update() == 6) {
                    this.display.setCurrent((Displayable)this);
                    this.puf = new PurgeForm(this.parent);
                    this.puf.addCommand(this.parent.okCommand);
                    this.puf.addCommand(this.parent.deleteAllDataCommand);
                    this.puf.addCommand(this.parent.cancelCommand);
                    this.puf.addCommand(this.parent.exitCommand);
                    this.puf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.puf);
                }
                if (this.ol.update() == 7) {
                    this.display.setCurrent((Displayable)this);
                    this.cmf = new Form("Compress files");
                    this.cmf.append("\nThis option compresses all your data files.  It may take several minutes to complete.");
                    this.cmf.addCommand(this.parent.okCommand);
                    this.cmf.addCommand(this.parent.cancelCommand);
                    this.cmf.addCommand(this.parent.exitCommand);
                    this.cmf.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.cmf);
                }
                if (this.ol.update() == 8) {
                    this.display.setCurrent((Displayable)this);
                    this.rbf = new Form("Recreate balances");
                    this.rbf.append("\nThis option recreates account & category balances.  It may take several minutes to complete.");
                    this.rbf.addCommand(this.parent.okCommand);
                    this.rbf.addCommand(this.parent.cancelCommand);
                    this.rbf.addCommand(this.parent.exitCommand);
                    this.rbf.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.rbf);
                }
                if (this.ol.update() == 9) {
                    int n;
                    this.msg = "";
                    this.info = new Form("JabpLite Information");
                    this.info.append("\n" + this.numItems + " Accounts");
                    int n2 = this.as.getSize();
                    TransactionStore transactionStore = new TransactionStore(this.parent, this.a);
                    this.info.append("\n" + transactionStore.getNumAllTransactions() + " Transactions");
                    int n3 = transactionStore.getSizeAvailable();
                    int n4 = transactionStore.getSize();
                    transactionStore.closeTransactionStore();
                    transactionStore = null;
                    CategoryStore categoryStore = new CategoryStore(this.parent);
                    this.info.append("\n" + categoryStore.getNumCategories() + " Categories");
                    int n5 = categoryStore.getSize();
                    categoryStore.closeCategoryStore();
                    categoryStore = null;
                    StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
                    this.info.append("\n" + standingOrderStore.getNumStandingOrders() + " Standing Orders");
                    int n6 = standingOrderStore.getSize();
                    standingOrderStore.closeStandingOrderStore();
                    standingOrderStore = null;
                    InvestmentStore investmentStore = new InvestmentStore(this.parent);
                    this.info.append("\n" + investmentStore.getNumInvestments() + " Investments");
                    int n7 = investmentStore.getSize();
                    investmentStore.closeInvestmentStore();
                    investmentStore = null;
                    CurrencyStore currencyStore = new CurrencyStore(this.parent);
                    this.info.append("\n" + currencyStore.getNumCurrencies() + " Currencies");
                    int n8 = currencyStore.getSize();
                    currencyStore.closeCurrencyStore();
                    currencyStore = null;
                    if (this.parent.sync != null && (n = this.parent.sync.getNumSyncRecords()) > 0) {
                        this.info.append("\n" + this.parent.sync.getNumSyncRecords() + " records to sync");
                    }
                    RegularStore regularStore = new RegularStore(this.parent);
                    int n9 = regularStore.getSize();
                    regularStore.closeRegularStore();
                    regularStore = null;
                    PreferenceStore preferenceStore = new PreferenceStore(this.parent);
                    int n10 = preferenceStore.getSize();
                    preferenceStore.closePreferenceStore();
                    preferenceStore = null;
                    int n11 = n2 + n4 + n5 + n6 + n7 + n8 + n9 + n10 + this.parent.indexSize;
                    this.info.append("\n" + n11 + " bytes allocated to data");
                    this.info.append("\n" + n3 + " bytes available for data");
                    this.info.append("\n" + System.getProperty("microedition.platform"));
                    this.info.append("\n" + this.width + "x" + this.height + " (to Java)");
                    this.info.append("\n" + Runtime.getRuntime().freeMemory() + " free memory");
                    this.info.append("\n" + Runtime.getRuntime().totalMemory() + " total memory");
                    this.info.addCommand(this.parent.okCommand);
                    this.info.addCommand(this.parent.exitCommand);
                    this.info.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.info);
                }
                if (this.ol.update() == 10) {
                    this.display.setCurrent((Displayable)this);
                    this.runMode = 6;
                    this.display.callSerially((Runnable)this);
                    this.repaint();
                }
                if (this.ol.update() == 11) {
                    this.msg = "";
                    this.pkf = new ProgramKeysForm(this.parent);
                    this.pkf.addCommand(this.parent.okCommand);
                    this.pkf.addCommand(this.parent.deleteCommand);
                    this.pkf.addCommand(this.parent.cancelCommand);
                    this.pkf.addCommand(this.parent.exitCommand);
                    this.pkf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.pkf);
                }
                if (this.ol.update() == 12) {
                    this.display.setCurrent((Displayable)this);
                    this.runMode = 7;
                    this.display.callSerially((Runnable)this);
                    this.repaint();
                }
            }
        }
        if (displayable == this.ff) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ff = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 4;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
        }
        if (displayable == this.cad) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cad = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.deleteCommand) {
                this.parent.deleteAllData = true;
                this.parent.destroyApp(true);
            }
        }
        if (displayable == this.about && command == this.parent.okCommand) {
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.info && command == this.parent.okCommand) {
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.faq && command == this.parent.okCommand) {
            this.faq = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.helpKeys && command == this.parent.okCommand) {
            this.helpKeys = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
                    if (this.parent.tv != null) {
                        this.parent.tv.ts.closeTransactionStore();
                        this.parent.tv.rs.closeRegularStore();
                    }
                    this.parent.tv = new TransactionView(this.parent, this.display, this.a);
                    this.display.setCurrent((Displayable)this.parent.tv);
                }
                if (n == 1) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n == 4) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 5) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n == 6) {
                    this.commandAction(this.parent.extraCommand, (Displayable)this);
                }
                if (n == 7) {
                    this.commandAction(this.parent.findCommand, (Displayable)this);
                }
                if (n == 8) {
                    this.commandAction(this.parent.toggleDefaultActionCommand, (Displayable)this);
                }
                if (n == 9) {
                    this.commandAction(this.parent.aboutCommand, (Displayable)this);
                }
                if (n == 10) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

