/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.AccountView;
import JabpLite.JabpLite;
import JabpLite.StandingOrderStore;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class FutureBalance
extends Canvas
implements CommandListener,
Runnable {
    boolean showResults = false;
    Display display;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    Alert alert;
    Date date;
    DateField df;
    Form f1;
    Font font;
    JabpLite parent;
    ChoiceGroup cgAccount;
    int fs;
    int width;
    int height;
    int chosenAccount;
    int runMode;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalAmount;
    long timePointerOnScreen;

    public FutureBalance(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.okCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.fontHeight;
    }

    void runThread() {
        this.runMode = 1;
        Thread thread = new Thread(this);
        thread.start();
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.getFutureDate();
        }
    }

    void getFutureDate() {
        this.f1 = new Form("Future Balance");
        this.f1.addCommand(this.parent.okCommand);
        this.f1.setCommandListener((CommandListener)this);
        this.df = new DateField("Date", 1);
        this.df.setDate(this.parent.todayDate);
        this.f1.append((Item)this.df);
        int n = 4;
        if (this.parent.oldStyleChoice) {
            n = 1;
        }
        this.cgAccount = new ChoiceGroup("Account", n);
        AccountStore accountStore = new AccountStore(this.parent);
        int n2 = accountStore.getNumAccounts();
        for (int i = 0; i < n2; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            this.cgAccount.append(account.name, null);
        }
        this.cgAccount.append("All accounts", null);
        this.f1.append((Item)this.cgAccount);
        accountStore.closeAccountStore();
        accountStore = null;
        this.display.setCurrent((Displayable)this.f1);
        this.showResults = true;
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
        }
        if (this.showResults) {
            graphics.setFont(this.font);
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        }
    }

    void showPage(Graphics graphics) {
        Object object;
        this.currentY = this.fontHeight;
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(this.parent.colorFont);
        AccountStore accountStore = new AccountStore(this.parent);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = accountStore.getNumAccounts();
        String string = "All accounts";
        for (int i = 0; i < n4; ++i) {
            object = accountStore.getAccountFromIndex(i);
            if (this.chosenAccount != i && this.chosenAccount != n4) continue;
            n += ((Account)object).today;
            if (this.chosenAccount != i) continue;
            string = ((Account)object).name;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        n2 = transactionStore.futureTransactions(this.date.getTime(), string);
        transactionStore.closeTransactionStore();
        transactionStore = null;
        object = new StandingOrderStore(this.parent);
        n3 = ((StandingOrderStore)object).futureStandingOrders(this.date.getTime(), string);
        ((StandingOrderStore)object).closeStandingOrderStore();
        object = null;
        this.totalAmount = n + n2 + n3;
        this.buildLine(graphics, "Today's Balance", n);
        this.buildLine(graphics, "Future Transactions", n2);
        this.buildLine(graphics, "Future S. Orders", n3);
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Future Balance", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString("Amount", this.amountPosition + this.numberWidth - this.font.stringWidth("Amount"), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Balance on " + this.setDate(this.date), this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalAmount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void buildLine(Graphics graphics, String string, int n) {
        this.currentY += this.fontHeight;
        graphics.drawString(string, this.parent.widthAdjustment, this.currentY + this.parent.fontAdjustment, 20);
        String string2 = Utilities.numberToString(n, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string2, this.amountPosition + this.numberWidth - this.font.stringWidth(string2), this.currentY + this.parent.fontAdjustment, 20);
        this.currentY += this.fontHeight;
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    String setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = "" + calendar.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = calendar.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        return string + "/" + string2;
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void pointerPressed(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis();
    }

    protected void pointerReleased(int n, int n2) {
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Future Balance Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("Close", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent, this.display);
            }
            this.display.setCurrent((Displayable)this.parent.av);
        }
        if (displayable == this.f1 && command == this.parent.okCommand) {
            this.date = this.df.getDate();
            this.chosenAccount = this.cgAccount.getSelectedIndex();
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.okCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

