/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.JabpLite;
import JabpLite.LongId;
import JabpLite.Sort;
import JabpLite.StandingOrder;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class StandingOrderStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public StandingOrderStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.standingOrderHt;
        this.openStandingOrderStore();
    }

    void openStandingOrderStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"StandingOrders", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos1");
        }
    }

    void closeStandingOrderStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos2");
        }
    }

    int getNumStandingOrders() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos3");
            return 0;
        }
    }

    RecordEnumeration getStandingOrders() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos6");
            return null;
        }
    }

    byte[] toByteArray(StandingOrder standingOrder) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(standingOrder.longProcessingDate);
            dataOutputStream.writeUTF(standingOrder.description);
            dataOutputStream.writeLong(standingOrder.longStartDate);
            dataOutputStream.writeLong(standingOrder.longEndDate);
            dataOutputStream.writeUTF(standingOrder.account);
            dataOutputStream.writeInt(standingOrder.amount);
            dataOutputStream.writeUTF(standingOrder.reference);
            dataOutputStream.writeUTF(standingOrder.category);
            dataOutputStream.writeInt(standingOrder.period);
            dataOutputStream.writeInt(standingOrder.interval);
            dataOutputStream.writeBoolean(standingOrder.transferFlag);
            dataOutputStream.writeUTF(standingOrder.transferAccount);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    StandingOrder fromByteArray(byte[] byArray) {
        StandingOrder standingOrder = new StandingOrder();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            standingOrder.longProcessingDate = dataInputStream.readLong();
            standingOrder.description = dataInputStream.readUTF();
            if (standingOrder.description.equals("")) {
                standingOrder.description = "(Blank)";
            }
            standingOrder.longStartDate = dataInputStream.readLong();
            standingOrder.longEndDate = dataInputStream.readLong();
            standingOrder.account = dataInputStream.readUTF();
            if (standingOrder.account.equals("")) {
                standingOrder.account = "(Blank)";
            }
            standingOrder.amount = dataInputStream.readInt();
            standingOrder.reference = dataInputStream.readUTF();
            standingOrder.category = dataInputStream.readUTF();
            if (standingOrder.category.equals("")) {
                standingOrder.category = "None";
            }
            standingOrder.period = dataInputStream.readInt();
            standingOrder.interval = dataInputStream.readInt();
            standingOrder.transferFlag = dataInputStream.readBoolean();
            standingOrder.transferAccount = dataInputStream.readUTF();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " sos4a");
        }
        return standingOrder;
    }

    StandingOrder getStandingOrder(int n) {
        StandingOrder standingOrder = new StandingOrder();
        try {
            byte[] byArray = this.rs.getRecord(n);
            standingOrder = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos4 record " + n);
        }
        standingOrder.id = n;
        return standingOrder;
    }

    StandingOrder getStandingOrderFromIndex(int n) {
        short s = (short)n;
        int n2 = ((LongId)this.ht.get((Object)new Short((short)s))).id;
        return this.getStandingOrder(n2);
    }

    StandingOrder getStandingOrderFromName(String string) {
        StandingOrder standingOrder = null;
        RecordEnumeration recordEnumeration = this.getStandingOrders();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n = recordEnumeration.nextRecordId();
                standingOrder = this.getStandingOrder(n);
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " sos8");
            }
            if (!standingOrder.description.equals(string)) continue;
            recordEnumeration.destroy();
            recordEnumeration = null;
            return standingOrder;
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        return null;
    }

    void deleteStandingOrder(StandingOrder standingOrder) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(standingOrder.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos5");
        }
    }

    int saveNewStandingOrder(StandingOrder standingOrder) {
        if (this.rs == null) {
            return 0;
        }
        try {
            standingOrder.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(standingOrder);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos7");
        }
        this.addIndex(standingOrder);
        return standingOrder.id;
    }

    void saveExistingStandingOrder(StandingOrder standingOrder) {
        if (this.rs == null) {
            return;
        }
        if (standingOrder.id == 0) {
            System.out.println("Id error in saveExistingStandingOrder()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(standingOrder);
            this.rs.setRecord(standingOrder.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos7a");
        }
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            LongId longId = (LongId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), longId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(StandingOrder standingOrder) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        long l = Utilities.longToDays(standingOrder.longProcessingDate);
        for (n = 0; n < n2; ++n) {
            LongId longId = (LongId)this.ht.get(new Short((short)n));
            if (l > Utilities.longToDays(longId.lo)) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                LongId longId = (LongId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), longId);
            }
        }
        LongId longId = new LongId(standingOrder.longProcessingDate, standingOrder.id);
        this.ht.put(new Short((short)n3), longId);
    }

    void deleteIndex(StandingOrder standingOrder) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = i;
            LongId longId = (LongId)this.ht.get(new Short((short)i));
            if (standingOrder.id == longId.id) break;
        }
        this.deleteIndex(n2);
    }

    int futureStandingOrders(long l, String string) {
        int n = 0;
        long l2 = Utilities.longToDays(l);
        RecordEnumeration recordEnumeration = this.getStandingOrders();
        block2: while (recordEnumeration.hasNextElement()) {
            StandingOrder standingOrder = null;
            try {
                int n2 = recordEnumeration.nextRecordId();
                standingOrder = this.getStandingOrder(n2);
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " sos8");
            }
            if (!string.equals("All accounts") && !string.equals(standingOrder.account) && !string.equals(standingOrder.transferAccount)) continue;
            while (Utilities.longToDays(standingOrder.longProcessingDate) <= l2) {
                if (string.equals("All accounts") && !standingOrder.transferFlag) {
                    n += standingOrder.amount;
                }
                if (string.equals(standingOrder.account)) {
                    n += standingOrder.amount;
                }
                if (string.equals(standingOrder.transferAccount)) {
                    n -= standingOrder.amount;
                }
                standingOrder.longProcessingDate = this.nextProcessingDate(standingOrder);
                if (Utilities.longToDays(standingOrder.longProcessingDate) <= Utilities.longToDays(standingOrder.longEndDate)) continue;
                continue block2;
            }
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        return n;
    }

    boolean processStandingOrders(long l) {
        AccountStore accountStore = null;
        accountStore = this.parent.av == null ? new AccountStore(this.parent) : this.parent.av.as;
        CategoryStore categoryStore = null;
        categoryStore = this.parent.cv == null ? new CategoryStore(this.parent) : this.parent.cv.cs;
        TransactionStore transactionStore = null;
        if (this.parent.tv == null) {
            transactionStore = new TransactionStore(this.parent, new Account());
        } else {
            transactionStore = this.parent.tv.ts;
            transactionStore.setIndex(this.parent.tv.a);
        }
        long l2 = Utilities.longToDays(l);
        int n = this.getNumStandingOrders();
        block2: for (int i = 0; i < n; ++i) {
            StandingOrder standingOrder;
            while (true) {
                Object object;
                standingOrder = this.getStandingOrderFromIndex(i);
                long l3 = Utilities.longToDays(standingOrder.longProcessingDate);
                if (l3 > l2) continue block2;
                this.parent.genericDate.setTime(standingOrder.longProcessingDate);
                this.parent.cal.setTime(this.parent.genericDate);
                int n2 = this.parent.cal.get(5);
                int n3 = this.parent.cal.get(2) + 1;
                String string = n2 + "/" + n3 + " " + standingOrder.description + " " + Utilities.numberToString(standingOrder.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                this.parent.f3.append(string, null);
                if (!this.parent.isAndroid) {
                    this.parent.f3.setSelectedIndex(this.parent.f3.size() - 1, true);
                }
                Transaction transaction = new Transaction();
                transaction.account = standingOrder.account;
                transaction.description = standingOrder.description;
                transaction.amount = standingOrder.amount;
                transaction.longDate = standingOrder.longProcessingDate;
                transaction.category = standingOrder.category;
                transaction.reference = standingOrder.reference;
                transaction.transferFlag = standingOrder.transferFlag;
                if (transaction.transferFlag) {
                    transaction.transferAccount = standingOrder.transferAccount;
                }
                Account account = accountStore.getAccountFromName(transaction.account);
                transactionStore.getIndex(account);
                if (transactionStore.getSizeAvailable() <= 1000) {
                    return false;
                }
                transaction.id = transactionStore.saveNewTransactionWithoutIndex(transaction);
                transactionStore.addIndex(transaction);
                transactionStore.setIndex(account);
                if (this.parent.tv != null && this.parent.tv.a.name.equals(account.name)) {
                    ++this.parent.tv.numItems;
                }
                if (transaction.id <= 0) {
                    return false;
                }
                this.updateAccountTotal1(account);
                account.updateBalance(transaction, null, this.parent.todayDays);
                this.updateAccountTotal2(account);
                accountStore.saveExistingAccount(account);
                if (transaction.transferFlag) {
                    object = new Transaction();
                    ((Transaction)object).clone(transaction);
                    ((Transaction)object).account = transaction.transferAccount;
                    ((Transaction)object).transferAccount = transaction.account;
                    ((Transaction)object).amount = -transaction.amount;
                    ((Transaction)object).transferAccountId = transaction.id;
                    Account account2 = accountStore.getAccountFromName(((Transaction)object).account);
                    if (transactionStore.getSizeAvailable() <= 1000) {
                        return false;
                    }
                    transactionStore.getIndex(account2);
                    ((Transaction)object).id = transactionStore.saveNewTransactionWithoutIndex((Transaction)object);
                    transactionStore.addIndex((Transaction)object);
                    if (((Transaction)object).id <= 0) {
                        return false;
                    }
                    transactionStore.setIndex(account2);
                    if (this.parent.tv != null && this.parent.tv.a.name.equals(account2.name)) {
                        ++this.parent.tv.numItems;
                    }
                    this.updateAccountTotal1(account2);
                    account2.updateBalance((Transaction)object, null, this.parent.todayDays);
                    this.updateAccountTotal2(account2);
                    accountStore.saveExistingAccount(account2);
                    transaction = transactionStore.getTransaction(transaction.id);
                    transaction.transferAccountId = ((Transaction)object).id;
                    transactionStore.saveExistingTransaction(transaction);
                } else {
                    object = categoryStore.getCategoryFromName(transaction.category);
                    this.updateCategoryTotal1((Category)object);
                    ((Category)object).updateBalance(transaction, null);
                    this.updateCategoryTotal2((Category)object);
                    categoryStore.saveExistingCategory((Category)object);
                    object = null;
                }
                standingOrder.longProcessingDate = this.nextProcessingDate(standingOrder);
                long l4 = Utilities.longToDays(standingOrder.longProcessingDate);
                long l5 = Utilities.longToDays(standingOrder.longEndDate);
                if (l4 > l5) break;
                this.saveExistingStandingOrder(standingOrder);
            }
            this.deleteStandingOrder(standingOrder);
        }
        if (this.parent.tv == null) {
            transactionStore.closeTransactionStore();
            transactionStore = null;
        } else {
            this.parent.tv.ts.getIndex(this.parent.tv.a);
        }
        if (this.parent.cv == null) {
            categoryStore.closeCategoryStore();
            categoryStore = null;
        }
        if (this.parent.av == null) {
            accountStore.closeAccountStore();
            accountStore = null;
        }
        this.parent.standingOrderHt = new Hashtable();
        if (this.getNumStandingOrders() == 0) {
            return true;
        }
        RecordEnumeration recordEnumeration = this.getStandingOrders();
        int n4 = 0;
        n = 0;
        Vector<LongId> vector = new Vector<LongId>();
        while (recordEnumeration.hasNextElement()) {
            try {
                n4 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6c");
            }
            StandingOrder standingOrder = this.getStandingOrder(n4);
            vector.addElement(new LongId(standingOrder.longProcessingDate, n4));
            ++n;
        }
        Sort.sortLongId(vector, 0, n - 1, false);
        for (int i = 0; i < n; ++i) {
            this.parent.standingOrderHt.put(new Short((short)i), (LongId)vector.elementAt(i));
        }
        this.ht = this.parent.standingOrderHt;
        recordEnumeration.destroy();
        recordEnumeration = null;
        vector = null;
        if (this.parent.sov != null) {
            this.parent.sov.numItems = n;
        }
        if (this.parent.av != null) {
            this.parent.av.repaint();
        }
        if (this.parent.cv != null) {
            this.parent.cv.repaint();
        }
        if (this.parent.tv != null) {
            this.parent.tv.repaint();
        }
        if (this.parent.sov != null) {
            this.parent.sov.repaint();
        }
        return true;
    }

    long nextProcessingDate(StandingOrder standingOrder) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        this.parent.genericDate.setTime(standingOrder.longStartDate);
        calendar.setTime(this.parent.genericDate);
        this.parent.genericDate.setTime(standingOrder.longProcessingDate);
        calendar2.setTime(this.parent.genericDate);
        if (standingOrder.period == 0) {
            int n = calendar2.get(1);
            calendar2.set(1, n += standingOrder.interval);
        }
        if (standingOrder.period == 1) {
            calendar2 = this.addMonth(calendar2, calendar, standingOrder.interval);
        }
        if (standingOrder.period == 2) {
            calendar2 = this.addDay(calendar2, standingOrder.interval);
        }
        return calendar2.getTime().getTime();
    }

    boolean checkStandingOrders(long l) {
        long l2 = Utilities.longToDays(l);
        int n = this.getNumStandingOrders();
        for (int i = 0; i < n; ++i) {
            StandingOrder standingOrder = this.getStandingOrderFromIndex(i);
            long l3 = Utilities.longToDays(standingOrder.longProcessingDate);
            if (l3 > l2) continue;
            return true;
        }
        return false;
    }

    void updateAccountTotal1(Account account) {
        if (this.parent.av != null) {
            this.parent.av.totalCurrent -= account.current;
            this.parent.av.totalToday -= account.today;
            this.parent.av.totalReconciled -= account.reconciled;
        }
    }

    void updateAccountTotal2(Account account) {
        if (this.parent.av != null) {
            this.parent.av.totalCurrent += account.current;
            this.parent.av.totalToday += account.today;
            this.parent.av.totalReconciled += account.reconciled;
            this.parent.av.checkMinMax(account);
        }
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
            this.parent.cv.checkMinMax(category);
        }
    }

    Calendar addMonth(Calendar calendar, Calendar calendar2, int n) {
        int n2;
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        int n5 = n2 = calendar2.get(5);
        if ((n4 += n) > 11) {
            n4 -= 12;
            ++n3;
        }
        if (n4 == 3 || n4 == 5 || n4 == 8 || n4 == 10) {
            n5 = Math.min(n5, 30);
        } else if (n4 == 1) {
            n5 = n3 / 4 * 4 == n3 ? Math.min(n5, 29) : Math.min(n5, 28);
        }
        calendar.set(1, n3);
        calendar.set(2, n4);
        calendar.set(5, n5);
        return calendar;
    }

    Calendar addDay(Calendar calendar, int n) {
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        n4 += n;
        if (n3 == 0 || n3 == 2 || n3 == 4 || n3 == 6 || n3 == 7 || n3 == 9 || n3 == 11) {
            if (n4 > 31) {
                n4 -= 31;
                ++n3;
            }
        } else if (n3 == 3 || n3 == 5 || n3 == 8 || n3 == 10) {
            if (n4 > 30) {
                n4 -= 30;
                ++n3;
            }
        } else if (n3 == 1) {
            if (n2 / 4 * 4 == n2) {
                if (n4 > 29) {
                    n4 -= 29;
                    ++n3;
                }
            } else if (n4 > 28) {
                n4 -= 28;
                ++n3;
            }
        }
        if (n3 > 11) {
            n3 -= 12;
            ++n2;
        }
        calendar.set(1, n2);
        calendar.set(2, n3);
        calendar.set(5, n4);
        return calendar;
    }

    void compressStandingOrders() {
        try {
            byte[] byArray;
            this.parent.standingOrderHt = new Hashtable();
            this.ht = this.parent.standingOrderHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Temp", (boolean)true);
            RecordEnumeration recordEnumeration = this.getStandingOrders();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeStandingOrderStore();
            RecordStore.deleteRecordStore((String)"StandingOrders");
            this.openStandingOrderStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                StandingOrder standingOrder = this.fromByteArray(byArray);
                standingOrder.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(standingOrder);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"Temp");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos9");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " sos10");
            return 0;
        }
    }
}

