/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.AccountView;
import JabpLite.JabpLite;
import JabpLite.StandingOrderStore;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class FutureBalance
extends Canvas
implements CommandListener {
    boolean start = true;
    Display display;
    Date date;
    DateField df;
    Form f1;
    Font font;
    JabpLite parent;
    ChoiceGroup cgAccount;
    int width;
    int height;
    int chosenAccount;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalAmount;

    public FutureBalance(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.okCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.fontHeight;
    }

    void getFutureDate() {
        this.f1 = new Form("\u0411\u0443\u0434\u0443\u0449\u0438\u0439 \u0411\u0430\u043b\u0430\u043d\u0441");
        this.f1.addCommand(this.parent.okCommand);
        this.f1.setCommandListener((CommandListener)this);
        this.df = new DateField("\u0414\u0430\u0442\u0430", 1);
        this.df.setDate(new Date());
        this.f1.append((Item)this.df);
        this.cgAccount = new ChoiceGroup("\u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u044c", 1);
        AccountStore accountStore = new AccountStore(this.parent);
        int n = accountStore.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            this.cgAccount.append(account.name, null);
        }
        this.cgAccount.append("\u0412\u0441\u0435 \u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u0438", null);
        this.f1.append((Item)this.cgAccount);
        accountStore.closeAccountStore();
        accountStore = null;
        this.display.setCurrent((Displayable)this.f1);
    }

    public void paint(Graphics graphics) {
        if (this.start) {
            this.getFutureDate();
            this.start = false;
        } else {
            this.height = this.getHeight() - this.parent.heightAdjustment;
            graphics.setFont(this.font);
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        }
    }

    void showPage(Graphics graphics) {
        Object object;
        this.currentY = this.fontHeight;
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        AccountStore accountStore = new AccountStore(this.parent);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = accountStore.getNumAccounts();
        String string = "";
        for (int i = 0; i < n4; ++i) {
            object = accountStore.getAccountFromIndex(i);
            if (this.chosenAccount != i && this.chosenAccount != n4) continue;
            n += ((Account)object).today;
            if (this.chosenAccount != i) continue;
            string = ((Account)object).name;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        n2 = transactionStore.futureTransactions(this.date, string);
        transactionStore.closeTransactionStore();
        transactionStore = null;
        object = new StandingOrderStore(this.parent);
        n3 = ((StandingOrderStore)object).futureStandingOrders(this.date, string);
        ((StandingOrderStore)object).closeStandingOrderStore();
        object = null;
        this.totalAmount = n + n2 + n3;
        this.buildLine(graphics, "\u0421\u0435\u0433\u043e\u0434\u043d.\u0411\u0430\u043b\u0430\u043d\u0441", n);
        this.buildLine(graphics, "\u0411\u0443\u0434\u0443\u0449\u0438\u0435 \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", n2);
        this.buildLine(graphics, "\u0411\u0443\u0434\u0443\u0449\u0438\u0435 \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f", n3);
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0411\u0443\u0434\u0443\u0449\u0438\u0439 \u0411\u0430\u043b\u0430\u043d\u0441", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", this.amountPosition + this.numberWidth - this.font.stringWidth("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e"), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0411\u0430\u043b\u0430\u043d\u0441 \u043d\u0430 " + this.setDate(this.date), this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalAmount, false);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void buildLine(Graphics graphics, String string, int n) {
        this.currentY += this.fontHeight;
        graphics.drawString(string, this.parent.widthAdjustment, this.currentY + this.parent.fontAdjustment, 20);
        String string2 = Utilities.numberToString(n, false);
        graphics.drawString(string2, this.amountPosition + this.numberWidth - this.font.stringWidth(string2), this.currentY + this.parent.fontAdjustment, 20);
        this.currentY += this.fontHeight;
    }

    void setPositions() {
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    String setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = "" + calendar.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = calendar.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        return string + "/" + string2;
    }

    protected void showNotify() {
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent, this.display);
            }
            this.display.setCurrent((Displayable)this.parent.av);
        }
        if (displayable == this.f1 && command == this.parent.okCommand) {
            this.date = this.df.getDate();
            this.chosenAccount = this.cgAccount.getSelectedIndex();
            this.display.setCurrent((Displayable)this);
        }
    }
}

