/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.DateId;
import JabpLite.JabpLite;
import JabpLite.Split;
import JabpLite.SplitStore;
import JabpLite.Transaction;
import JabpLite.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TransactionStore {
    Account a;
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;
    OutputStream os;

    public TransactionStore(JabpLite jabpLite, Account account) {
        this.parent = jabpLite;
        this.a = account;
        this.openTransactionStore();
        this.getIndex(this.a);
    }

    void openTransactionStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts1");
        }
    }

    void closeTransactionStore() {
        if (this.rs == null) {
            return;
        }
        this.setIndex(this.a);
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts2");
        }
    }

    int getNumTransactions() {
        return this.ht.size();
    }

    int getNumAllTransactions() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts3");
            return 0;
        }
    }

    RecordEnumeration getTransactions() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts6");
            return null;
        }
    }

    byte[] toByteArray(Transaction transaction) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(transaction.account);
            dataOutputStream.writeLong(transaction.date.getTime());
            dataOutputStream.writeUTF(transaction.description);
            dataOutputStream.writeInt(transaction.amount);
            dataOutputStream.writeUTF(transaction.reference);
            dataOutputStream.writeUTF(transaction.category);
            dataOutputStream.writeBoolean(transaction.reconciled);
            dataOutputStream.writeBoolean(transaction.transferFlag);
            if (transaction.transferFlag) {
                dataOutputStream.writeUTF(transaction.transferAccount);
                dataOutputStream.writeInt(transaction.transferAccountId);
            }
            dataOutputStream.writeBoolean(transaction.splitFlag);
            if (transaction.splitFlag) {
                dataOutputStream.writeInt(transaction.ss.size());
                for (int i = 0; i < transaction.ss.size(); ++i) {
                    Split split = transaction.ss.getSplit(i);
                    dataOutputStream.writeInt(split.amount);
                    dataOutputStream.writeUTF(split.category);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Transaction fromByteArray(byte[] byArray) {
        Transaction transaction = new Transaction();
        Calendar calendar = Calendar.getInstance();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            transaction.account = dataInputStream.readUTF();
            transaction.date = new Date(dataInputStream.readLong());
            transaction.description = dataInputStream.readUTF();
            transaction.amount = dataInputStream.readInt();
            transaction.reference = dataInputStream.readUTF();
            transaction.category = dataInputStream.readUTF();
            transaction.reconciled = dataInputStream.readBoolean();
            transaction.transferFlag = dataInputStream.readBoolean();
            if (transaction.transferFlag) {
                transaction.transferAccount = dataInputStream.readUTF();
                transaction.transferAccountId = dataInputStream.readInt();
            }
            transaction.splitFlag = dataInputStream.readBoolean();
            if (transaction.splitFlag) {
                transaction.ss = new SplitStore();
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    Split split = new Split();
                    split.amount = dataInputStream.readInt();
                    split.category = dataInputStream.readUTF();
                    transaction.ss.addSplit(split);
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " ts4a");
        }
        return transaction;
    }

    Transaction getTransaction(int n) {
        Transaction transaction = new Transaction();
        try {
            byte[] byArray = this.rs.getRecord(n);
            transaction = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts4 record " + n);
            return null;
        }
        transaction.id = n;
        return transaction;
    }

    Transaction getTransactionFromIndex(int n) {
        short s = (short)n;
        int n2 = ((DateId)this.ht.get((Object)new Short((short)s))).id;
        return this.getTransaction(n2);
    }

    void deleteTransaction(Transaction transaction) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(transaction.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts5");
        }
    }

    int saveNewTransaction(Transaction transaction) {
        if (this.rs == null) {
            return 0;
        }
        try {
            transaction.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(transaction);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts7");
        }
        this.addIndex(transaction);
        return transaction.id;
    }

    void saveExistingTransaction(Transaction transaction) {
        if (this.rs == null) {
            return;
        }
        if (transaction.id == 0) {
            System.out.println("Id error in saveExistingTransaction()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(transaction);
            this.rs.setRecord(transaction.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts7a");
        }
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            DateId dateId = (DateId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), dateId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(Transaction transaction) {
        DateId dateId;
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        long l = Utilities.calcDate(transaction.date);
        for (n = 0; n < n2; ++n) {
            DateId dateId2 = (DateId)this.ht.get(new Short((short)n));
            if (l < Utilities.calcDate(dateId2.date)) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                dateId = (DateId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), dateId);
            }
        }
        long l2 = transaction.date.getTime();
        dateId = new DateId(new Date(l2), transaction.id);
        this.ht.put(new Short((short)n3), dateId);
    }

    void deleteIndex(Transaction transaction) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = i;
            DateId dateId = (DateId)this.ht.get(new Short((short)i));
            if (transaction.id == dateId.id) break;
        }
        this.deleteIndex(n2);
    }

    void getIndex(Account account) {
        this.ht = this.parent.transactionHt.containsKey(account.name) ? (Hashtable)this.parent.transactionHt.get(account.name) : new Hashtable();
    }

    void setIndex(Account account) {
        if (!account.name.equals("")) {
            this.parent.transactionHt.put(account.name, this.ht);
        }
    }

    int futureTransactions(Date date, String string) {
        int n = 0;
        long l = Utilities.calcDate(date);
        long l2 = Utilities.calcDate(new Date());
        AccountStore accountStore = new AccountStore(this.parent);
        int n2 = accountStore.getNumAccounts();
        block0: for (int i = 0; i < n2; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            if (!string.equals("") && !string.equals(this.a.name)) continue;
            this.getIndex(account);
            int n3 = this.ht.size();
            for (int j = 0; j < n3; ++j) {
                DateId dateId = (DateId)this.ht.get(new Short((short)j));
                long l3 = Utilities.calcDate(dateId.date);
                if (l3 <= l2) continue block0;
                if (l3 > l) continue;
                Transaction transaction = this.getTransaction(dateId.id);
                n += transaction.amount;
            }
        }
        accountStore.closeAccountStore();
        accountStore = null;
        return n;
    }

    void compressTransactions() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        Account account = new Account();
        try {
            Object object;
            byte[] byArray;
            this.parent.transactionHt = new Hashtable();
            AccountStore accountStore = new AccountStore(this.parent);
            int n = accountStore.getNumAccounts();
            for (int i = 0; i < n; ++i) {
                this.parent.transactionHt.put(accountStore.getAccountFromIndex((int)i).name, new Hashtable());
            }
            accountStore.closeAccountStore();
            accountStore = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)"\u0412\u0440\u0435\u043c\u0435\u043d\u043d.", (boolean)true);
            RecordEnumeration recordEnumeration = this.getTransactions();
            int n2 = 0;
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
                if (++n2 != n2 / 100 * 100) continue;
                this.parent.av.msg = n2 + " transactions pass 1 of 2";
                this.parent.av.repaint();
                this.parent.av.serviceRepaints();
            }
            this.closeTransactionStore();
            RecordStore.deleteRecordStore((String)"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f");
            this.openTransactionStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            n2 = 0;
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                object = this.fromByteArray(byArray);
                ((Transaction)object).id = this.rs.addRecord(byArray, 0, byArray.length);
                account.name = ((Transaction)object).account;
                this.getIndex(account);
                this.addIndex((Transaction)object);
                this.setIndex(account);
                if (((Transaction)object).transferFlag) {
                    this.ht = hashtable.containsKey(((Transaction)object).account) ? (Hashtable)hashtable.get(((Transaction)object).account) : new Hashtable();
                    this.addIndex((Transaction)object);
                    hashtable.put(((Transaction)object).account, this.ht);
                }
                if (++n2 != n2 / 100 * 100) continue;
                this.parent.av.msg = n2 + " transactions pass 2 of 2";
                this.parent.av.repaint();
                this.parent.av.serviceRepaints();
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"\u0412\u0440\u0435\u043c\u0435\u043d\u043d.");
            accountStore = new AccountStore(this.parent);
            for (int i = 0; i < n; ++i) {
                object = accountStore.getAccountFromIndex(i);
                this.parent.av.msg = "\u041e\u0431\u044c\u0435\u0434. \u041f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432" + ((Account)object).name;
                this.parent.av.repaint();
                this.parent.av.serviceRepaints();
                if (!hashtable.containsKey(((Account)object).name)) continue;
                this.ht = (Hashtable)hashtable.get(((Account)object).name);
                int n3 = this.ht.size();
                block6: for (int j = 0; j < n3; ++j) {
                    Transaction transaction = this.getTransactionFromIndex(j);
                    if (!hashtable.containsKey(transaction.transferAccount)) continue;
                    Hashtable hashtable2 = (Hashtable)hashtable.get(transaction.transferAccount);
                    int n4 = hashtable2.size();
                    long l = Utilities.calcDate(transaction.date);
                    for (int k = 0; k < n4; ++k) {
                        DateId dateId = (DateId)hashtable2.get(new Short((short)k));
                        if (l == Utilities.calcDate(dateId.date)) {
                            Transaction transaction2 = this.getTransaction(dateId.id);
                            if (transaction.amount == -transaction2.amount) {
                                transaction.transferAccountId = transaction2.id;
                                this.saveExistingTransaction(transaction);
                                continue block6;
                            }
                        }
                        if (l > Utilities.calcDate(dateId.date)) continue block6;
                    }
                }
            }
            accountStore.closeAccountStore();
            accountStore = null;
            hashtable = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts8");
        }
        this.getIndex(this.a);
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts9");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ts10");
            return 0;
        }
    }
}

