/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.screen;

import com.bgate.Algorithm.CheckColisonEgg;
import com.bgate.GameLevel.EndLess;
import com.bgate.GameLevel.GameLevel;
import com.bgate.GameLevel.GameWin;
import com.bgate.GameOver.GameOver;
import com.bgate.ItemBird.ItemMotherBird;
import com.bgate.ItemBom.ItemBomb;
import com.bgate.ItemClock.ItemClock;
import com.bgate.ItemColumn.ItemColumn;
import com.bgate.ItemEgg.ItemBrokenEgg;
import com.bgate.ItemEgg.ItemEgg;
import com.bgate.ItemEgg.ItemPiece;
import com.bgate.ItemEgg.ItemScramblEgg;
import com.bgate.ItemFireWork.ItemFireCracker;
import com.bgate.ItemFireWork.ItemFireWork;
import com.bgate.ItemFoot.ItemFoot;
import com.bgate.ItemMulti.ItemMulti;
import com.bgate.ItemScore.ItemScore;
import com.bgate.ListItem.Arrow;
import com.bgate.ListItem.Bow;
import com.bgate.ListItem.Hand;
import com.bgate.ListItem.LineArrow;
import com.bgate.ListItem.ListEgg;
import com.bgate.ListItem.ListMenu;
import com.bgate.ListItem.LongBow;
import com.bgate.ListItem.Nest;
import com.bgate.core.Screen;
import com.bgate.game.MainGame;
import com.bgate.screen.MenuScreen;
import com.bgate.utils.MessagesSender;
import com.bgate.utils.PiPoDesigner;
import com.bgate.utils.Source;
import com.bgate.utils.StringValues;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends Screen {
    public MainGame game;
    public ListMenu listMenu;
    public ListEgg listEgg;
    public Bow bow;
    public Hand hand;
    public LongBow longBow;
    public LineArrow lineArrow;
    public Nest nest;
    public Arrow arrow;
    public CheckColisonEgg checkColisonEgg;
    public ItemClock clock;
    public ItemFireCracker itemFireCracker;
    public ItemMotherBird itemMotherBird;
    public ItemBomb itemBom;
    public EndLess endLess;
    public static GameOver gameOver;
    public ItemScore itemScore;
    public ItemColumn itemColumn;
    private ItemFoot itemFoot;
    private GameWin gameWin;
    private GameLevel gameLevel;
    private ItemEgg itemEgg;
    private Random random;
    public static Vector vectorGameLevel;
    public Graphics g;
    private int numberPause;
    private int keyCode;
    private int keyState;
    private int countGameOver;
    private int countWin;
    private int countFootWin;
    private int countColumnFoot;
    public static int isRunningGame;
    public static boolean isUpdate;
    public static boolean isRunningEndless;
    public static boolean stategameOver;
    private int updateWin;
    private int updateLevel;
    private String stringOK;
    private String stringCancel;
    public MessagesSender messagesSender;
    public boolean activeLevel = false;
    public boolean buyLive = false;
    public boolean activeEndless = false;
    public int isDialog = 0;
    public int isChooseLevel = 1;
    public int countSms;
    public static int stateDialog;
    public int liveEndless = 0;
    public boolean stateOverEndless = false;
    public static boolean isShowDiaglog;
    private int yDia = 0;

    public GameScreen(MainGame game) {
        super(game);
        this.game = game;
        this.messagesSender = new MessagesSender(this, null);
        this.init();
    }

    public void init() {
        this.initObject();
    }

    public void initObject() {
        vectorGameLevel = new Vector();
        this.endLess = new EndLess();
        this.gameLevel = new GameLevel();
        if (MenuScreen.stateLevel) {
            switch (MenuScreen.chooseLevel) {
                case 1: {
                    GameLevel.level = 1;
                    break;
                }
                case 2: {
                    GameLevel.level = 10;
                    break;
                }
                case 3: {
                    GameLevel.level = 19;
                }
            }
        }
        this.listMenu = new ListMenu();
        this.itemEgg = new ItemEgg();
        this.bow = new Bow();
        this.hand = new Hand();
        this.longBow = new LongBow();
        this.nest = new Nest();
        this.listEgg = new ListEgg();
        this.arrow = new Arrow();
        this.lineArrow = new LineArrow();
        this.clock = new ItemClock();
        this.itemFireCracker = new ItemFireCracker();
        this.itemMotherBird = new ItemMotherBird();
        this.itemBom = new ItemBomb();
        gameOver = new GameOver();
        this.itemScore = new ItemScore();
        this.itemColumn = new ItemColumn();
        this.gameWin = new GameWin();
        if (MenuScreen.stateLevel) {
            this.gameLevel.update();
        }
        this.checkColisonEgg = new CheckColisonEgg();
        this.checkColisonEgg.init();
        this.itemFoot = new ItemFoot();
        this.random = new Random();
        isRunningGame = 0;
        this.countGameOver = 0;
        this.countWin = 0;
        this.countFootWin = 0;
        this.updateLevel = 0;
        this.countColumnFoot = 0;
        this.countSms = 0;
        isRunningEndless = false;
        this.activeLevel = false;
        this.stringOK = "OK";
        this.stringCancel = "Cancel";
    }

    public void update() {
        block16: {
            block17: {
                if (MenuScreen.stateMenu) break block16;
                if (GameScreen.gameOver.stateGameOver) break block17;
                this.stateOverEndless = false;
                this.keyState = this.game.getKeyStates();
                ++isRunningGame;
                this.arrow.update(this.keyState);
                if (Arrow.indexArrow >= 9) {
                    if (Arrow.indexArrow <= 21) {
                        this.bow.update(this.keyState);
                    }
                }
                if (!CheckColisonEgg.stateIsRunning) {
                    CheckColisonEgg.updateEggFixed();
                }
                this.hand.update(this.keyState);
                this.lineArrow.update(this.keyState);
                this.hand.updateFireHand(this.keyState);
                if (MenuScreen.stateEndLess) {
                    if (ItemClock.isClock) {
                        this.clock.update();
                    }
                    this.itemMotherBird.update();
                    this.itemBom.update(this.keyState);
                    this.itemBom.updateUpEgg();
                }
                this.checkColisonEgg.update(this.keyState);
                this.listEgg.update(this.keyState);
                gameOver.checkGameOver();
                this.itemScore.update();
                if (!MenuScreen.stateEndLess) {
                    this.itemColumn.update();
                }
                this.updateBoard();
                this.listMenu.update();
                if (!this.gameWin.checkWin()) {
                    this.updateWin = 0;
                }
                if (!MenuScreen.stateLevel || !this.gameWin.checkWin()) break block16;
                ++this.countFootWin;
                ++this.countColumnFoot;
                if (this.countColumnFoot >= 3) {
                    this.countColumnFoot = 0;
                    if (ItemColumn.countColumn > 0) {
                        --ItemColumn.countColumn;
                    }
                }
                if (this.countFootWin >= 5) {
                    this.gameWin.update();
                }
                ++this.countWin;
                if (this.countWin < 35) break block16;
                this.countWin = 0;
                if (ItemFoot.footY != Source.FOOT_Y || this.updateWin != 0) break block16;
                this.updateGameWin();
                ++this.updateLevel;
                this.updateWin = 1;
                if (this.updateLevel < 10) break block16;
                this.updateLevel = 0;
                this.updateWin = 0;
                this.countWin = 0;
                this.countFootWin = 0;
                break block16;
            }
            if (!this.stateOverEndless && MenuScreen.stateEndLess) {
                this.stateOverEndless = true;
                ++this.game.userInfo.liveEndless;
                this.game.userInfo.saveGameEndless(this.game.userInfo.liveEndless);
            }
            ++this.countGameOver;
            if (this.countGameOver >= 8) {
                if (ItemFoot.footY < 310) {
                    this.updateGameOver();
                    gameOver.update();
                }
            }
            if (MenuScreen.stateLevel && this.itemFoot != null && ItemFoot.footY == 310) {
                for (int i = 0; i < Source.ROW_MAX; ++i) {
                    for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                        ItemScramblEgg.fScrambl[i][j] = 0;
                        ItemPiece.fPiece[i][j] = 0;
                    }
                }
            }
        }
    }

    public void updateGameWin() {
        if (stateDialog != 0) {
            ++GameLevel.level;
        }
        this.listEgg.updateLevel();
        this.checkColisonEgg.initLevel();
        this.itemColumn.initLevel();
        this.itemFoot.initLevel();
        if (stateDialog == 0) {
            stateDialog = 1;
        }
    }

    public void updateBoard() {
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (ItemEgg.tab[i][j] != 0) continue;
                ItemFireWork.fFireWork[i][j] = 0;
                ItemMulti.fItemMulti[i][j] = 0;
            }
        }
    }

    public void updateGameOver() {
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                ItemEgg.fTab[i][j] = 0;
                ItemEgg.tabDown[i][j] = 0;
                ItemFireWork.gFireWork[i][j] = 0;
                ItemFireWork.fSaveTransMirror[i][j] = 0;
                int t = this.random.nextInt(2);
                if (t == 0 && ItemEgg.tab[i][j] > 0) {
                    ItemPiece.fPiece[i][j] = 1;
                    ItemBrokenEgg.fBroken[i][j] = ItemEgg.tab[i][j];
                    ItemScramblEgg.fScrambl[i][j] = 1;
                    ItemFireWork.fFireWork[i][j] = 0;
                    ItemEgg.tab[i][j] = 0;
                }
                ItemEgg.tab[i][j] = 0;
            }
        }
    }

    public void presentEndLess(Graphics g) {
        if (isRunningGame <= 15 && MenuScreen.stateEndLess && this.checkGameEndlessActive()) {
            g.setColor(225, 255, 153);
            g.fillRoundRect(22, 110, 205, 100, 20, 20);
            g.setColor(0, 51, 152);
            g.fillRoundRect(23, 111, 205, 98, 20, 20);
            g.setFont(Font.getFont((int)0, (int)0, (int)0));
            PiPoDesigner.drawCenterString(g, "B\u1ea0N \u0110\u01af\u1ee2C CH\u01a0I TH\u1eec 3 L\u1ea6N ", 0, -213436, this.width / 2, this.height / 2 - 40);
        }
    }

    public void drawGameOver(Graphics g) {
        if (ItemFoot.footY == 310 || GameScreen.gameOver.stateGameOver && MenuScreen.stateEndLess && this.checkGameEndlessActive()) {
            g.setColor(225, 255, 153);
            g.fillRoundRect(22, 110, 205, 100, 20, 20);
            g.setColor(0, 51, 152);
            g.fillRoundRect(23, 111, 205, 98, 20, 20);
            g.setFont(Font.getFont((int)0, (int)0, (int)0));
            if (!isShowDiaglog) {
                if (MenuScreen.stateLevel) {
                    PiPoDesigner.drawCenterString(g, "B\u1ea0N C\u00d3 MU\u1ed0N TI\u1ebeP T\u1ee4C KH\u00d4NG ? ", 0, -213436, this.width / 2, this.height / 2 - 40);
                    PiPoDesigner.drawCenterString(g, "OK", 0, -213436, this.width / 2, this.height / 2 - 15);
                    PiPoDesigner.drawCenterString(g, "CANCEL", 0, -213436, this.width / 2, this.height / 2);
                    PiPoDesigner.drawCenterString(g, "\u0110I\u1ec0U KHO\u1ea2N", 0, -213436, this.width / 2, this.height / 2 + 15);
                } else if (this.checkGameEndlessActive()) {
                    PiPoDesigner.drawCenterString(g, "K\u00cdCH HO\u1ea0T \u0110\u1ec2 CH\u01a0I PH\u1ea6N ENDLESS ? ", 5, -213436, this.width / 2, this.height / 2 - 40);
                    PiPoDesigner.drawCenterString(g, "OK", 0, -213436, this.width / 2, this.height / 2 - 15);
                    PiPoDesigner.drawCenterString(g, "CANCEL", 0, -213436, this.width / 2, this.height / 2);
                }
                if (MenuScreen.stateLevel || this.checkGameEndlessActive()) {
                    if (this.isChooseLevel == 1) {
                        PiPoDesigner.drawCenterString(g, "OK", 0, -65536, this.width / 2, this.height / 2 - 15);
                    } else if (this.isChooseLevel == 2) {
                        PiPoDesigner.drawCenterString(g, "CANCEL", 0, -65536, this.width / 2, this.height / 2);
                    } else if (this.isChooseLevel == 3) {
                        PiPoDesigner.drawCenterString(g, "\u0110I\u1ec0U KHO\u1ea2N", 0, -65536, this.width / 2, this.height / 2 + 15);
                    }
                }
            } else {
                g.setClip((this.width - 190) / 2, (this.height - 90) / 2, 190, 90);
                PiPoDesigner.drawString(g, StringValues.rebirth, 0, -213436, (this.width - 190) / 2, this.yDia, 190, 90);
                g.setClip(0, 0, this.width, this.height);
            }
        }
    }

    public boolean checkGameEndlessActive() {
        return false;
    }

    public void switchScreen() {
    }

    public void present(Graphics g) {
        if (!MenuScreen.stateMenu) {
            this.g = g;
            if (!GameScreen.gameOver.stateGameOver) {
                this.presentGamePlay(g);
                this.presentGameWin(g);
            } else {
                this.presentGameOver(g);
            }
        }
    }

    public void presentGamePlay(Graphics g) {
        this.listMenu.presentBackground(g);
        this.arrow.presentArrow(g);
        this.lineArrow.presentLineArrow(g);
        this.listEgg.initListEgg(g);
        this.listMenu.presentRope(g);
        this.longBow.presentLongBow(g);
        this.nest.presentMouthNest(g);
        this.listEgg.initCurrentEgg(g);
        this.listEgg.initNewNextEgg(g);
        if (MenuScreen.stateEndLess) {
            this.itemBom.presentBomb(g);
        }
        this.bow.present(g);
        if (MenuScreen.stateEndLess) {
            this.itemBom.presentTank(g);
        }
        this.listEgg.initNextEgg(g);
        this.nest.presentNest(g);
        this.listMenu.presentWall(g);
        this.listMenu.presentString(g);
        if (MenuScreen.stateEndLess) {
            this.itemBom.presentBolt(g);
        }
        this.hand.presentHand(g);
        this.itemMotherBird.present(g);
        if (MenuScreen.stateEndLess) {
            this.clock.present(g);
        }
        this.itemScore.present(g);
        if (!MenuScreen.stateEndLess) {
            this.itemColumn.present(g);
        }
        this.presentEndLess(g);
    }

    public void presentGameWin(Graphics g) {
        if (MenuScreen.stateLevel && this.gameWin.checkWin()) {
            this.listMenu.presentBackground(g);
            this.lineArrow.presentLineArrow(g);
            this.listEgg.initListEgg(g);
            this.listMenu.presentRope(g);
            this.longBow.presentLongBow(g);
            this.nest.presentMouthNest(g);
            this.listEgg.initCurrentEgg(g);
            this.listEgg.initNewNextEgg(g);
            this.bow.present(g);
            this.listEgg.initNextEgg(g);
            this.nest.presentNest(g);
            this.gameWin.present(g);
            this.listMenu.presentWall(g);
            this.listMenu.presentString(g);
            this.arrow.presentArrow(g);
            this.hand.presentHand(g);
            this.gameWin.presentStringWin(g);
            this.itemScore.present(g);
            this.itemColumn.present(g);
        }
    }

    public void presentGameOver(Graphics g) {
        ++this.countSms;
        this.listMenu.presentBackground(g);
        this.longBow.presentLongBow(g);
        this.nest.presentMouthNest(g);
        this.listEgg.initListEgg(g);
        this.hand.presentHand(g);
        gameOver.presentFoot(g);
        this.listMenu.presentRope(g);
        this.listMenu.presentWall(g);
        if (!MenuScreen.stateEndLess) {
            this.itemColumn.present(g);
        }
        gameOver.presentString(g);
        this.itemScore.present(g);
        this.drawGameOver(g);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        this.gameLevel.dispose();
        this.bow.dispose();
        this.hand.dispose();
        this.listEgg.dispose();
        this.arrow.dispose();
        this.clock.dispose();
        this.itemFireCracker.dispose();
        this.itemMotherBird.dispose();
        this.itemBom.dispose();
        vectorGameLevel = null;
        this.endLess = null;
        this.gameLevel = null;
        this.listMenu = null;
        this.bow = null;
        this.hand = null;
        this.longBow = null;
        this.nest = null;
        this.listEgg = null;
        this.arrow = null;
        this.lineArrow = null;
        this.clock = null;
        this.itemFireCracker = null;
        this.itemMotherBird = null;
        this.itemBom = null;
        gameOver = null;
        this.itemScore = null;
        this.itemColumn = null;
        this.gameWin = null;
        this.gameLevel = null;
        this.checkColisonEgg = null;
        this.itemFoot = null;
        this.listEgg = null;
        this.random = null;
    }

    public void handleSms(boolean success) {
        if (success) {
            if (this.activeLevel) {
                GameScreen.gameOver.stateGameOver = false;
                this.gameWin.youWin = false;
                this.updateGameWin();
                ItemEgg.currentEgg = 0;
                ItemFoot.footY = -4;
                ItemEgg.next = 0;
                stateDialog = 0;
                this.activeEndless = true;
                this.game.userInfo.saveGameActive(1);
            }
        } else {
            this.game.setScreen(new MenuScreen(this.game));
        }
    }

    public void upKeyPressed() {
        if (MenuScreen.stateLevel && ItemFoot.footY == 310 || GameScreen.gameOver.stateGameOver && MenuScreen.stateEndLess) {
            if (isShowDiaglog) {
                if (this.yDia + 10 <= (this.height - 90) / 2) {
                    this.yDia += 10;
                }
            } else {
                --this.isChooseLevel;
                if (this.isChooseLevel <= 0) {
                    this.isChooseLevel = 4;
                }
            }
        }
    }

    public void downKeyPressed() {
        if (MenuScreen.stateLevel && ItemFoot.footY == 310 || GameScreen.gameOver.stateGameOver && MenuScreen.stateEndLess) {
            if (isShowDiaglog) {
                if (this.yDia >= (this.height - 90) / 2 - 170) {
                    this.yDia -= 10;
                }
            } else {
                ++this.isChooseLevel;
                if (this.isChooseLevel >= 4) {
                    this.isChooseLevel = 1;
                }
            }
        }
    }

    public void rightKeyPressed() {
    }

    public void leftKeyPressed() {
    }

    public void fireKeyPressed() {
        if (GameScreen.gameOver.stateGameOver && (MenuScreen.stateLevel || MenuScreen.stateEndLess && this.checkGameEndlessActive())) {
            if (!isShowDiaglog) {
                if (this.isChooseLevel == 2) {
                    stateDialog = 0;
                    this.game.setScreen(new MenuScreen(this.game));
                } else if (this.isChooseLevel == 1) {
                    this.messagesSender.sendSms("8538", "GMN9 JAVA REBIRTH", 0);
                    GameScreen.gameOver.stateGameOver = false;
                    this.gameWin.youWin = false;
                    ItemEgg.currentEgg = 0;
                    ItemFoot.footY = -4;
                    ItemEgg.next = 0;
                    stateDialog = 0;
                } else if (this.isChooseLevel == 3) {
                    this.yDia = (this.height - 90) / 2;
                    isShowDiaglog = true;
                }
            } else {
                isShowDiaglog = false;
            }
        }
    }

    public void softKeyLeftPressed() {
        if (!GameScreen.gameOver.stateGameOver) {
            if (this.numberPause % 2 == 0) {
                this.listMenu.stringPause = "Resum";
                this.present(this.g);
                this.game.pause();
            } else {
                this.listMenu.stringPause = "Pause";
                this.game.start();
            }
            ++this.numberPause;
        } else if (GameScreen.gameOver.stateGameOver && GameScreen.gameOver.footY == 0) {
            this.game.myMidlet.notifyDestroyed();
        }
    }

    public void softKeyRightPressed() {
        if (MenuScreen.stateEndLess) {
            this.game.userInfo.saveGameEndless(this.game.userInfo.liveEndless + 1);
        }
        this.game.setScreen(new MenuScreen(this.game));
    }

    public void numberKeyPressed(int keyCode) {
        this.keyCode = this.game.getGameAction(keyCode);
        if (this.keyCode == 9) {
            this.listMenu.stringPause = "Resum";
            this.present(this.g);
            this.game.pause();
        } else if (this.keyCode == 0) {
            this.listMenu.stringPause = "Pause";
            this.game.start();
        } else if (this.keyCode == 10) {
            this.game.myMidlet.notifyDestroyed();
        }
    }

    public void upKeyRealeased() {
    }

    public void downKeyRealeased() {
    }

    public void rightKeyRealeased() {
    }

    public void leftKeyRealeased() {
    }

    public void upKeytRepeated() {
    }

    public void downKeyRepeated() {
    }

    public void rightKeyRepeated() {
    }

    public void leftKeyRepeated() {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    protected void paint(Graphics g) {
    }

    static {
        stateDialog = 1;
        isShowDiaglog = false;
    }
}

