/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.BounceCanvas;
import com.nokia.mid.appl.boun.TileCanvas;
import com.nokia.mid.sound.Sound;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball {
    private boolean mDebugCD = false;
    public int xPos;
    public int yPos;
    public int globalBallX;
    public int globalBallY;
    public int xOffset;
    public int xSpeed;
    public int ySpeed;
    public int direction;
    public int mBallSize;
    public int mHalfBallSize;
    public int respawnX;
    public int respawnY;
    public int respawnSize;
    public int ballState;
    public int jumpOffset;
    public int speedBonusCntr;
    public int gravBonusCntr;
    public int jumpBonusCntr;
    public boolean mGroundedFlag;
    public boolean mCDRubberFlag;
    public boolean mCDRampFlag;
    public int slideCntr;
    public static final byte[][] TRI_TILE_DATA = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    public static final byte[][] SMALL_BALL_DATA = new byte[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    public static final byte[][] LARGE_BALL_DATA = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
    public BounceCanvas mCanvas;
    public Image mBallImage;
    public Image poppedImage;
    public Image largeBallImage;
    public Image smallBallImage;
    private int popCntr;

    public Ball(int n, int n2, int n3, BounceCanvas bounceCanvas) {
        this.xPos = n;
        this.yPos = n2;
        this.globalBallX = 0;
        this.globalBallY = 0;
        this.xSpeed = 0;
        this.ySpeed = 0;
        this.xOffset = 0;
        this.mCanvas = bounceCanvas;
        this.jumpOffset = 0;
        this.mGroundedFlag = false;
        this.mCDRubberFlag = false;
        this.mCDRampFlag = false;
        this.popCntr = 0;
        this.speedBonusCntr = 0;
        this.gravBonusCntr = 0;
        this.jumpBonusCntr = 0;
        this.slideCntr = 0;
        this.ballState = 0;
        this.direction = 0;
        this.mCanvas.setBallImages(this);
        this.mBallSize = n3;
        if (this.mBallSize == 12) {
            this.mHalfBallSize = 6;
            this.mBallImage = this.smallBallImage;
        } else {
            this.mHalfBallSize = 8;
            this.mBallImage = this.largeBallImage;
        }
    }

    public void setRespawn(int n, int n2) {
        this.respawnX = n;
        this.respawnY = n2;
        this.respawnSize = this.mBallSize;
    }

    public void setDirection(int n) {
        if (n == 8 || n == 4 || n == 2 || n == 1) {
            this.direction |= n;
        }
    }

    public void releaseDirection(int n) {
        if (n == 8 || n == 4 || n == 2 || n == 1) {
            this.direction &= ~n;
        }
    }

    public void resetDirections() {
        this.direction &= 0xFFFFFFF0;
    }

    public boolean collisionDetection(int n, int n2) {
        int n3 = 0;
        if (n2 < 0) {
            n3 = 12;
        }
        int n4 = (n - this.mHalfBallSize) / 12;
        int n5 = (n2 - n3 - this.mHalfBallSize) / 12;
        this.globalBallX = n - this.mHalfBallSize;
        this.globalBallY = n2 - this.mHalfBallSize;
        if (this.xPos < this.mCanvas.divisorLine) {
            this.globalBallX += this.mCanvas.tileX * 12;
            this.globalBallY += this.mCanvas.tileY * 12;
        } else {
            this.globalBallX += (this.mCanvas.divTileX - 13) * 12 - this.mCanvas.divisorLine;
            this.globalBallY += this.mCanvas.divTileY * 12;
        }
        int n6 = (n - 1 + this.mHalfBallSize) / 12 + 1;
        int n7 = (n2 - n3 - 1 + this.mHalfBallSize) / 12 + 1;
        boolean bl = true;
        int n8 = n4;
        while (n8 < n6) {
            int n9 = n5;
            while (n9 < n7) {
                if (n8 * 12 > 156) {
                    bl = this.testTile(this.mCanvas.tileY + n9, this.mCanvas.tileX + n8 - 13, bl);
                } else if (this.xPos < this.mCanvas.divisorLine) {
                    bl = this.testTile(this.mCanvas.tileY + n9, this.mCanvas.tileX + n8, bl);
                } else {
                    int n10 = this.mCanvas.divTileX - 13 - this.mCanvas.divisorLine / 12;
                    bl = this.testTile(this.mCanvas.divTileY + n9, n10 + n8, bl);
                }
                ++n9;
            }
            ++n8;
        }
        return bl;
    }

    public void enlargeBall() {
        int n = 2;
        this.mBallSize = 16;
        this.mHalfBallSize = 8;
        this.mBallImage = this.largeBallImage;
        boolean bl = false;
        while (!bl) {
            bl = true;
            if (this.collisionDetection(this.xPos, this.yPos - n)) {
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos - n, this.yPos - n)) {
                this.xPos -= n;
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos + n, this.yPos - n)) {
                this.xPos += n;
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos, this.yPos + n)) {
                this.yPos += n;
                continue;
            }
            if (this.collisionDetection(this.xPos - n, this.yPos + n)) {
                this.xPos -= n;
                this.yPos += n;
                continue;
            }
            if (this.collisionDetection(this.xPos + n, this.yPos + n)) {
                this.xPos += n;
                this.yPos += n;
                continue;
            }
            bl = false;
            ++n;
        }
    }

    public void shrinkBall() {
        int n = 2;
        this.mBallSize = 12;
        this.mHalfBallSize = 6;
        this.mBallImage = this.smallBallImage;
        if (this.collisionDetection(this.xPos, this.yPos + n)) {
            this.yPos += n;
        } else if (this.collisionDetection(this.xPos, this.yPos - n)) {
            this.yPos -= n;
        }
    }

    public void popBall() {
        if (!this.mCanvas.mInvincible) {
            this.popCntr = 5;
            this.ballState = 2;
            this.xOffset = 0;
            --this.mCanvas.numLives;
            this.speedBonusCntr = 0;
            this.gravBonusCntr = 0;
            this.jumpBonusCntr = 0;
            this.mCanvas.mPaintUIFlag = true;
            this.mCanvas.mSoundPop.play(1);
        }
    }

    public void addRing() {
        this.mCanvas.add2Score(500);
        ++this.mCanvas.numRings;
        this.mCanvas.mPaintUIFlag = true;
    }

    public void redirectBall(int n) {
        int n2 = this.xSpeed;
        switch (n) {
            case 35: {
                this.xSpeed = this.xSpeed > -this.ySpeed ? this.xSpeed : this.ySpeed;
                this.ySpeed = n2;
                break;
            }
            case 37: {
                this.xSpeed = -this.xSpeed > this.ySpeed ? this.xSpeed : this.ySpeed;
                this.ySpeed = n2;
                break;
            }
            case 34: {
                this.xSpeed = this.xSpeed < this.ySpeed ? this.xSpeed : -this.ySpeed;
                this.ySpeed = -n2;
                break;
            }
            case 36: {
                this.xSpeed = this.xSpeed > this.ySpeed ? this.xSpeed : -this.ySpeed;
                this.ySpeed = -n2;
                break;
            }
            case 31: {
                this.xSpeed = this.xSpeed > -this.ySpeed ? this.xSpeed : this.ySpeed >> 1;
                this.ySpeed = n2;
                break;
            }
            case 33: {
                this.xSpeed = -this.xSpeed > this.ySpeed ? this.xSpeed : this.ySpeed >> 1;
                this.ySpeed = n2;
                break;
            }
            case 30: {
                this.xSpeed = this.xSpeed < this.ySpeed ? this.xSpeed : -(this.ySpeed >> 1);
                this.ySpeed = -n2;
                break;
            }
            case 32: {
                this.xSpeed = this.xSpeed > this.ySpeed ? this.xSpeed : -(this.ySpeed >> 1);
                this.ySpeed = -n2;
            }
        }
    }

    public boolean squareCollide(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 * 12;
        int n8 = n * 12;
        int n9 = this.globalBallX - n7;
        int n10 = this.globalBallY - n8;
        if (n9 >= 0) {
            n6 = n9;
            n5 = 12;
        } else {
            n6 = 0;
            n5 = this.mBallSize + n9;
        }
        if (n10 >= 0) {
            n4 = n10;
            n3 = 12;
        } else {
            n4 = 0;
            n3 = this.mBallSize + n10;
        }
        byte[][] byArray = this.mBallSize == 16 ? LARGE_BALL_DATA : SMALL_BALL_DATA;
        if (n5 > 12) {
            n5 = 12;
        }
        if (n3 > 12) {
            n3 = 12;
        }
        int n11 = n6;
        while (n11 < n5) {
            int n12 = n4;
            while (n12 < n3) {
                if (byArray[n12 - n10][n11 - n9] != 0) {
                    return true;
                }
                ++n12;
            }
            ++n11;
        }
        return false;
    }

    public boolean triangleCollide(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n2 * 12;
        int n9 = n * 12;
        int n10 = this.globalBallX - n8;
        int n11 = this.globalBallY - n9;
        int n12 = 0;
        int n13 = 0;
        switch (n3) {
            case 30: 
            case 34: {
                n13 = 11;
                n12 = 11;
                break;
            }
            case 31: 
            case 35: {
                n13 = 11;
                break;
            }
            case 33: 
            case 37: {
                n12 = 11;
            }
        }
        if (n10 >= 0) {
            n7 = n10;
            n6 = 12;
        } else {
            n7 = 0;
            n6 = this.mBallSize + n10;
        }
        if (n11 >= 0) {
            n5 = n11;
            n4 = 12;
        } else {
            n5 = 0;
            n4 = this.mBallSize + n11;
        }
        byte[][] byArray = this.mBallSize == 16 ? LARGE_BALL_DATA : SMALL_BALL_DATA;
        if (n6 > 12) {
            n6 = 12;
        }
        if (n4 > 12) {
            n4 = 12;
        }
        int n14 = n7;
        while (n14 < n6) {
            int n15 = n5;
            while (n15 < n4) {
                if ((TRI_TILE_DATA[Math.abs(n15 - n13)][Math.abs(n14 - n12)] & byArray[n15 - n11][n14 - n10]) != 0) {
                    if (!this.mGroundedFlag) {
                        this.redirectBall(n3);
                    }
                    return true;
                }
                ++n15;
            }
            ++n14;
        }
        return false;
    }

    public boolean thinCollide(int n, int n2, int n3) {
        int n4 = n2 * 12;
        int n5 = n * 12;
        int n6 = n4 + 12;
        int n7 = n5 + 12;
        switch (n3) {
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 43: 
            case 45: {
                n4 += 4;
                n6 -= 4;
                break;
            }
            case 4: 
            case 6: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 44: 
            case 46: {
                n5 += 4;
                n7 -= 4;
            }
        }
        return TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4, n5, n6, n7);
    }

    public boolean edgeCollide(int n, int n2, int n3) {
        int n4 = n2 * 12;
        int n5 = n * 12;
        int n6 = n4 + 12;
        int n7 = n5 + 12;
        boolean bl = false;
        switch (n3) {
            case 15: 
            case 19: 
            case 23: 
            case 27: {
                bl = TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4, n5 += 6, n6 -= 11, n7 -= 6);
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                bl = TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4 += 11, n5 += 6, n6, n7 -= 6);
                break;
            }
            case 13: 
            case 17: {
                bl = TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4 += 6, n5, n6 -= 6, n7 -= 11);
                break;
            }
            case 21: 
            case 25: {
                n7 = n5--;
                bl = TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4 += 6, n5, n6 -= 6, n7);
                break;
            }
            case 14: 
            case 18: 
            case 22: 
            case 26: {
                bl = TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n4 += 6, n5 += 11, n6 -= 6, n7);
            }
        }
        return bl;
    }

    public boolean testTile(int n, int n2, boolean bl) {
        if (n >= this.mCanvas.mTileMapHeight || n < 0 || n2 >= this.mCanvas.mTileMapWidth || n2 < 0) {
            bl = false;
            return false;
        }
        if (this.ballState == 2) {
            return false;
        }
        int n3 = this.mCanvas.tileMap[n][n2] & 0x40;
        int n4 = this.mCanvas.tileMap[n][n2] & 0xFFFFFFBF & 0xFFFFFF7F;
        Sound sound = null;
        switch (n4) {
            case 0: 
            case 8: 
            case 26: {
                break;
            }
            case 1: {
                if (this.squareCollide(n, n2)) {
                    bl = false;
                    break;
                }
                this.mCDRampFlag = true;
                break;
            }
            case 2: {
                if (this.squareCollide(n, n2)) {
                    this.mCDRubberFlag = true;
                    bl = false;
                    break;
                }
                this.mCDRampFlag = true;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                if (!this.triangleCollide(n, n2, n4)) break;
                this.mCDRubberFlag = true;
                bl = false;
                this.mCDRampFlag = true;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                if (!this.triangleCollide(n, n2, n4)) break;
                bl = false;
                this.mCDRampFlag = true;
                break;
            }
            case 10: {
                int n5;
                int n6;
                int n7 = this.mCanvas.findSpikeIndex(n2, n);
                if (n7 == -1 || !TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.mBallSize, this.globalBallY + this.mBallSize, n6 = this.mCanvas.mMOTopLeft[n7][0] * 12 + this.mCanvas.mMOOffset[n7][0], n5 = this.mCanvas.mMOTopLeft[n7][1] * 12 + this.mCanvas.mMOOffset[n7][1], n6 + 24, n5 + 24)) break;
                bl = false;
                this.popBall();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!this.thinCollide(n, n2, n4)) break;
                bl = false;
                this.popBall();
                break;
            }
            case 7: {
                this.mCanvas.add2Score(200);
                this.mCanvas.tileMap[this.respawnY][this.respawnX] = 128;
                this.setRespawn(n2, n);
                this.mCanvas.tileMap[n][n2] = 136;
                sound = this.mCanvas.mSoundPickup;
                break;
            }
            case 23: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x9B | n3);
                this.mCanvas.tileMap[n][n2 + 1] = (short)(0x9C | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 15: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mBallSize == 16) {
                    bl = false;
                    break;
                }
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x93 | n3);
                this.mCanvas.tileMap[n][n2 + 1] = (short)(0x94 | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 24: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x9C | n3);
                this.mCanvas.tileMap[n][n2 - 1] = (short)(0x9B | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 16: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mBallSize == 16) {
                    bl = false;
                    break;
                }
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x94 | n3);
                this.mCanvas.tileMap[n][n2 - 1] = (short)(0x93 | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 21: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x99 | n3);
                this.mCanvas.tileMap[n + 1][n2] = (short)(0x9A | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 13: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mBallSize == 16) {
                    bl = false;
                    break;
                }
                if (this.edgeCollide(n, n2, n4)) {
                    bl = false;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x91 | n3);
                this.mCanvas.tileMap[n + 1][n2] = (short)(0x92 | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 22: {
                if (!this.thinCollide(n, n2, n4)) break;
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x9A | n3);
                this.mCanvas.tileMap[n - 1][n2] = (short)(0x99 | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 14: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mBallSize == 16) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.mCanvas.tileMap[n][n2] = (short)(0x92 | n3);
                this.mCanvas.tileMap[n - 1][n2] = (short)(0x91 | n3);
                sound = this.mCanvas.mSoundHoop;
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mBallSize == 16) {
                    bl = false;
                    break;
                }
                if (!this.edgeCollide(n, n2, n4)) break;
                bl = false;
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                if (!this.edgeCollide(n, n2, n4)) break;
                bl = false;
                break;
            }
            case 18: {
                if (!this.thinCollide(n, n2, n4) || this.mBallSize != 16) break;
                bl = false;
                break;
            }
            case 9: {
                if (!this.thinCollide(n, n2, n4)) break;
                if (this.mCanvas.mOpenFlag) {
                    this.mCanvas.mLeaveGame = true;
                    sound = this.mCanvas.mSoundPickup;
                    break;
                }
                bl = false;
                break;
            }
            case 29: {
                this.mCanvas.add2Score(1000);
                if (this.mCanvas.numLives < 5) {
                    ++this.mCanvas.numLives;
                    this.mCanvas.mPaintUIFlag = true;
                }
                this.mCanvas.tileMap[n][n2] = 128;
                sound = this.mCanvas.mSoundPickup;
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                bl = false;
                if (this.mBallSize != 16) break;
                this.shrinkBall();
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (!this.thinCollide(n, n2, n4)) break;
                bl = false;
                if (this.mBallSize != 12) break;
                this.enlargeBall();
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.gravBonusCntr = 300;
                sound = this.mCanvas.mSoundPickup;
                bl = false;
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this.jumpBonusCntr = 300;
                sound = this.mCanvas.mSoundPickup;
                bl = false;
                break;
            }
            case 38: {
                this.speedBonusCntr = 300;
                sound = this.mCanvas.mSoundPickup;
                bl = false;
            }
        }
        if (sound != null) {
            sound.play(1);
        }
        return bl;
    }

    public void update() {
        int n;
        int n2;
        int n3 = this.xPos;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (this.ballState == 2) {
            this.xOffset = 0;
            --this.popCntr;
            if (this.popCntr == 0) {
                this.ballState = 1;
                if (this.mCanvas.numLives < 0) {
                    this.mCanvas.mLeaveGame = true;
                }
            }
            return;
        }
        int n7 = this.xPos / 12;
        int n8 = this.yPos / 12;
        if (this.xPos >= 156) {
            n7 = this.mCanvas.tileX + n7 - 13;
            n8 = this.mCanvas.tileY + n8;
        } else if (this.xPos < this.mCanvas.divisorLine) {
            n7 = this.mCanvas.tileX + n7;
            n8 = this.mCanvas.tileY + n8;
        } else {
            n7 = this.mCanvas.divTileX - 13 - this.mCanvas.divisorLine / 12 + n7;
            n8 = this.mCanvas.divTileY + n8;
        }
        if ((this.mCanvas.tileMap[n8][n7] & 0x40) != 0) {
            if (this.mBallSize == 16) {
                n5 = -30;
                n4 = -2;
                if (this.mGroundedFlag) {
                    this.ySpeed = -10;
                }
            } else {
                n5 = 42;
                n4 = 6;
            }
        } else if (this.mBallSize == 16) {
            n5 = 38;
            n4 = 3;
        } else {
            n5 = 80;
            n4 = 4;
        }
        if (this.gravBonusCntr != 0) {
            bl = true;
            n5 *= -1;
            n4 *= -1;
            --this.gravBonusCntr;
            if (this.gravBonusCntr == 0) {
                bl = false;
                this.mGroundedFlag = false;
                n5 *= -1;
                n4 *= -1;
            }
        }
        if (this.jumpBonusCntr != 0) {
            if (-1 * Math.abs(this.jumpOffset) > -80) {
                this.jumpOffset = bl ? 80 : -80;
            }
            --this.jumpBonusCntr;
        }
        ++this.slideCntr;
        if (this.slideCntr == 3) {
            this.slideCntr = 0;
        }
        if (this.ySpeed < -150) {
            this.ySpeed = -150;
        } else if (this.ySpeed > 150) {
            this.ySpeed = 150;
        }
        if (this.xSpeed < -150) {
            this.xSpeed = -150;
        } else if (this.xSpeed > 150) {
            this.xSpeed = 150;
        }
        int n9 = 0;
        while (n9 < Math.abs(this.ySpeed) / 10) {
            n2 = 0;
            if (this.ySpeed != 0) {
                int n10 = n2 = this.ySpeed < 0 ? -1 : 1;
            }
            if (this.collisionDetection(this.xPos, this.yPos + n2)) {
                this.yPos += n2;
                this.mGroundedFlag = false;
                if (n5 == -30 && (this.mCanvas.tileMap[n8 = this.mCanvas.tileY + this.yPos / 12][n7] & 0x40) == 0) {
                    this.ySpeed >>= 1;
                    if (this.ySpeed <= 10 && this.ySpeed >= -10) {
                        this.ySpeed = 0;
                    }
                }
            } else {
                if (this.mCDRampFlag && this.xSpeed < 10 && this.slideCntr == 0) {
                    n = 1;
                    if (this.collisionDetection(this.xPos + n, this.yPos + n2)) {
                        this.xPos += n;
                        this.yPos += n2;
                        this.mCDRampFlag = false;
                    } else if (this.collisionDetection(this.xPos - n, this.yPos + n2)) {
                        this.xPos -= n;
                        this.yPos += n2;
                        this.mCDRampFlag = false;
                    }
                }
                if (n2 > 0 || bl && n2 < 0) {
                    this.ySpeed = this.ySpeed * -1 / 2;
                    this.mGroundedFlag = true;
                    if (this.mCDRubberFlag && (this.direction & 8) != 0) {
                        this.mCDRubberFlag = false;
                        this.jumpOffset = bl ? (this.jumpOffset += 10) : (this.jumpOffset += -10);
                    } else if (this.jumpBonusCntr == 0) {
                        this.jumpOffset = 0;
                    }
                    if (this.ySpeed >= 10 || this.ySpeed <= -10) break;
                    if (bl) {
                        this.ySpeed = -10;
                        break;
                    }
                    this.ySpeed = 10;
                    break;
                }
                if (n2 < 0 || bl && n2 > 0) {
                    this.ySpeed = bl ? -20 : -this.ySpeed >> 1;
                }
            }
            ++n9;
        }
        if (bl) {
            if (n4 == -2 && this.ySpeed < n5) {
                this.ySpeed += n4;
                if (this.ySpeed > n5) {
                    this.ySpeed = n5;
                }
            } else if (!this.mGroundedFlag && this.ySpeed > n5) {
                this.ySpeed += n4;
                if (this.ySpeed < n5) {
                    this.ySpeed = n5;
                }
            }
        } else if (n4 == -2 && this.ySpeed > n5) {
            this.ySpeed += n4;
            if (this.ySpeed < n5) {
                this.ySpeed = n5;
            }
        } else if (!this.mGroundedFlag && this.ySpeed < n5) {
            this.ySpeed += n4;
            if (this.ySpeed > n5) {
                this.ySpeed = n5;
            }
        }
        if (this.speedBonusCntr != 0) {
            n6 = 100;
            --this.speedBonusCntr;
        } else {
            n6 = 50;
        }
        if ((this.direction & 2) != 0 && this.xSpeed < n6) {
            this.xSpeed += 6;
        } else if ((this.direction & 1) != 0 && this.xSpeed > -n6) {
            this.xSpeed -= 6;
        } else if (this.xSpeed > 0) {
            this.xSpeed -= 4;
        } else if (this.xSpeed < 0) {
            this.xSpeed += 4;
        }
        if (this.mBallSize == 16 && this.jumpBonusCntr == 0) {
            this.jumpOffset = bl ? (this.jumpOffset += 5) : (this.jumpOffset += -5);
        }
        if (this.mGroundedFlag && (this.direction & 8) != 0) {
            this.ySpeed = bl ? 67 + this.jumpOffset : -67 + this.jumpOffset;
            this.mGroundedFlag = false;
        }
        n2 = Math.abs(this.xSpeed);
        n = n2 / 10;
        int n11 = 0;
        while (n11 < n) {
            int n12 = 0;
            if (this.xSpeed != 0) {
                int n13 = n12 = this.xSpeed < 0 ? -1 : 1;
            }
            if (this.collisionDetection(this.xPos + n12, this.yPos)) {
                this.xPos += n12;
            } else if (this.mCDRampFlag) {
                this.mCDRampFlag = false;
                int n14 = 0;
                n14 = bl ? 1 : -1;
                if (this.collisionDetection(this.xPos + n12, this.yPos + n14)) {
                    this.xPos += n12;
                    this.yPos += n14;
                } else if (this.collisionDetection(this.xPos + n12, this.yPos - n14)) {
                    this.xPos += n12;
                    this.yPos -= n14;
                } else {
                    this.xSpeed = -(this.xSpeed >> 1);
                }
            }
            ++n11;
        }
        this.xOffset = this.xPos - n3;
        if (this.xPos > 156 + this.mBallSize) {
            this.xPos -= 156;
            if (this.mCanvas.scrollOffset - 10 > 156 + this.mBallSize) {
                this.mCanvas.scrollOffset -= 156;
            }
        }
        if (this.xPos - this.mBallSize < 0) {
            this.xPos += 156;
            if (this.mCanvas.scrollOffset - this.mBallSize < 10) {
                this.mCanvas.scrollOffset += 156;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.ballState == 2) {
            graphics.drawImage(this.poppedImage, this.xPos - 6, this.yPos - 6, 20);
            if (this.xPos > 144) {
                graphics.drawImage(this.poppedImage, this.xPos - 156 - 6, this.yPos - 6, 20);
            }
        } else {
            graphics.drawImage(this.mBallImage, this.xPos - this.mHalfBallSize, this.yPos - this.mHalfBallSize, 20);
            if (this.xPos > 156 - this.mBallSize) {
                graphics.drawImage(this.mBallImage, this.xPos - 156 - this.mHalfBallSize, this.yPos - this.mHalfBallSize, 20);
            }
        }
        this.dirtyTiles();
    }

    public void dirtyTiles() {
        int n = (this.xPos - this.mHalfBallSize) / 12;
        int n2 = (this.yPos - this.mHalfBallSize) / 12;
        int n3 = (this.xPos - 1 + this.mHalfBallSize) / 12 + 1;
        int n4 = (this.yPos - 1 + this.mHalfBallSize) / 12 + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > 8) {
            n4 = 8;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        while (n7 < n3) {
            int n8 = n2;
            while (n8 < n4) {
                if (n7 * 12 >= 156) {
                    n5 = this.mCanvas.tileX + n7 - 13;
                    n6 = this.mCanvas.tileY + n8;
                } else if (this.xPos < this.mCanvas.divisorLine) {
                    n5 = this.mCanvas.tileX + n7;
                    n6 = this.mCanvas.tileY + n8;
                } else {
                    n5 = this.mCanvas.divTileX - 13 - this.mCanvas.divisorLine / 12 + n7;
                    n6 = this.mCanvas.divTileY + n8;
                }
                short[] sArray = this.mCanvas.tileMap[n6];
                int n9 = n5;
                sArray[n9] = (short)(sArray[n9] | 0x80);
                ++n8;
            }
            ++n7;
        }
    }
}

