/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.Ball;
import com.nokia.mid.appl.boun.BounceUI;
import com.nokia.mid.appl.boun.TileCanvas;
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BounceCanvas
extends TileCanvas {
    public int mSplashIndex;
    public Image mSplashImage;
    private int mSplashTimer;
    protected Sound mSoundHoop;
    protected Sound mSoundPickup;
    protected Sound mSoundPop;
    private BounceUI mUI;
    public Ball mBall;
    public int numRings;
    public int numLives;
    public int mScore;
    public int bonusCntrValue;
    public int mLevelDisCntr;
    public boolean mLeaveGame;
    public boolean mOpenExitFlag;
    public boolean mPaintUIFlag;
    public final Font TEXT_FONT = Font.getFont((int)32, (int)0, (int)8);
    public Image mFullScreenBuffer;
    public Graphics mFullScreenGraphics = null;
    public boolean mClearScreenFlag;
    private boolean mCheat = false;
    public boolean mInvincible = false;
    private int mCheatSeq = 0;
    private static final String[] SPLASH_NAME = new String[]{"/icons/nokiagames.png", "/icons/bouncesplash.png"};
    public long mRepaintTime = 0L;
    public int mRepaintCount = 0;
    public boolean mIncomingCall = true;

    public BounceCanvas(BounceUI bounceUI, int n) {
        super(bounceUI.mDisplay);
        this.mUI = bounceUI;
        this.mSoundHoop = this.loadSound("/sounds/up.ott");
        this.mSoundPickup = this.loadSound("/sounds/pickup.ott");
        this.mSoundPop = this.loadSound("/sounds/pop.ott");
        try {
            this.mFullScreenBuffer = Image.createImage((int)128, (int)128);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mSplashIndex = 1;
        try {
            this.mSplashImage = Image.createImage((String)SPLASH_NAME[this.mSplashIndex]);
        }
        catch (IOException iOException) {
            this.mSplashImage = Image.createImage((int)1, (int)1);
        }
        this.start();
    }

    public void resetGame(int n) {
        this.mLevelNum = n;
        this.numRings = 0;
        this.numLives = 3;
        this.mScore = 0;
        this.mLeaveGame = false;
        this.mOpenExitFlag = false;
        this.mClearScreenFlag = false;
        this.createNewLevel();
    }

    public void resetGame(int n, int n2) {
        this.mLevelNum = this.mUI.mSavedLevel;
        this.numRings = this.mUI.mSavedRings;
        this.numLives = this.mUI.mSavedLives;
        this.mScore = this.mUI.mSavedScore;
        this.disposeLevel();
        this.loadLevel(this.mLevelNum);
        this.resetTiles();
        this.mLevelDisCntr = 120;
        this.mPaintUIFlag = true;
        if (this.mUI.mSavedRespawnX != this.mStartCol && this.mUI.mSavedRespawnY != this.mStartRow) {
            this.tileMap[this.mUI.mSavedRespawnY][this.mUI.mSavedRespawnX] = (short)(8 | this.tileMap[this.mUI.mSavedRespawnY][this.mUI.mSavedRespawnX] & 0x40);
        }
        this.createBufferFocused(n, n2, this.mUI.mSavedSize, this.mUI.mSavedXSpeed, this.mUI.mSavedYSpeed);
        this.mBall.setRespawn(this.mUI.mSavedRespawnX, this.mUI.mSavedRespawnY);
        this.mBall.speedBonusCntr = this.mUI.mSavedSpeedBonus;
        this.mBall.gravBonusCntr = this.mUI.mSavedGravBonus;
        this.mBall.jumpBonusCntr = this.mUI.mSavedJumpBonus;
    }

    private void createNewLevel() {
        this.disposeLevel();
        this.loadLevel(this.mLevelNum);
        this.numRings = 0;
        this.mLevelDisCntr = 120;
        this.mPaintUIFlag = true;
        this.createBufferFocused(this.mStartCol * 12 + (this.mStartBallSize >> 1), this.mStartRow * 12 + (this.mStartBallSize >> 1), this.mStartBallSize, 0, 0);
        this.mBall.setRespawn(this.mStartCol, this.mStartRow);
    }

    public void createBufferFocused(int n, int n2, int n3, int n4, int n5) {
        int n6 = n / 12;
        int n7 = n2 / 12;
        if (n < 64) {
            this.scrollFlag = false;
            this.scrollOffset = 64;
            this.rightDrawEdge = 128;
            this.leftDrawEdge = 0;
            this.tileX = 0;
        } else if (n > this.mTileMapWidth * 12 - 64) {
            this.scrollFlag = false;
            this.scrollOffset = 92;
            this.rightDrawEdge = 156;
            this.leftDrawEdge = 28;
            this.tileX = this.mTileMapWidth - 13;
        } else {
            this.scrollFlag = true;
            this.scrollOffset = 0;
            this.rightDrawEdge = 143;
            this.leftDrawEdge = 15;
            this.tileX = n6 - 6;
        }
        this.divisorLine = 156;
        this.tileY = n7 / 7 * 7;
        this.divTileX = this.tileX + 13;
        this.divTileY = this.tileY;
        int n8 = n - this.tileX * 12;
        int n9 = n2 - this.tileY * 12 - 1;
        this.mBall = new Ball(n8, n9, n3, this);
        this.mBall.xSpeed = n4;
        this.mBall.ySpeed = n5;
        this.createNewBuffer();
    }

    public void checkData() {
        if (this.mLevelNum > this.mUI.mBestLevel) {
            this.mUI.mBestLevel = this.mLevelNum;
            this.mUI.saveGameData(1);
        }
        if (this.mScore > this.mUI.mBestScore) {
            this.mUI.mBestScore = this.mScore;
            this.mUI.mNewBestScore = true;
            this.mUI.saveGameData(2);
        }
        this.mUI.mLastScore = this.mScore;
    }

    public void screenFlip() {
        int n = this.mBall.xPos / 12;
        int n2 = this.mBall.xPos - n * 12 - 6;
        this.cleanBuffer(false);
        if (this.mBall.yPos < 0) {
            this.tileY -= 7;
            this.divTileY -= 7;
            this.mBall.yPos += 84;
        } else if (this.mBall.yPos > 96) {
            this.tileY += 7;
            this.divTileY += 7;
            this.mBall.yPos -= 84;
        }
        if (!this.scrollFlag && this.tileX - (13 - this.divisorLine / 12) == 0) {
            this.mBall.xPos = this.divisorLine < this.mBall.xPos ? (this.mBall.xPos -= this.divisorLine) : this.mBall.xPos - this.divisorLine + 156;
            this.tileX = 0;
            this.leftDrawEdge = 0;
            this.rightDrawEdge = 128;
            this.scrollOffset = 64;
        } else if (!this.scrollFlag) {
            this.tileX = this.mTileMapWidth - 13;
            this.leftDrawEdge = 28;
            this.rightDrawEdge = 156;
            this.mBall.xPos = this.mBall.xPos > this.divisorLine ? 156 - (this.divisorLine + 156 - this.mBall.xPos) : 156 - (this.divisorLine - this.mBall.xPos);
            this.scrollOffset = 92;
        } else {
            this.tileX = this.mBall.xPos > this.divisorLine ? this.tileX - 13 + n - 6 : this.tileX + n - 6;
            if (this.tileX < 0) {
                n2 += this.tileX * 12;
                this.tileX = 0;
            } else if (this.tileX > this.mTileMapWidth - 13 - 1) {
                n2 += (this.tileX - this.mTileMapWidth - 13 - 1) * 12;
                this.tileX = this.mTileMapWidth - 13 - 1;
            }
            this.leftDrawEdge = 14 + n2;
            this.rightDrawEdge = 142 + n2;
            this.mBall.xPos = 78 + n2;
        }
        this.divTileX = this.tileX + 13;
        this.divisorLine = 156;
        this.createNewBuffer();
    }

    public void add2Score(int n) {
        this.mScore += n;
        this.mPaintUIFlag = true;
    }

    public void paint2Buffer() {
        if (this.mFullScreenGraphics == null) {
            this.mFullScreenGraphics = this.mFullScreenBuffer.getGraphics();
        }
        if (this.mBall != null) {
            this.mBall.paint(this.mGameGraphics);
        }
        while (!this.hoopImageList.isEmpty()) {
            Image image = (Image)this.hoopImageList.firstElement();
            Integer n = (Integer)this.hoopXPosList.firstElement();
            Integer n2 = (Integer)this.hoopYPosList.firstElement();
            this.mGameGraphics.drawImage(image, n.intValue(), n2.intValue(), 20);
            this.hoopImageList.removeElementAt(0);
            this.hoopXPosList.removeElementAt(0);
            this.hoopYPosList.removeElementAt(0);
        }
        if (this.mGameBuffer != null) {
            if (this.leftDrawEdge < this.rightDrawEdge) {
                this.mFullScreenGraphics.drawImage(this.mGameBuffer, -this.leftDrawEdge, 0, 20);
            } else {
                this.mFullScreenGraphics.drawImage(this.mGameBuffer, -this.leftDrawEdge, 0, 20);
                this.mFullScreenGraphics.drawImage(this.mGameBuffer, 156 - this.leftDrawEdge, 0, 20);
            }
        }
        if (this.mLevelDisCntr != 0) {
            this.mFullScreenGraphics.setColor(0xFFFFFE);
            this.mFullScreenGraphics.setFont(this.TEXT_FONT);
            this.mFullScreenGraphics.drawString(this.mLevelNumStr, 44, 84, 20);
        }
        if (this.mPaintUIFlag) {
            this.mFullScreenGraphics.setColor(545706);
            this.mFullScreenGraphics.fillRect(0, 97, 128, 32);
            int n = 0;
            while (n < this.numLives) {
                this.mFullScreenGraphics.drawImage(this.mUILife, 5 + n * (this.mUILife.getWidth() - 1), 99, 20);
                ++n;
            }
            int n3 = 0;
            while (n3 < this.mTotalNumRings - this.numRings) {
                this.mFullScreenGraphics.drawImage(this.mUIRing, 5 + n3 * (this.mUIRing.getWidth() - 1), 112, 20);
                ++n3;
            }
            this.mFullScreenGraphics.setColor(0xFFFFFE);
            this.mFullScreenGraphics.drawString(BounceCanvas.zeroString(this.mScore), 64, 100, 20);
            if (this.bonusCntrValue != 0) {
                this.mFullScreenGraphics.setColor(16750611);
                this.mFullScreenGraphics.fillRect(1, 128 - 3 * this.bonusCntrValue / 30, 5, 128);
            }
            this.mPaintUIFlag = false;
        }
    }

    public void paint(Graphics graphics) {
        if (this.mSplashIndex != -1) {
            if (this.mSplashImage != null) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.mWidth, this.mHeight);
                graphics.drawImage(this.mSplashImage, this.mWidth >> 1, this.mHeight >> 1, 3);
            }
        } else if (this.mClearScreenFlag) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.mWidth, this.mHeight);
            this.mClearScreenFlag = false;
        } else {
            graphics.drawImage(this.mFullScreenBuffer, 0, 0, 20);
        }
    }

    public void run() {
        int n;
        int n2;
        if (this.mLoadLevelFlag) {
            this.createNewLevel();
            this.repaint();
            return;
        }
        if (this.mSplashIndex != -1) {
            if (this.mSplashImage == null || this.mSplashImage == null) {
                this.mIncomingCall = false;
                this.mUI.displayMainMenu();
            } else if (this.mSplashTimer > 30) {
                this.mSplashImage = null;
                Runtime.getRuntime().gc();
                switch (this.mSplashIndex) {
                    case 0: {
                        this.mSplashIndex = 1;
                        try {
                            this.mSplashImage = Image.createImage((String)SPLASH_NAME[this.mSplashIndex]);
                        }
                        catch (IOException iOException) {
                            this.mSplashImage = Image.createImage((int)1, (int)1);
                        }
                        this.repaint();
                        break;
                    }
                    case 1: {
                        this.mSplashIndex = -1;
                        this.mIncomingCall = false;
                        this.mUI.displayMainMenu();
                    }
                }
                this.mSplashTimer = 0;
            } else {
                ++this.mSplashTimer;
            }
            this.repaint();
            return;
        }
        if (this.mLevelDisCntr != 0) {
            --this.mLevelDisCntr;
        }
        if (this.mBall.yPos < 0 || this.mBall.yPos > 96) {
            this.screenFlip();
        } else {
            this.cleanBuffer(true);
            this.mBall.update();
            this.testScroll(this.mBall.xPos, this.mBall.xOffset);
        }
        if (this.mBall.ballState == 1) {
            if (this.numLives < 0) {
                this.checkData();
                this.stop();
                this.mIncomingCall = false;
                this.mUI.gameOver();
                return;
            }
            n2 = this.mBall.respawnX;
            n = this.mBall.respawnY;
            int n3 = this.mBall.respawnSize;
            this.createBufferFocused(this.mBall.respawnX * 12 + (this.mBall.respawnSize >> 1), this.mBall.respawnY * 12 + (this.mBall.respawnSize >> 1), this.mBall.respawnSize, 0, 0);
            this.mBall.respawnX = n2;
            this.mBall.respawnY = n;
            this.mBall.respawnSize = n3;
        }
        if (this.mNumMoveObj != 0) {
            this.updateMovingSpikeObj();
        }
        if (this.numRings == this.mTotalNumRings) {
            this.mOpenExitFlag = true;
        }
        if (this.mOpenExitFlag && this.mExitPos != -1) {
            n2 = this.leftDrawEdge;
            n = this.rightDrawEdge;
            if (this.mExitPos <= this.divisorLine) {
                if (this.leftDrawEdge > this.divisorLine) {
                    n2 = this.leftDrawEdge - 156;
                }
                if (this.rightDrawEdge > this.divisorLine) {
                    n = this.rightDrawEdge - 156;
                }
            }
            if (this.mExitPos > this.divisorLine) {
                if (this.leftDrawEdge < this.divisorLine) {
                    n2 = this.leftDrawEdge + 156;
                }
                if (this.rightDrawEdge < this.divisorLine) {
                    n = this.rightDrawEdge + 156;
                }
            }
            if (this.mExitPos >= n2 && this.mExitPos <= n) {
                if (this.mOpenFlag) {
                    this.mExitPos = -1;
                    this.mOpenExitFlag = false;
                } else {
                    this.openExit();
                }
                short[] sArray = this.tileMap[this.mTopLeftExitTileRow];
                int n4 = this.mTopLeftExitTileCol;
                sArray[n4] = (short)(sArray[n4] | 0x80);
                short[] sArray2 = this.tileMap[this.mTopLeftExitTileRow];
                int n5 = this.mTopLeftExitTileCol + 1;
                sArray2[n5] = (short)(sArray2[n5] | 0x80);
                short[] sArray3 = this.tileMap[this.mTopLeftExitTileRow + 1];
                int n6 = this.mTopLeftExitTileCol;
                sArray3[n6] = (short)(sArray3[n6] | 0x80);
                short[] sArray4 = this.tileMap[this.mTopLeftExitTileRow + 1];
                int n7 = this.mTopLeftExitTileCol + 1;
                sArray4[n7] = (short)(sArray4[n7] | 0x80);
                this.cleanBuffer(true);
            }
        }
        this.bonusCntrValue = 0;
        if (this.mBall.speedBonusCntr != 0 || this.mBall.gravBonusCntr != 0 || this.mBall.jumpBonusCntr != 0) {
            if (this.mBall.speedBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.mBall.speedBonusCntr;
            }
            if (this.mBall.gravBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.mBall.gravBonusCntr;
            }
            if (this.mBall.jumpBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.mBall.jumpBonusCntr;
            }
            if (this.bonusCntrValue % 30 == 0 || this.bonusCntrValue == 1) {
                this.mPaintUIFlag = true;
            }
        }
        this.scrollBuffer(this.mBall.xPos, this.mBall.xOffset, 16);
        this.paint2Buffer();
        this.repaint();
        if (this.mLeaveGame) {
            this.mLeaveGame = false;
            this.mOpenExitFlag = false;
            this.mLoadLevelFlag = true;
            ++this.mLevelNum;
            this.add2Score(5000);
            this.checkData();
            if (this.mLevelNum >= 11) {
                this.mIncomingCall = false;
                this.mUI.displayGameOver();
            } else {
                this.mIncomingCall = false;
                this.mUI.displayLevelComplete();
                this.mClearScreenFlag = false;
                this.repaint();
            }
        }
    }

    public void keyPressed(int n) {
        if (this.mSplashIndex != -1) {
            this.mSplashTimer = 31;
            return;
        }
        if (this.mBall == null) {
            return;
        }
        block0 : switch (n) {
            case 49: {
                if (!this.mCheat) break;
                this.mLoadLevelFlag = true;
                if (--this.mLevelNum >= 1) break;
                this.mLevelNum = 11;
                break;
            }
            case 51: {
                if (!this.mCheat) break;
                this.mLoadLevelFlag = true;
                if (++this.mLevelNum <= 11) break;
                this.mLevelNum = 1;
                break;
            }
            case 55: {
                if (this.mCheatSeq == 0 || this.mCheatSeq == 2) {
                    ++this.mCheatSeq;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case 56: {
                if (this.mCheatSeq == 1 || this.mCheatSeq == 3) {
                    ++this.mCheatSeq;
                    break;
                }
                if (this.mCheatSeq == 5) {
                    this.mSoundHoop.play(1);
                    this.mInvincible = true;
                    this.mCheatSeq = 0;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case 57: {
                if (this.mCheatSeq == 4) {
                    ++this.mCheatSeq;
                    break;
                }
                if (this.mCheatSeq == 5) {
                    this.mSoundPop.play(1);
                    this.mCheat = true;
                    this.mCheatSeq = 0;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case -5: {
                break;
            }
            case -7: 
            case -6: {
                this.mIncomingCall = false;
                this.mUI.displayMainMenu();
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        this.mBall.setDirection(8);
                        break block0;
                    }
                    case 6: {
                        this.mBall.setDirection(4);
                        break block0;
                    }
                    case 2: {
                        this.mBall.setDirection(1);
                        break block0;
                    }
                    case 5: {
                        this.mBall.setDirection(2);
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        if (this.mBall == null) {
            return;
        }
        switch (this.getGameAction(n)) {
            case 1: {
                this.mBall.releaseDirection(8);
                break;
            }
            case 6: {
                this.mBall.releaseDirection(4);
                break;
            }
            case 2: {
                this.mBall.releaseDirection(1);
                break;
            }
            case 5: {
                this.mBall.releaseDirection(2);
            }
        }
    }

    public static String zeroString(int n) {
        String string = n < 100 ? "0000000" : (n < 1000 ? "00000" : (n < 10000 ? "0000" : (n < 100000 ? "000" : (n < 1000000 ? "00" : (n < 10000000 ? "0" : "")))));
        return string + n;
    }

    protected Sound loadSound(String string) {
        byte[] byArray = new byte[100];
        Sound sound = null;
        DataInputStream dataInputStream = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(string));
        try {
            int n = dataInputStream.read(byArray);
            dataInputStream.close();
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            sound = new Sound(byArray2, 1);
        }
        catch (IOException iOException) {
            sound = new Sound(1000, 500L);
            sound.play(3);
        }
        return sound;
    }

    public void hideNotify() {
        if (this.mIncomingCall) {
            if (this.mBall != null) {
                this.mBall.resetDirections();
            }
            this.mUI.displayMainMenu();
        }
        this.mIncomingCall = true;
    }

    public void resetTiles() {
        int n = 0;
        while (n < this.mTileMapHeight) {
            int n2 = 0;
            while (n2 < this.mTileMapWidth) {
                byte by = (byte)(this.tileMap[n][n2] & 0xFF7F & 0xFFFFFFBF);
                switch (by) {
                    case 7: 
                    case 29: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 13: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x11 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 14: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x12 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 21: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x19 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 22: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x1A | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 15: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x13 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 16: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x14 | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 23: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x1B | this.tileMap[n][n2] & 0x40);
                        break;
                    }
                    case 24: {
                        if (!this.tileNotSavedAsActive(n, n2, by)) break;
                        this.tileMap[n][n2] = (short)(0x1C | this.tileMap[n][n2] & 0x40);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean tileNotSavedAsActive(int n, int n2, byte by) {
        int n3 = 0;
        while (n3 < this.mUI.mSavedTileCount) {
            if (this.mUI.mSavedTiles[n3][0] == n && this.mUI.mSavedTiles[n3][1] == n2) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

