/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.Ball;
import com.nokia.mid.appl.boun.Local;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class TileCanvas
extends FullCanvas {
    public int tileX;
    public int tileY;
    public int divTileX;
    public int divTileY;
    public int divisorLine;
    public int rightDrawEdge;
    public int leftDrawEdge;
    public boolean scrollFlag;
    public int scrollOffset;
    public int mExitPos;
    protected Image buffer;
    public Graphics bufferGraphics = null;
    private Image[] tileImages;
    private Image tmpTileImage;
    private Graphics tmpTileImageG;
    Vector hoopImageList;
    Vector hoopXPosList;
    Vector hoopYPosList;
    public int mLevelNum;
    public String mLevelNumStr;
    public String mLevelCompletedStr;
    public boolean mLoadLevelFlag;
    public int mStartPosX;
    public int mStartPosY;
    public int mBallSize;
    public int mExitPosX;
    public int mExitPosY;
    public short[][] tileMap;
    public int mTileMapWidth;
    public int mTileMapHeight;
    public int mTotalNumRings;
    public int mNumMoveObj;
    public short[][] mMOTopLeft;
    public short[][] mMOBotRight;
    public short[][] mMODirection;
    public short[][] mMOOffset;
    public Image[] mMOImgPtr;
    public Graphics[] mMOImgGraphics;
    public Image mSpikeImgPtr;
    public Image mUILife;
    public Image mUIRing;
    public int mTopLeftTileCol;
    public int mTopLeftTileRow;
    public int mBotRightTileCol;
    public int mBotRightTileRow;
    public Image mExitTileImage;
    public Image mImgPtr;
    public int mImageOffset;
    public boolean mOpenFlag;
    protected int mWidth = 0;
    protected int mHeight = 0;
    protected Display mDisplay;
    private GameTimer mGameTimer = null;

    public TileCanvas(Display display) {
        this.mDisplay = display;
        this.mWidth = super.getWidth();
        this.mHeight = super.getHeight();
        this.scrollFlag = true;
        this.divisorLine = 156;
        this.rightDrawEdge = 142;
        this.leftDrawEdge = 14;
        this.buffer = Image.createImage((int)156, (int)96);
        this.tmpTileImage = Image.createImage((int)12, (int)12);
        this.tmpTileImageG = this.tmpTileImage.getGraphics();
        this.loadTileImages();
        this.mLoadLevelFlag = false;
        this.tileX = 0;
        this.tileY = 0;
        this.mExitPos = -1;
        this.divTileX = this.tileX + 13;
        this.divTileY = this.tileY;
        this.tileMap = null;
        this.hoopImageList = new Vector();
        this.hoopXPosList = new Vector();
        this.hoopYPosList = new Vector();
    }

    public void loadLevel(int n) {
        InputStream inputStream = null;
        DataInputStream dataInputStream = null;
        this.mLoadLevelFlag = false;
        String string = "";
        String[] stringArray = new String[]{new Integer(this.mLevelNum).toString()};
        this.mLevelNumStr = Local.getText(14, stringArray);
        this.mLevelCompletedStr = Local.getText(15, stringArray);
        stringArray[0] = null;
        stringArray = null;
        if (n < 10) {
            string = "00" + n;
        } else if (n < 100) {
            string = "0" + n;
        }
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/levels/J2MElvl." + string);
            dataInputStream = new DataInputStream(inputStream);
            this.mStartPosX = dataInputStream.read();
            this.mStartPosY = dataInputStream.read();
            this.mBallSize = dataInputStream.read();
            this.mExitPosX = dataInputStream.read();
            this.mExitPosY = dataInputStream.read();
            this.createExitTileObject(this.mExitPosX, this.mExitPosY, this.mExitPosX + 1, this.mExitPosY + 2, this.tileImages[12]);
            this.mTotalNumRings = dataInputStream.read();
            this.mTileMapWidth = dataInputStream.read();
            this.mTileMapHeight = dataInputStream.read();
            this.tileMap = new short[this.mTileMapHeight][this.mTileMapWidth];
            int n2 = 0;
            while (n2 < this.mTileMapHeight) {
                int n3 = 0;
                while (n3 < this.mTileMapWidth) {
                    this.tileMap[n2][n3] = (short)dataInputStream.read();
                    ++n3;
                }
                ++n2;
            }
            this.mNumMoveObj = dataInputStream.read();
            if (this.mNumMoveObj != 0) {
                this.createMovingObj(dataInputStream);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error trying to read file: " + iOException);
        }
    }

    public static Image manipulateImage(Image image, int n) {
        Image image2 = DirectUtils.createImage((int)image.getWidth(), (int)image.getHeight(), (int)0);
        if (image2 == null) {
            image2 = Image.createImage((int)image.getWidth(), (int)image.getHeight());
        }
        Graphics graphics = image2.getGraphics();
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        switch (n) {
            case 0: {
                directGraphics.drawImage(image, 0, 0, 20, 8192);
                break;
            }
            case 1: {
                directGraphics.drawImage(image, 0, 0, 20, 16384);
                break;
            }
            case 2: {
                directGraphics.drawImage(image, 0, 0, 20, 24576);
                break;
            }
            case 3: {
                directGraphics.drawImage(image, 0, 0, 20, 90);
                break;
            }
            case 4: {
                directGraphics.drawImage(image, 0, 0, 20, 180);
                break;
            }
            case 5: {
                directGraphics.drawImage(image, 0, 0, 20, 270);
                break;
            }
            default: {
                graphics.drawImage(image, 0, 0, 20);
            }
        }
        return image2;
    }

    public void createMovingObj(DataInputStream dataInputStream) throws IOException {
        this.mMOTopLeft = new short[this.mNumMoveObj][2];
        this.mMOBotRight = new short[this.mNumMoveObj][2];
        this.mMODirection = new short[this.mNumMoveObj][2];
        this.mMOOffset = new short[this.mNumMoveObj][2];
        this.mMOImgPtr = new Image[this.mNumMoveObj];
        this.mMOImgGraphics = new Graphics[this.mNumMoveObj];
        int n = 0;
        while (n < this.mNumMoveObj) {
            this.mMOTopLeft[n][0] = (short)dataInputStream.read();
            this.mMOTopLeft[n][1] = (short)dataInputStream.read();
            this.mMOBotRight[n][0] = (short)dataInputStream.read();
            this.mMOBotRight[n][1] = (short)dataInputStream.read();
            this.mMODirection[n][0] = (short)dataInputStream.read();
            this.mMODirection[n][1] = (short)dataInputStream.read();
            int n2 = dataInputStream.read();
            int n3 = dataInputStream.read();
            this.mMOOffset[n][0] = (short)n2;
            this.mMOOffset[n][1] = (short)n3;
            ++n;
        }
        this.mSpikeImgPtr = Image.createImage((int)24, (int)24);
        Graphics graphics = this.mSpikeImgPtr.getGraphics();
        graphics.drawImage(this.tileImages[46], 0, 0, 20);
        graphics.drawImage(TileCanvas.manipulateImage(this.tileImages[46], 0), 12, 0, 20);
        graphics.drawImage(TileCanvas.manipulateImage(this.tileImages[46], 4), 12, 12, 20);
        graphics.drawImage(TileCanvas.manipulateImage(this.tileImages[46], 1), 0, 12, 20);
        graphics = null;
    }

    public void disposeLevel() {
        int n = 0;
        while (n < this.mNumMoveObj) {
            this.mMOImgPtr[n] = null;
            this.mMOImgGraphics[n] = null;
            ++n;
        }
        this.mMOImgPtr = null;
        this.mMOImgGraphics = null;
        this.tileMap = null;
        Runtime.getRuntime().gc();
    }

    public void updateMovingSpikeObj() {
        int n = 0;
        while (n < this.mNumMoveObj) {
            int n2;
            short s = this.mMOTopLeft[n][0];
            short s2 = this.mMOTopLeft[n][1];
            int n3 = this.mMOOffset[n][0];
            int n4 = this.mMOOffset[n][1];
            short[] sArray = this.mMOOffset[n];
            sArray[0] = (short)(sArray[0] + this.mMODirection[n][0]);
            int n5 = (this.mMOBotRight[n][0] - s - 2) * 12;
            int n6 = (this.mMOBotRight[n][1] - s2 - 2) * 12;
            if (this.mMOOffset[n][0] < 0) {
                this.mMOOffset[n][0] = 0;
            } else if (this.mMOOffset[n][0] > n5) {
                this.mMOOffset[n][0] = (short)n5;
            }
            if (this.mMOOffset[n][0] == 0 || this.mMOOffset[n][0] == n5) {
                this.mMODirection[n][0] = -this.mMODirection[n][0];
            }
            short[] sArray2 = this.mMOOffset[n];
            sArray2[1] = (short)(sArray2[1] + this.mMODirection[n][1]);
            if (this.mMOOffset[n][1] < 0) {
                this.mMOOffset[n][1] = 0;
            } else if (this.mMOOffset[n][1] > n6) {
                this.mMOOffset[n][1] = (short)n6;
            }
            if (this.mMOOffset[n][1] == 0 || this.mMOOffset[n][1] == n6) {
                short[] sArray3 = this.mMODirection[n];
                sArray3[1] = (short)(sArray3[1] * -1);
            }
            int n7 = this.mMOOffset[n][0];
            int n8 = this.mMOOffset[n][1];
            if (n7 < n3) {
                n2 = n7;
                n7 = n3;
                n3 = n2;
            }
            if (n8 < n4) {
                n2 = n8;
                n8 = n4;
                n4 = n2;
            }
            n7 += 23;
            n8 += 23;
            n4 /= 12;
            n7 = n7 / 12 + 1;
            n8 = n8 / 12 + 1;
            n2 = n3 /= 12;
            while (n2 < n7) {
                int n9 = n4;
                while (n9 < n8) {
                    short[] sArray4 = this.tileMap[s2 + n9];
                    int n10 = s + n2;
                    sArray4[n10] = (short)(sArray4[n10] | 0x80);
                    ++n9;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int findSpikeIndex(int n, int n2) {
        int n3 = 0;
        while (n3 < this.mNumMoveObj) {
            if (this.mMOTopLeft[n3][0] <= n && this.mMOBotRight[n3][0] > n && this.mMOTopLeft[n3][1] <= n2 && this.mMOBotRight[n3][1] > n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void drawTile(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        if (this.bufferGraphics == null) {
            this.bufferGraphics = this.buffer.getGraphics();
        }
        if ((this.tileMap[n2][n] & 0x80) != 0) {
            short[] sArray = this.tileMap[n2];
            int n6 = n;
            sArray[n6] = (short)(sArray[n6] & 0xFF7F);
        }
        boolean bl2 = bl = ((n5 = this.tileMap[n2][n]) & 0x40) != 0;
        if (bl) {
            n5 &= 0xFFFFFFBF;
        }
        this.bufferGraphics.setColor(bl ? 1073328 : 11591920);
        switch (n5) {
            case 1: {
                this.bufferGraphics.drawImage(this.tileImages[0], n3, n4, 20);
                break;
            }
            case 0: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                break;
            }
            case 2: {
                this.bufferGraphics.drawImage(this.tileImages[1], n3, n4, 20);
                break;
            }
            case 3: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[6], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[2], n3, n4, 20);
                break;
            }
            case 4: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[9], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[5], n3, n4, 20);
                break;
            }
            case 5: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[7], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[3], n3, n4, 20);
                break;
            }
            case 6: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[8], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[4], n3, n4, 20);
                break;
            }
            case 7: {
                this.bufferGraphics.drawImage(this.tileImages[10], n3, n4, 20);
                break;
            }
            case 8: {
                this.bufferGraphics.drawImage(this.tileImages[11], n3, n4, 20);
                break;
            }
            case 23: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[13], n3, n4, 20);
                this.add2HoopList(this.tileImages[14], n3, n4);
                break;
            }
            case 24: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[15], n3, n4, 20);
                this.add2HoopList(this.tileImages[16], n3, n4);
                break;
            }
            case 15: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[17], n3, n4, 20);
                this.add2HoopList(this.tileImages[18], n3, n4);
                break;
            }
            case 16: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[19], n3, n4, 20);
                this.add2HoopList(this.tileImages[20], n3, n4);
                break;
            }
            case 27: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[21], n3, n4, 20);
                this.add2HoopList(this.tileImages[22], n3, n4);
                break;
            }
            case 28: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[23], n3, n4, 20);
                this.add2HoopList(this.tileImages[24], n3, n4);
                break;
            }
            case 19: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[25], n3, n4, 20);
                this.add2HoopList(this.tileImages[26], n3, n4);
                break;
            }
            case 20: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[27], n3, n4, 20);
                this.add2HoopList(this.tileImages[28], n3, n4);
                break;
            }
            case 21: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[31], n3, n4, 20);
                this.add2HoopList(this.tileImages[29], n3, n4);
                break;
            }
            case 22: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[32], n3, n4, 20);
                this.add2HoopList(this.tileImages[30], n3, n4);
                break;
            }
            case 13: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[35], n3, n4, 20);
                this.add2HoopList(this.tileImages[33], n3, n4);
                break;
            }
            case 14: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[36], n3, n4, 20);
                this.add2HoopList(this.tileImages[34], n3, n4);
                break;
            }
            case 25: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[39], n3, n4, 20);
                this.add2HoopList(this.tileImages[37], n3, n4);
                break;
            }
            case 26: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[40], n3, n4, 20);
                this.add2HoopList(this.tileImages[38], n3, n4);
                break;
            }
            case 17: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[43], n3, n4, 20);
                this.add2HoopList(this.tileImages[41], n3, n4);
                break;
            }
            case 18: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[44], n3, n4, 20);
                this.add2HoopList(this.tileImages[42], n3, n4);
                break;
            }
            case 9: {
                int n7 = (n - this.mTopLeftTileCol) * 12;
                int n8 = (n2 - this.mTopLeftTileRow) * 12;
                this.bufferGraphics.drawImage(this.mExitTileImage, n3 - n7, n4 - n8, 20);
                this.mExitPos = n3 - n7 + 12 - 1;
                break;
            }
            case 10: {
                int n9 = this.findSpikeIndex(n, n2);
                if (n9 == -1) break;
                int n10 = (n - this.mMOTopLeft[n9][0]) * 12;
                int n11 = (n2 - this.mMOTopLeft[n9][1]) * 12;
                int n12 = this.mMOOffset[n9][0] - n10;
                int n13 = this.mMOOffset[n9][1] - n11;
                if (n12 > -36 && n12 < 12 || n13 > -36 && n13 < 12) {
                    this.tmpTileImageG.setColor(11591920);
                    this.tmpTileImageG.fillRect(0, 0, 12, 12);
                    this.tmpTileImageG.drawImage(this.mSpikeImgPtr, n12, n13, 20);
                    this.bufferGraphics.drawImage(this.tmpTileImage, n3, n4, 20);
                    break;
                }
                this.bufferGraphics.setColor(11591920);
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                break;
            }
            case 29: {
                this.bufferGraphics.drawImage(this.tileImages[45], n3, n4, 20);
                break;
            }
            case 30: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[61], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[57], n3, n4, 20);
                break;
            }
            case 31: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[60], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[56], n3, n4, 20);
                break;
            }
            case 32: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[59], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[55], n3, n4, 20);
                break;
            }
            case 33: {
                if (bl) {
                    this.bufferGraphics.drawImage(this.tileImages[62], n3, n4, 20);
                    break;
                }
                this.bufferGraphics.drawImage(this.tileImages[58], n3, n4, 20);
                break;
            }
            case 34: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[65], n3, n4, 20);
                break;
            }
            case 35: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[64], n3, n4, 20);
                break;
            }
            case 36: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[63], n3, n4, 20);
                break;
            }
            case 37: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[66], n3, n4, 20);
                break;
            }
            case 39: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[50], n3, n4, 20);
                break;
            }
            case 40: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[50], 5), n3, n4, 20);
                break;
            }
            case 41: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[50], 4), n3, n4, 20);
                break;
            }
            case 42: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[50], 3), n3, n4, 20);
                break;
            }
            case 43: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(this.tileImages[51], n3, n4, 20);
                break;
            }
            case 44: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[51], 5), n3, n4, 20);
                break;
            }
            case 45: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[51], 4), n3, n4, 20);
                break;
            }
            case 46: {
                this.bufferGraphics.fillRect(n3, n4, 12, 12);
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[51], 3), n3, n4, 20);
                break;
            }
            case 47: {
                this.bufferGraphics.drawImage(this.tileImages[52], n3, n4, 20);
                break;
            }
            case 48: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[52], 5), n3, n4, 20);
                break;
            }
            case 49: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[52], 4), n3, n4, 20);
                break;
            }
            case 50: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[52], 3), n3, n4, 20);
                break;
            }
            case 38: {
                this.bufferGraphics.drawImage(this.tileImages[53], n3, n4, 20);
                break;
            }
            case 51: {
                this.bufferGraphics.drawImage(this.tileImages[54], n3, n4, 20);
                break;
            }
            case 52: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[54], 5), n3, n4, 20);
                break;
            }
            case 53: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[54], 4), n3, n4, 20);
                break;
            }
            case 54: {
                this.bufferGraphics.drawImage(TileCanvas.manipulateImage(this.tileImages[54], 3), n3, n4, 20);
                break;
            }
        }
    }

    public void add2HoopList(Image image, int n, int n2) {
        this.hoopImageList.addElement(image);
        this.hoopXPosList.addElement(new Integer(n));
        this.hoopYPosList.addElement(new Integer(n2));
    }

    public void createNewBuffer() {
        int n = 0;
        while (n < 13) {
            int n2 = 0;
            while (n2 < 8) {
                this.drawTile(this.tileX + n, this.tileY + n2, n * 12, n2 * 12);
                ++n2;
            }
            ++n;
        }
    }

    public void cleanBuffer(boolean bl) {
        int n = this.tileX;
        int n2 = this.tileY;
        int n3 = 0;
        while (n3 < 13) {
            if (n3 * 12 >= this.divisorLine && n >= this.tileX) {
                n = this.divTileX - 13;
            }
            int n4 = 0;
            while (n4 < 8) {
                if ((this.tileMap[n2][n] & 0x80) != 0) {
                    short[] sArray = this.tileMap[n2];
                    int n5 = n;
                    sArray[n5] = (short)(sArray[n5] & 0xFF7F);
                    if (bl) {
                        this.drawTile(n, n2, n3 * 12, n4 * 12);
                    }
                }
                ++n2;
                ++n4;
            }
            n2 = this.tileY;
            ++n;
            ++n3;
        }
    }

    public void scrollBuffer(int n, int n2, int n3) {
        block17: {
            int n4;
            int n5;
            block18: {
                if (this.rightDrawEdge < 0) {
                    this.rightDrawEdge += 156;
                }
                if (this.rightDrawEdge > this.divisorLine && this.rightDrawEdge <= this.divisorLine + 12) {
                    if (this.tileX + this.divisorLine / 12 >= this.mTileMapWidth) {
                        this.leftDrawEdge -= n2;
                        this.rightDrawEdge -= n2;
                        if (this.rightDrawEdge < 0) {
                            this.rightDrawEdge += 156;
                        }
                        if (this.scrollFlag) {
                            this.scrollFlag = false;
                            this.scrollOffset = this.rightDrawEdge - 64;
                            if (this.scrollOffset < n3) {
                                this.scrollOffset += 156;
                            }
                        }
                    } else {
                        if (this.divisorLine >= 156) {
                            this.divisorLine = 0;
                            this.tileX += 13;
                        }
                        if (this.rightDrawEdge >= 156) {
                            this.rightDrawEdge -= 156;
                        }
                        n5 = this.divisorLine;
                        this.divisorLine += 12;
                        ++this.divTileX;
                        n4 = 0;
                        while (n4 < 8) {
                            this.drawTile(this.tileX + n5 / 12, this.tileY + n4, n5, n4 * 12);
                            ++n4;
                        }
                    }
                } else if (this.rightDrawEdge > 156) {
                    this.rightDrawEdge -= 156;
                }
                if (this.leftDrawEdge >= 156) {
                    this.leftDrawEdge -= 156;
                }
                if (this.leftDrawEdge < 0) {
                    this.leftDrawEdge += 156;
                }
                if (this.leftDrawEdge >= this.divisorLine || this.leftDrawEdge < this.divisorLine - 12) break block17;
                if (this.tileX - (13 - this.divisorLine / 12) > 0) break block18;
                this.leftDrawEdge -= n2;
                this.rightDrawEdge -= n2;
                if (this.leftDrawEdge >= 156) {
                    this.leftDrawEdge -= 156;
                }
                if (!this.scrollFlag) break block17;
                this.scrollFlag = false;
                this.scrollOffset = (this.leftDrawEdge + 64) % 156;
                if (this.scrollOffset >= n3) break block17;
                this.scrollOffset += 156;
                break block17;
            }
            this.divisorLine -= 12;
            n5 = this.divisorLine;
            --this.divTileX;
            if (this.divisorLine <= 0) {
                this.divisorLine = 156;
                this.tileX -= 13;
            }
            n4 = 0;
            while (n4 < 8) {
                this.drawTile(this.divTileX - 13, this.divTileY + n4, n5, n4 * 12);
                ++n4;
            }
        }
    }

    void testScroll(int n, int n2) {
        if (!this.scrollFlag) {
            if (this.tileX - (13 - this.divisorLine / 12) <= 0 && n >= this.scrollOffset && n < this.scrollOffset + 10) {
                this.scrollFlag = true;
                n2 = n - this.scrollOffset;
            }
            if (this.tileX + this.divisorLine / 12 >= this.mTileMapWidth && n <= this.scrollOffset && n > this.scrollOffset - 10) {
                this.scrollFlag = true;
                n2 = n - this.scrollOffset;
            }
        }
        if (this.scrollFlag) {
            this.leftDrawEdge += n2;
            this.rightDrawEdge += n2;
        }
    }

    public Image createLargeBallImage(Image image) {
        Image image2 = DirectUtils.createImage((int)16, (int)16, (int)0);
        if (image2 == null) {
            image2 = Image.createImage((int)16, (int)16);
        }
        Graphics graphics = image2.getGraphics();
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        graphics.drawImage(image, -4, -4, 20);
        directGraphics.drawImage(image, 8, -4, 20, 8192);
        directGraphics.drawImage(image, -4, 8, 20, 16384);
        directGraphics.drawImage(image, 8, 8, 20, 180);
        return image2;
    }

    public Image createExitImage(Image image) {
        Image image2 = Image.createImage((int)24, (int)48);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(11591920);
        graphics.fillRect(0, 0, 24, 48);
        graphics.setColor(16555422);
        graphics.fillRect(4, 0, 16, 48);
        graphics.setColor(14891583);
        graphics.fillRect(6, 0, 10, 48);
        graphics.setColor(12747918);
        graphics.fillRect(10, 0, 4, 48);
        graphics.drawImage(image, 0, 0, 20);
        graphics.drawImage(TileCanvas.manipulateImage(image, 0), 12, 0, 20);
        graphics.drawImage(TileCanvas.manipulateImage(image, 1), 0, 12, 20);
        graphics.drawImage(TileCanvas.manipulateImage(image, 2), 12, 12, 20);
        return image2;
    }

    public void loadTileImages() {
        Image image = TileCanvas.loadImage("/icons/objects_nm.png");
        this.tileImages = new Image[67];
        this.tileImages[0] = TileCanvas.extractImage(image, 1, 0);
        this.tileImages[1] = TileCanvas.extractImage(image, 1, 2);
        this.tileImages[2] = TileCanvas.extractImageBG(image, 0, 3, -5185296);
        this.tileImages[3] = TileCanvas.manipulateImage(this.tileImages[2], 1);
        this.tileImages[4] = TileCanvas.manipulateImage(this.tileImages[2], 3);
        this.tileImages[5] = TileCanvas.manipulateImage(this.tileImages[2], 5);
        this.tileImages[6] = TileCanvas.extractImageBG(image, 0, 3, -15703888);
        this.tileImages[7] = TileCanvas.manipulateImage(this.tileImages[6], 1);
        this.tileImages[8] = TileCanvas.manipulateImage(this.tileImages[6], 3);
        this.tileImages[9] = TileCanvas.manipulateImage(this.tileImages[6], 5);
        this.tileImages[10] = TileCanvas.extractImage(image, 0, 4);
        this.tileImages[11] = TileCanvas.extractImage(image, 3, 4);
        this.tileImages[12] = this.createExitImage(TileCanvas.extractImage(image, 2, 3));
        this.tileImages[14] = TileCanvas.extractImage(image, 0, 5);
        this.tileImages[13] = TileCanvas.manipulateImage(this.tileImages[14], 1);
        this.tileImages[15] = TileCanvas.manipulateImage(this.tileImages[13], 0);
        this.tileImages[16] = TileCanvas.manipulateImage(this.tileImages[14], 0);
        this.tileImages[18] = TileCanvas.extractImage(image, 1, 5);
        this.tileImages[17] = TileCanvas.manipulateImage(this.tileImages[18], 1);
        this.tileImages[19] = TileCanvas.manipulateImage(this.tileImages[17], 0);
        this.tileImages[20] = TileCanvas.manipulateImage(this.tileImages[18], 0);
        this.tileImages[22] = TileCanvas.extractImage(image, 2, 5);
        this.tileImages[21] = TileCanvas.manipulateImage(this.tileImages[22], 1);
        this.tileImages[23] = TileCanvas.manipulateImage(this.tileImages[21], 0);
        this.tileImages[24] = TileCanvas.manipulateImage(this.tileImages[22], 0);
        this.tileImages[26] = TileCanvas.extractImage(image, 3, 5);
        this.tileImages[25] = TileCanvas.manipulateImage(this.tileImages[26], 1);
        this.tileImages[27] = TileCanvas.manipulateImage(this.tileImages[25], 0);
        this.tileImages[28] = TileCanvas.manipulateImage(this.tileImages[26], 0);
        this.tileImages[29] = TileCanvas.manipulateImage(this.tileImages[14], 5);
        this.tileImages[30] = TileCanvas.manipulateImage(this.tileImages[29], 1);
        this.tileImages[31] = TileCanvas.manipulateImage(this.tileImages[29], 0);
        this.tileImages[32] = TileCanvas.manipulateImage(this.tileImages[30], 0);
        this.tileImages[33] = TileCanvas.manipulateImage(this.tileImages[18], 5);
        this.tileImages[34] = TileCanvas.manipulateImage(this.tileImages[33], 1);
        this.tileImages[35] = TileCanvas.manipulateImage(this.tileImages[33], 0);
        this.tileImages[36] = TileCanvas.manipulateImage(this.tileImages[34], 0);
        this.tileImages[37] = TileCanvas.manipulateImage(this.tileImages[22], 5);
        this.tileImages[38] = TileCanvas.manipulateImage(this.tileImages[37], 1);
        this.tileImages[39] = TileCanvas.manipulateImage(this.tileImages[37], 0);
        this.tileImages[40] = TileCanvas.manipulateImage(this.tileImages[38], 0);
        this.tileImages[41] = TileCanvas.manipulateImage(this.tileImages[26], 5);
        this.tileImages[42] = TileCanvas.manipulateImage(this.tileImages[41], 1);
        this.tileImages[43] = TileCanvas.manipulateImage(this.tileImages[41], 0);
        this.tileImages[44] = TileCanvas.manipulateImage(this.tileImages[42], 0);
        this.tileImages[45] = TileCanvas.extractImage(image, 3, 3);
        this.tileImages[46] = TileCanvas.extractImage(image, 1, 3);
        this.tileImages[47] = TileCanvas.extractImage(image, 2, 0);
        this.tileImages[48] = TileCanvas.extractImage(image, 0, 1);
        this.tileImages[49] = this.createLargeBallImage(TileCanvas.extractImage(image, 3, 0));
        this.tileImages[50] = TileCanvas.extractImage(image, 3, 1);
        this.tileImages[51] = TileCanvas.extractImage(image, 2, 4);
        this.tileImages[52] = TileCanvas.extractImage(image, 3, 2);
        this.tileImages[53] = TileCanvas.extractImage(image, 1, 1);
        this.tileImages[54] = TileCanvas.extractImage(image, 2, 2);
        this.tileImages[55] = TileCanvas.extractImageBG(image, 0, 0, -5185296);
        this.tileImages[56] = TileCanvas.manipulateImage(this.tileImages[55], 3);
        this.tileImages[57] = TileCanvas.manipulateImage(this.tileImages[55], 4);
        this.tileImages[58] = TileCanvas.manipulateImage(this.tileImages[55], 5);
        this.tileImages[59] = TileCanvas.extractImageBG(image, 0, 0, -15703888);
        this.tileImages[60] = TileCanvas.manipulateImage(this.tileImages[59], 3);
        this.tileImages[61] = TileCanvas.manipulateImage(this.tileImages[59], 4);
        this.tileImages[62] = TileCanvas.manipulateImage(this.tileImages[59], 5);
        this.tileImages[63] = TileCanvas.extractImage(image, 0, 2);
        this.tileImages[64] = TileCanvas.manipulateImage(this.tileImages[63], 3);
        this.tileImages[65] = TileCanvas.manipulateImage(this.tileImages[63], 4);
        this.tileImages[66] = TileCanvas.manipulateImage(this.tileImages[63], 5);
        this.mUILife = TileCanvas.extractImage(image, 2, 1);
        this.mUIRing = TileCanvas.extractImage(image, 1, 4);
    }

    public void setBallImages(Ball ball) {
        ball.smallBallImage = this.tileImages[47];
        ball.poppedImage = this.tileImages[48];
        ball.largeBallImage = this.tileImages[49];
    }

    public static Image extractImage(Image image, int n, int n2) {
        return TileCanvas.extractImageBG(image, n, n2, 0);
    }

    public static Image extractImageBG(Image image, int n, int n2, int n3) {
        Graphics graphics;
        Image image2 = DirectUtils.createImage((int)12, (int)12, (int)n3);
        if (image2 == null) {
            image2 = Image.createImage((int)12, (int)12);
            graphics = image2.getGraphics();
            graphics.setColor(n3);
            graphics.fillRect(0, 0, 12, 12);
        }
        graphics = image2.getGraphics();
        graphics.drawImage(image, -n * 12, -n2 * 12, 20);
        return image2;
    }

    public static Image loadImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public Image getImage(int n) {
        if (n < 67) {
            return this.tileImages[n];
        }
        return null;
    }

    public void createExitTileObject(int n, int n2, int n3, int n4, Image image) {
        this.mTopLeftTileCol = n;
        this.mTopLeftTileRow = n2;
        this.mBotRightTileCol = n3;
        this.mBotRightTileRow = n4;
        this.mImgPtr = image;
        this.mExitTileImage = Image.createImage((int)24, (int)24);
        this.mImageOffset = 0;
        this.repaintExitTile();
        this.mOpenFlag = false;
    }

    public void repaintExitTile() {
        Graphics graphics = this.mExitTileImage.getGraphics();
        graphics.drawImage(this.mImgPtr, 0, 0 - this.mImageOffset, 20);
    }

    public void openExit() {
        this.mImageOffset += 4;
        if (this.mImageOffset >= 24) {
            this.mImageOffset = 24;
            this.mOpenFlag = true;
        }
        this.repaintExitTile();
    }

    public static boolean rectCollide(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n <= n7 && n2 <= n8 && n5 <= n3 && n6 <= n4;
    }

    public abstract void run();

    public synchronized void start() {
        if (this.mGameTimer != null) {
            return;
        }
        this.mGameTimer = new GameTimer(this);
    }

    public synchronized void stop() {
        if (this.mGameTimer == null) {
            return;
        }
        this.mGameTimer.stop();
        this.mGameTimer = null;
    }

    protected void timerTrigger() {
        this.run();
    }

    protected class GameTimer
    extends TimerTask {
        TileCanvas parent;
        Timer timer;

        public GameTimer(TileCanvas tileCanvas2) {
            this.parent = tileCanvas2;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)this, 0L, 30L);
        }

        public void run() {
            this.parent.timerTrigger();
        }

        void stop() {
            if (this.timer == null) {
                return;
            }
            this.cancel();
            this.timer.cancel();
            this.timer = null;
        }
    }
}

